/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.transform;

import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysis;
import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysisSimplifier;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitor;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitorException;
import org.jinq.jpa.jpqlquery.ColumnExpressions;
import org.jinq.jpa.jpqlquery.Expression;
import org.jinq.jpa.jpqlquery.FromAliasExpression;
import org.jinq.jpa.jpqlquery.JPQLQuery;
import org.jinq.jpa.jpqlquery.SelectFromWhere;
import org.jinq.jpa.jpqlquery.SelectOnly;
import org.jinq.jpa.jpqlquery.TupleRowReader;
import org.jinq.jpa.transform.JPQLOneLambdaQueryTransform;
import org.jinq.jpa.transform.LambdaInfo;
import org.jinq.jpa.transform.MetamodelUtil;
import org.jinq.jpa.transform.QueryTransformException;
import org.jinq.jpa.transform.SelectFromWhereLambdaArgumentHandler;
import org.jinq.jpa.transform.SymbExArgumentHandler;
import org.jinq.jpa.transform.SymbExPassDown;
import org.jinq.jpa.transform.SymbExToSubQuery;

public class JoinTransform
extends JPQLOneLambdaQueryTransform {
    boolean withSource;

    public JoinTransform(MetamodelUtil metamodel, ClassLoader alternateClassLoader, boolean withSource) {
        super(metamodel, alternateClassLoader);
        this.withSource = withSource;
    }

    static boolean isSimpleFrom(JPQLQuery<?> query) {
        if (!query.isSelectFromWhere()) {
            return false;
        }
        SelectFromWhere sfw = (SelectFromWhere)query;
        if (sfw.where != null) {
            return false;
        }
        if (sfw.froms.size() != 1) {
            return false;
        }
        if (!sfw.cols.isSingleColumn()) {
            return false;
        }
        Expression expr = sfw.cols.getOnlyColumn();
        if (!(expr instanceof FromAliasExpression)) {
            return false;
        }
        return ((FromAliasExpression)expr).from == sfw.froms.get(0);
    }

    @Override
    public <U, V> JPQLQuery<U> apply(JPQLQuery<V> query, LambdaInfo lambda, SymbExArgumentHandler parentArgumentScope) throws QueryTransformException {
        try {
            if (query.isSelectFromWhere()) {
                SelectFromWhere sfw = (SelectFromWhere)query;
                SymbExToSubQuery translator = new SymbExToSubQuery(this.metamodel, this.alternateClassLoader, SelectFromWhereLambdaArgumentHandler.fromSelectFromWhere(sfw, lambda, this.metamodel, parentArgumentScope, this.withSource));
                if (lambda.symbolicAnalysis.paths.size() > 1) {
                    throw new QueryTransformException("Can only handle a single path in a JOIN at the moment");
                }
                SymbExPassDown passdown = SymbExPassDown.with(null, false);
                JPQLQuery returnExpr = (JPQLQuery)PathAnalysisSimplifier.simplify((TypedValue)((PathAnalysis)lambda.symbolicAnalysis.paths.get(0)).getReturnValue(), this.metamodel.comparisonMethods).visit((TypedValueVisitor)translator, (Object)passdown);
                if (JoinTransform.isSimpleFrom(returnExpr)) {
                    SelectFromWhere toMerge = (SelectFromWhere)returnExpr;
                    SelectOnly toReturn = sfw.shallowCopy();
                    ((SelectFromWhere)toReturn).froms.add(toMerge.froms.get(0));
                    ((SelectFromWhere)toReturn).cols = new ColumnExpressions(TupleRowReader.createReaderForTuple(TupleRowReader.PAIR_CLASS, sfw.cols.reader, toMerge.cols.reader));
                    ((SelectFromWhere)toReturn).cols.columns.addAll(sfw.cols.columns);
                    ((SelectFromWhere)toReturn).cols.columns.addAll(toMerge.cols.columns);
                    return toReturn;
                }
            }
            throw new QueryTransformException("Existing query cannot be transformed further");
        }
        catch (TypedValueVisitorException e) {
            throw new QueryTransformException(e);
        }
    }
}

