/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.transform;

import ch.epfl.labos.iu.orm.queryll2.path.MethodAnalysisResults;
import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysisFactory;
import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysisSimplifier;
import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysisSupplementalFactory;
import ch.epfl.labos.iu.orm.queryll2.path.TransformationClassAnalyzer;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import com.user00.thunk.SerializedLambda;
import java.io.IOException;
import java.util.List;
import org.jinq.jpa.transform.MetamodelUtil;
import org.jinq.jpa.transform.MethodChecker;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.analysis.AnalyzerException;

public class LambdaInfo {
    Object Lambda;
    SerializedLambda serializedLambda;
    List<TypedValue> indirectCapturedArgs;
    MethodAnalysisResults symbolicAnalysis;
    int numCapturedArgs;
    int numLambdaArgs;
    int lambdaIndex;

    public static LambdaInfo analyze(MetamodelUtil metamodel, ClassLoader alternateClassLoader, Object lambda, int lambdaIndex, boolean throwExceptionOnFailure) {
        SerializedLambda s;
        try {
            s = SerializedLambda.extractLambda((Object)lambda);
            if (s == null) {
                if (throwExceptionOnFailure) {
                    throw new IllegalArgumentException("Could not extract code from lambda. This error sometimes occurs because your lambda references objects that aren't Serializable.");
                }
                return null;
            }
        }
        catch (Exception e) {
            if (throwExceptionOnFailure) {
                throw new IllegalArgumentException("Could not extract code from lambda. This error sometimes occurs because your lambda references objects that aren't Serializable.");
            }
            return null;
        }
        try {
            MethodAnalysisResults analysis = LambdaInfo.analyzeLambda(metamodel, alternateClassLoader, s);
            if (analysis == null) {
                if (throwExceptionOnFailure) {
                    throw new IllegalArgumentException("Could not analyze lambda code");
                }
                return null;
            }
            return new LambdaInfo(lambda, s, analysis, lambdaIndex);
        }
        catch (Exception e) {
            if (throwExceptionOnFailure) {
                throw new IllegalArgumentException("Could not analyze lambda code", e);
            }
            return null;
        }
    }

    public static LambdaInfo analyzeMethod(MetamodelUtil metamodel, ClassLoader alternateClassLoader, Handle lambdaHandle, List<TypedValue> indirectCapturedArgs, boolean throwExceptionOnFailure) {
        try {
            MethodAnalysisResults analysis = LambdaInfo.analyzeLambda(metamodel, alternateClassLoader, lambdaHandle.getOwner(), lambdaHandle.getName(), lambdaHandle.getDesc());
            if (analysis == null) {
                if (throwExceptionOnFailure) {
                    throw new IllegalArgumentException("Could not analyze lambda code");
                }
                return null;
            }
            return new LambdaInfo(analysis, indirectCapturedArgs, Type.getArgumentTypes((String)lambdaHandle.getDesc()).length);
        }
        catch (IOException e) {
            if (throwExceptionOnFailure) {
                throw new IllegalArgumentException("Encountered problems when trying to load the code for your lambdas. You may need to supply a lambdaClassLoader hint to Jinq to help it find your lambdas.", e);
            }
            return null;
        }
        catch (AnalyzerException e) {
            if (throwExceptionOnFailure) {
                throw new IllegalArgumentException("Could not analyze lambda code", e);
            }
            return null;
        }
    }

    private static MethodAnalysisResults analyzeLambda(MetamodelUtil metamodel, ClassLoader alternateClassLoader, SerializedLambda lambda) throws IOException, AnalyzerException {
        if (lambda == null) {
            return null;
        }
        return LambdaInfo.analyzeLambda(metamodel, alternateClassLoader, lambda.implClass, lambda.implMethodName, lambda.implMethodSignature);
    }

    private static MethodAnalysisResults analyzeLambda(MetamodelUtil metamodel, ClassLoader alternateClassLoader, String className, String methodName, String methodSignature) throws IOException, AnalyzerException {
        PathAnalysisFactory pathAnalysisFactory = new PathAnalysisFactory(() -> new MethodChecker(metamodelUtil.safeMethodAnnotations, metamodelUtil.safeMethods, metamodelUtil.safeStaticMethods));
        TransformationClassAnalyzer classAnalyzer = new TransformationClassAnalyzer(className, alternateClassLoader);
        MethodAnalysisResults analysis = (MethodAnalysisResults)classAnalyzer.analyzeLambdaMethod(methodName, methodSignature, (PathAnalysisSupplementalFactory)pathAnalysisFactory);
        PathAnalysisSimplifier.cleanAndSimplify((MethodAnalysisResults)analysis, metamodel.comparisonMethods);
        return analysis;
    }

    LambdaInfo(Object lambda, SerializedLambda serializedLambda, MethodAnalysisResults symbolicAnalysis, int lambdaIndex) {
        this.Lambda = lambda;
        this.serializedLambda = serializedLambda;
        this.symbolicAnalysis = symbolicAnalysis;
        this.lambdaIndex = lambdaIndex;
        this.numCapturedArgs = serializedLambda.capturedArgs.length;
        this.numLambdaArgs = Type.getArgumentTypes((String)serializedLambda.implMethodSignature).length;
    }

    LambdaInfo(MethodAnalysisResults symbolicAnalysis, List<TypedValue> indirectCapturedArgs, int numLambdaArgs) {
        this.symbolicAnalysis = symbolicAnalysis;
        this.lambdaIndex = -1;
        this.indirectCapturedArgs = indirectCapturedArgs;
        this.numCapturedArgs = indirectCapturedArgs.size();
        this.numLambdaArgs = numLambdaArgs;
    }

    public int getNumCapturedArgs() {
        return this.numCapturedArgs;
    }

    public int getNumLambdaArgs() {
        return this.numLambdaArgs;
    }

    public boolean hasLambdaObject() {
        return this.serializedLambda != null;
    }

    public TypedValue getIndirectCapturedArg(int argIndex) {
        return this.indirectCapturedArgs.get(argIndex);
    }

    public Object getCapturedArg(int argIndex) {
        return this.serializedLambda.capturedArgs[argIndex];
    }
}

