/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.transform;

import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitorException;
import java.util.HashSet;
import java.util.Set;
import org.jinq.jpa.jpqlquery.ColumnExpressions;
import org.jinq.jpa.jpqlquery.JPQLQuery;
import org.jinq.jpa.jpqlquery.ParameterExpression;
import org.jinq.jpa.jpqlquery.SimpleRowReader;
import org.jinq.jpa.transform.LambdaInfo;
import org.jinq.jpa.transform.MetamodelUtil;
import org.jinq.jpa.transform.SymbExArgumentHandler;
import org.objectweb.asm.Type;

public class LambdaParameterArgumentHandler
implements SymbExArgumentHandler {
    LambdaInfo lambda;
    MetamodelUtil metamodel;
    boolean hasInQueryStreamSource;
    SymbExArgumentHandler parentArgumentScope;
    final int numLambdaCapturedArgs;
    final int numLambdaArgs;
    public static final Set<Type> ALLOWED_QUERY_PARAMETER_TYPES = new HashSet<Type>();

    public LambdaParameterArgumentHandler(LambdaInfo lambda, MetamodelUtil metamodel, SymbExArgumentHandler parentArgumentScope, boolean hasInQueryStreamSource) {
        this.lambda = lambda;
        this.metamodel = metamodel;
        this.hasInQueryStreamSource = hasInQueryStreamSource;
        this.numLambdaCapturedArgs = lambda.getNumCapturedArgs();
        this.numLambdaArgs = lambda.getNumLambdaArgs();
        this.parentArgumentScope = parentArgumentScope;
    }

    protected ColumnExpressions<?> handleLambdaArg(int argIndex, Type argType) throws TypedValueVisitorException {
        throw new TypedValueVisitorException("Unhandled lambda arguments");
    }

    protected ColumnExpressions<?> handleIndirectLambdaArg(int argIndex, Type argType) throws TypedValueVisitorException {
        TypedValue paramVal = this.lambda.getIndirectCapturedArg(argIndex);
        if (paramVal instanceof TypedValue.ArgValue) {
            TypedValue.ArgValue paramArg = (TypedValue.ArgValue)paramVal;
            int parentArgIndex = paramArg.getIndex();
            if (this.parentArgumentScope == null) {
                throw new TypedValueVisitorException("Cannot find a parent scope to determine how to access as sublambda's parent parameters.");
            }
            return this.parentArgumentScope.handleArg(parentArgIndex, argType);
        }
        throw new TypedValueVisitorException("Jinq can only passthrough parent lambda parameters directly to sub-lambdas. Sublambdas cannot take parameters that involve computation.");
    }

    protected ColumnExpressions<?> getAndValidateArg(int argIndex, Type argType) throws TypedValueVisitorException {
        if (!ALLOWED_QUERY_PARAMETER_TYPES.contains(argType) && !this.metamodel.isKnownEnumType(argType.getInternalName())) {
            throw new TypedValueVisitorException("Accessing a field with unhandled type");
        }
        return ColumnExpressions.singleColumn(new SimpleRowReader(), new ParameterExpression(this.lambda.lambdaIndex, argIndex));
    }

    @Override
    public ColumnExpressions<?> handleArg(int argIndex, Type argType) throws TypedValueVisitorException {
        if (argIndex < this.numLambdaCapturedArgs) {
            if (this.lambda == null) {
                throw new TypedValueVisitorException("No lambda source was supplied where parameters can be extracted");
            }
            if (!this.lambda.hasLambdaObject()) {
                return this.handleIndirectLambdaArg(argIndex, argType);
            }
            return this.getAndValidateArg(argIndex, argType);
        }
        if (this.checkIsInQueryStreamSource(argIndex)) {
            throw new TypedValueVisitorException("Using InQueryStreamSource as data");
        }
        return this.handleLambdaArg(argIndex - this.numLambdaCapturedArgs, argType);
    }

    protected JPQLQuery<?> handleLambdaSubQueryArg(int argIndex, Type argType) throws TypedValueVisitorException {
        throw new TypedValueVisitorException("Unhandled lambda subquery arguments");
    }

    @Override
    public JPQLQuery<?> handleSubQueryArg(int argIndex, Type argType) throws TypedValueVisitorException {
        if (argIndex >= this.numLambdaCapturedArgs && !this.checkIsInQueryStreamSource(argIndex)) {
            return this.handleLambdaSubQueryArg(argIndex - this.numLambdaCapturedArgs, argType);
        }
        throw new TypedValueVisitorException("Cannot use parameters as a subquery");
    }

    @Override
    public boolean checkIsInQueryStreamSource(int argIndex) {
        return this.hasInQueryStreamSource && argIndex == this.numLambdaArgs - 1;
    }

    static {
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.INT_TYPE);
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.DOUBLE_TYPE);
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.LONG_TYPE);
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.BOOLEAN_TYPE);
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.getObjectType((String)"java/lang/Integer"));
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.getObjectType((String)"java/lang/Double"));
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.getObjectType((String)"java/lang/Long"));
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.getObjectType((String)"java/lang/Boolean"));
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.getObjectType((String)"java/lang/String"));
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.getObjectType((String)"java/sql/Date"));
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.getObjectType((String)"java/sql/Time"));
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.getObjectType((String)"java/sql/Timestamp"));
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.getObjectType((String)"java/util/Date"));
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.getObjectType((String)"java/util/Calendar"));
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.getObjectType((String)"java/math/BigDecimal"));
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.getObjectType((String)"java/math/BigInteger"));
    }
}

