/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.transform;

import ch.epfl.labos.iu.orm.queryll2.path.TransformationClassAnalyzer;
import ch.epfl.labos.iu.orm.queryll2.symbolic.ConstantValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.LambdaFactory;
import ch.epfl.labos.iu.orm.queryll2.symbolic.MethodCallValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.MethodSignature;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitor;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitorException;
import org.jinq.jpa.jpqlquery.ColumnExpressions;
import org.jinq.jpa.jpqlquery.Expression;
import org.jinq.jpa.jpqlquery.From;
import org.jinq.jpa.jpqlquery.FromAliasExpression;
import org.jinq.jpa.jpqlquery.JPQLQuery;
import org.jinq.jpa.jpqlquery.ReadFieldExpression;
import org.jinq.jpa.jpqlquery.SelectFromWhere;
import org.jinq.jpa.jpqlquery.SimpleRowReader;
import org.jinq.jpa.transform.DistinctTransform;
import org.jinq.jpa.transform.JoinTransform;
import org.jinq.jpa.transform.LambdaInfo;
import org.jinq.jpa.transform.MetamodelUtil;
import org.jinq.jpa.transform.MethodChecker;
import org.jinq.jpa.transform.QueryTransformException;
import org.jinq.jpa.transform.SelectTransform;
import org.jinq.jpa.transform.SymbExArgumentHandler;
import org.jinq.jpa.transform.SymbExPassDown;
import org.jinq.jpa.transform.SymbExToColumns;
import org.jinq.jpa.transform.WhereTransform;
import org.objectweb.asm.Type;

public class SymbExToSubQuery
extends TypedValueVisitor<SymbExPassDown, JPQLQuery<?>, TypedValueVisitorException> {
    final MetamodelUtil metamodel;
    final SymbExArgumentHandler argHandler;
    final ClassLoader alternateClassLoader;

    SymbExToSubQuery(MetamodelUtil metamodel, ClassLoader alternateClassLoader, SymbExArgumentHandler argumentHandler) {
        this.metamodel = metamodel;
        this.argHandler = argumentHandler;
        this.alternateClassLoader = alternateClassLoader;
    }

    public JPQLQuery<?> defaultValue(TypedValue val, SymbExPassDown in) throws TypedValueVisitorException {
        throw new TypedValueVisitorException("Unhandled symbolic execution operation: " + val);
    }

    public JPQLQuery<?> argValue(TypedValue.ArgValue val, SymbExPassDown in) throws TypedValueVisitorException {
        int index = val.getIndex();
        return this.argHandler.handleSubQueryArg(index, val.getType());
    }

    private boolean isStreamMethod(MethodSignature sig) {
        return sig.equals((Object)MethodChecker.streamDistinct) || sig.equals((Object)MethodChecker.streamSelect) || sig.equals((Object)MethodChecker.streamWhere) || sig.equals((Object)MethodChecker.streamJoin);
    }

    public JPQLQuery<?> virtualMethodCallValue(MethodCallValue.VirtualMethodCallValue val, SymbExPassDown in) throws TypedValueVisitorException {
        MethodSignature sig = val.getSignature();
        if (MetamodelUtil.inQueryStream.equals((Object)sig)) {
            if (!(val.base instanceof TypedValue.ArgValue)) {
                throw new TypedValueVisitorException("InQueryStreamSource comes from unknown source");
            }
            int index = ((TypedValue.ArgValue)val.base).getIndex();
            if (!this.argHandler.checkIsInQueryStreamSource(index)) {
                throw new TypedValueVisitorException("InQueryStreamSource comes from unknown source");
            }
            if (!(val.args.get(0) instanceof ConstantValue.ClassConstant)) {
                throw new TypedValueVisitorException("Streaming an unknown type");
            }
            Type type = ((ConstantValue.ClassConstant)val.args.get((int)0)).val;
            String entityName = this.metamodel.entityNameFromClassName(type.getClassName());
            if (entityName == null) {
                throw new TypedValueVisitorException("Streaming an unknown type");
            }
            return JPQLQuery.findAllEntities(entityName);
        }
        if (this.isStreamMethod(sig)) {
            SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, false);
            JPQLQuery subQuery = (JPQLQuery)val.base.visit((TypedValueVisitor)this, (Object)passdown);
            LambdaInfo lambda = null;
            if (val.args.size() > 0) {
                if (!(val.args.get(0) instanceof LambdaFactory)) {
                    throw new TypedValueVisitorException("Expecting a lambda factory for aggregate method");
                }
                LambdaFactory lambdaFactory = (LambdaFactory)val.args.get(0);
                try {
                    lambda = LambdaInfo.analyzeMethod(this.metamodel, this.alternateClassLoader, lambdaFactory.getLambdaMethod(), lambdaFactory.getCapturedArgs(), true);
                }
                catch (Exception e) {
                    throw new TypedValueVisitorException("Could not analyze the lambda code", (Throwable)e);
                }
            }
            try {
                JPQLQuery transformedQuery;
                if (sig.equals((Object)MethodChecker.streamDistinct)) {
                    DistinctTransform transform = new DistinctTransform(this.metamodel, this.alternateClassLoader);
                    transformedQuery = transform.apply(subQuery, this.argHandler);
                } else if (sig.equals((Object)MethodChecker.streamSelect)) {
                    SelectTransform transform = new SelectTransform(this.metamodel, this.alternateClassLoader, false);
                    transformedQuery = transform.apply(subQuery, lambda, this.argHandler);
                } else if (sig.equals((Object)MethodChecker.streamWhere)) {
                    WhereTransform transform = new WhereTransform(this.metamodel, this.alternateClassLoader, false);
                    transformedQuery = transform.apply(subQuery, lambda, this.argHandler);
                } else if (sig.equals((Object)MethodChecker.streamJoin)) {
                    JoinTransform transform = new JoinTransform(this.metamodel, this.alternateClassLoader, false);
                    transformedQuery = transform.apply(subQuery, lambda, this.argHandler);
                } else {
                    throw new TypedValueVisitorException("Unknown stream operation: " + sig);
                }
                return transformedQuery;
            }
            catch (QueryTransformException e) {
                throw new TypedValueVisitorException("Subquery could not be transformed.", (Throwable)e);
            }
        }
        return (JPQLQuery)super.virtualMethodCallValue(val, (Object)in);
    }

    private JPQLQuery<?> handlePossibleNavigationalLink(TypedValue unknownVal, boolean expectingPluralLink, SymbExPassDown in) throws TypedValueVisitorException {
        if (unknownVal instanceof MethodCallValue.VirtualMethodCallValue) {
            MethodCallValue.VirtualMethodCallValue val = (MethodCallValue.VirtualMethodCallValue)unknownVal;
            MethodSignature sig = val.getSignature();
            if (expectingPluralLink && this.metamodel.isPluralAttributeLinkMethod(sig) || !expectingPluralLink && this.metamodel.isSingularAttributeFieldMethod(sig) && this.metamodel.isFieldMethodAssociationType(sig)) {
                Expression expr;
                String linkName = expectingPluralLink ? this.metamodel.nLinkMethodToLinkName(sig) : this.metamodel.fieldMethodToFieldName(sig);
                SymbExToColumns translator = new SymbExToColumns(this.metamodel, this.alternateClassLoader, this.argHandler);
                SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, false);
                ColumnExpressions nLinkBase = (ColumnExpressions)val.base.visit((TypedValueVisitor)translator, (Object)passdown);
                if (nLinkBase.isSingleColumn() && !((expr = nLinkBase.getOnlyColumn()) instanceof FromAliasExpression) && !(expr instanceof ReadFieldExpression)) {
                    return null;
                }
                SelectFromWhere query = new SelectFromWhere();
                From from = From.forNavigationalLinks(new ReadFieldExpression(nLinkBase.getOnlyColumn(), linkName));
                query.cols = ColumnExpressions.singleColumn(new SimpleRowReader(), new FromAliasExpression(from));
                query.froms.add(from);
                return query;
            }
        }
        return null;
    }

    public JPQLQuery<?> staticMethodCallValue(MethodCallValue.StaticMethodCallValue val, SymbExPassDown in) throws TypedValueVisitorException {
        JPQLQuery<?> nLink;
        MethodSignature sig = val.getSignature();
        if (sig.equals((Object)TransformationClassAnalyzer.streamFrom)) {
            JPQLQuery<?> nLink2 = this.handlePossibleNavigationalLink((TypedValue)val.args.get(0), true, in);
            if (nLink2 != null) {
                return nLink2;
            }
        } else if (sig.equals((Object)TransformationClassAnalyzer.streamOf) && (nLink = this.handlePossibleNavigationalLink((TypedValue)val.args.get(0), false, in)) != null) {
            return nLink;
        }
        return (JPQLQuery)super.staticMethodCallValue(val, (Object)in);
    }
}

