/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.transform;

import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysis;
import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysisSimplifier;
import ch.epfl.labos.iu.orm.queryll2.symbolic.ConstantValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitor;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitorException;
import org.jinq.jpa.jpqlquery.BinaryExpression;
import org.jinq.jpa.jpqlquery.ColumnExpressions;
import org.jinq.jpa.jpqlquery.Expression;
import org.jinq.jpa.jpqlquery.GroupedSelectFromWhere;
import org.jinq.jpa.jpqlquery.JPQLQuery;
import org.jinq.jpa.jpqlquery.SelectFromWhere;
import org.jinq.jpa.jpqlquery.SelectOnly;
import org.jinq.jpa.transform.JPQLOneLambdaQueryTransform;
import org.jinq.jpa.transform.LambdaInfo;
import org.jinq.jpa.transform.MetamodelUtil;
import org.jinq.jpa.transform.QueryTransformException;
import org.jinq.jpa.transform.SelectFromWhereLambdaArgumentHandler;
import org.jinq.jpa.transform.SymbExArgumentHandler;
import org.jinq.jpa.transform.SymbExPassDown;
import org.jinq.jpa.transform.SymbExToColumns;

public class WhereTransform
extends JPQLOneLambdaQueryTransform {
    boolean withSource;

    public WhereTransform(MetamodelUtil metamodel, ClassLoader alternateClassLoader, boolean withSource) {
        super(metamodel, alternateClassLoader);
        this.withSource = withSource;
    }

    @Override
    public <U, V> JPQLQuery<U> apply(JPQLQuery<V> query, LambdaInfo where, SymbExArgumentHandler parentArgumentScope) throws QueryTransformException {
        try {
            if (query.isSelectFromWhere()) {
                SelectFromWhere sfw = (SelectFromWhere)query;
                Expression methodExpr = this.computeWhereReturnExpr(where, sfw, parentArgumentScope);
                SelectOnly toReturn = sfw.shallowCopy();
                ((SelectFromWhere)toReturn).where = sfw.where == null ? methodExpr : new BinaryExpression("AND", sfw.where, methodExpr);
                return toReturn;
            }
            if (query.isSelectFromWhereGroupHaving()) {
                GroupedSelectFromWhere sfw = (GroupedSelectFromWhere)query;
                Expression methodExpr = this.computeWhereReturnExpr(where, sfw, parentArgumentScope);
                SelectFromWhere toReturn = sfw.shallowCopy();
                ((GroupedSelectFromWhere)toReturn).having = sfw.having == null ? methodExpr : new BinaryExpression("AND", sfw.having, methodExpr);
                return toReturn;
            }
            throw new QueryTransformException("Existing query cannot be transformed further");
        }
        catch (TypedValueVisitorException e) {
            throw new QueryTransformException(e);
        }
    }

    private <V> Expression computeWhereReturnExpr(LambdaInfo where, SelectFromWhere<V> sfw, SymbExArgumentHandler parentArgumentScope) throws TypedValueVisitorException, QueryTransformException {
        SymbExToColumns translator = new SymbExToColumns(this.metamodel, this.alternateClassLoader, SelectFromWhereLambdaArgumentHandler.fromSelectFromWhere(sfw, where, this.metamodel, parentArgumentScope, this.withSource));
        Expression methodExpr = null;
        for (int n = 0; n < where.symbolicAnalysis.paths.size(); ++n) {
            SymbExPassDown returnPassdown;
            PathAnalysis path = (PathAnalysis)where.symbolicAnalysis.paths.get(n);
            TypedValue returnVal = PathAnalysisSimplifier.simplifyBoolean((TypedValue)path.getReturnValue(), this.metamodel.comparisonMethods);
            ColumnExpressions returnColumns = (ColumnExpressions)returnVal.visit((TypedValueVisitor)translator, (Object)(returnPassdown = SymbExPassDown.with(null, true)));
            if (!returnColumns.isSingleColumn()) {
                throw new QueryTransformException("Expecting single column");
            }
            Expression returnExpr = returnColumns.getOnlyColumn();
            if (returnVal instanceof ConstantValue.BooleanConstant) {
                if (!((ConstantValue.BooleanConstant)returnVal).val) continue;
                returnExpr = null;
            }
            Expression conditionExpr = this.pathConditionsToExpr(translator, path);
            Expression pathExpr = returnExpr;
            if (conditionExpr != null) {
                pathExpr = pathExpr == null ? conditionExpr : new BinaryExpression("AND", pathExpr, conditionExpr);
            }
            methodExpr = methodExpr != null ? new BinaryExpression("OR", methodExpr, pathExpr) : pathExpr;
        }
        return methodExpr;
    }
}

