/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.mapstruct.ap.model.common.ModelElement;
import org.mapstruct.ap.util.Executables;
import org.mapstruct.ap.util.Filters;
import org.mapstruct.ap.util.Nouns;
import org.mapstruct.ap.util.TypeUtilsJDK6Fix;

public class Type
extends ModelElement
implements Comparable<Type> {
    private final Types typeUtils;
    private final Elements elementUtils;
    private final TypeMirror typeMirror;
    private final TypeElement typeElement;
    private final List<Type> typeParameters;
    private final Type implementationType;
    private final String packageName;
    private final String name;
    private final String qualifiedName;
    private final boolean isInterface;
    private final boolean isEnumType;
    private final boolean isIterableType;
    private final boolean isCollectionType;
    private final boolean isMapType;
    private final boolean isImported;
    private final List<String> enumConstants;
    private List<ExecutableElement> getters = null;
    private List<ExecutableElement> setters = null;
    private List<ExecutableElement> adders = null;
    private List<ExecutableElement> alternativeTargetAccessors = null;

    public Type(Types typeUtils, Elements elementUtils, TypeMirror typeMirror, TypeElement typeElement, List<Type> typeParameters, Type implementationType, String packageName, String name, String qualifiedName, boolean isInterface, boolean isEnumType, boolean isIterableType, boolean isCollectionType, boolean isMapType, boolean isImported) {
        this.typeUtils = typeUtils;
        this.elementUtils = elementUtils;
        this.typeMirror = typeMirror;
        this.typeElement = typeElement;
        this.typeParameters = typeParameters;
        this.implementationType = implementationType;
        this.packageName = packageName;
        this.name = name;
        this.qualifiedName = qualifiedName;
        this.isInterface = isInterface;
        this.isEnumType = isEnumType;
        this.isIterableType = isIterableType;
        this.isCollectionType = isCollectionType;
        this.isMapType = isMapType;
        this.isImported = isImported;
        if (isEnumType) {
            this.enumConstants = new ArrayList<String>();
            for (Element element : typeElement.getEnclosedElements()) {
                if (element.getKind() != ElementKind.ENUM_CONSTANT || !element.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                this.enumConstants.add(element.getSimpleName().toString());
            }
        } else {
            this.enumConstants = Collections.emptyList();
        }
    }

    public TypeMirror getTypeMirror() {
        return this.typeMirror;
    }

    public TypeElement getTypeElement() {
        return this.typeElement;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getName() {
        return this.name;
    }

    public List<Type> getTypeParameters() {
        return this.typeParameters;
    }

    public boolean isPrimitive() {
        return this.typeMirror.getKind().isPrimitive();
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isEnumType() {
        return this.isEnumType;
    }

    public List<String> getEnumConstants() {
        return this.enumConstants;
    }

    public Type getImplementationType() {
        return this.implementationType;
    }

    public boolean isIterableType() {
        return this.isIterableType;
    }

    public boolean isCollectionType() {
        return this.isCollectionType;
    }

    public boolean isMapType() {
        return this.isMapType;
    }

    public boolean isCollectionOrMapType() {
        return this.isCollectionType || this.isMapType;
    }

    public String getFullyQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public Set<Type> getImportTypes() {
        return this.implementationType != null ? Collections.singleton(this.implementationType) : Collections.emptySet();
    }

    public boolean isImported() {
        return this.isImported;
    }

    public boolean isAnnotatedWith(String annotationTypeName) {
        List<? extends AnnotationMirror> annotationMirrors = this.typeElement.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            Name mirrorAnnotationName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!mirrorAnnotationName.contentEquals(annotationTypeName)) continue;
            return true;
        }
        return false;
    }

    public Type erasure() {
        return new Type(this.typeUtils, this.elementUtils, this.typeUtils.erasure(this.typeMirror), this.typeElement, this.typeParameters, this.implementationType, this.packageName, this.name, this.qualifiedName, this.isInterface, this.isEnumType, this.isIterableType, this.isCollectionType, this.isMapType, this.isImported);
    }

    public boolean isAssignableTo(Type other) {
        if (this.equals(other)) {
            return true;
        }
        return this.typeUtils.isAssignable(this.typeMirror, other.typeMirror);
    }

    public List<ExecutableElement> getGetters() {
        if (this.getters == null) {
            List<? extends Element> members = this.elementUtils.getAllMembers(this.typeElement);
            this.getters = Collections.unmodifiableList(Filters.getterMethodsIn(members));
        }
        return this.getters;
    }

    public ExecutableElement getAdderForType(Type collectionProperty, String pluralPropertyName) {
        ArrayList<ExecutableElement> candidates = new ArrayList<ExecutableElement>();
        if (collectionProperty.isCollectionType && !collectionProperty.getTypeParameters().isEmpty()) {
            TypeMirror typeArg = collectionProperty.getTypeParameters().get(0).getTypeMirror();
            List<ExecutableElement> adderList = this.getAdders();
            for (ExecutableElement adder : adderList) {
                VariableElement arg = adder.getParameters().get(0);
                if (!arg.asType().equals(typeArg)) continue;
                candidates.add(adder);
            }
        }
        if (candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() == 1) {
            return (ExecutableElement)candidates.get(0);
        }
        for (ExecutableElement candidate : candidates) {
            String elementName = Executables.getElementNameForAdder(candidate);
            if (!elementName.equals(Nouns.singularize(pluralPropertyName))) continue;
            return candidate;
        }
        return null;
    }

    public List<ExecutableElement> getSetters() {
        if (this.setters == null) {
            List<? extends Element> members = this.elementUtils.getAllMembers(this.typeElement);
            this.setters = Collections.unmodifiableList(Filters.setterMethodsIn(members));
        }
        return this.setters;
    }

    private List<ExecutableElement> getAdders() {
        if (this.adders == null) {
            List<? extends Element> members = this.elementUtils.getAllMembers(this.typeElement);
            this.adders = Collections.unmodifiableList(Filters.adderMethodsIn(members));
        }
        return this.adders;
    }

    public List<ExecutableElement> getAlternativeTargetAccessors() {
        if (this.alternativeTargetAccessors == null) {
            ArrayList<ExecutableElement> result = new ArrayList<ExecutableElement>();
            List<ExecutableElement> setterMethods = this.getSetters();
            List<ExecutableElement> getterMethods = this.getGetters();
            for (ExecutableElement getterMethod : getterMethods) {
                if (!this.isCollectionOrMap(getterMethod) || this.correspondingSetterMethodExists(getterMethod, setterMethods)) continue;
                result.add(getterMethod);
            }
            this.alternativeTargetAccessors = Collections.unmodifiableList(result);
        }
        return this.alternativeTargetAccessors;
    }

    private boolean correspondingSetterMethodExists(ExecutableElement getterMethod, List<ExecutableElement> setterMethods) {
        String getterPropertyName = Executables.getPropertyName(getterMethod);
        for (ExecutableElement setterMethod : setterMethods) {
            String setterPropertyName = Executables.getPropertyName(setterMethod);
            if (!getterPropertyName.equals(setterPropertyName)) continue;
            return true;
        }
        return false;
    }

    private boolean isCollectionOrMap(ExecutableElement getterMethod) {
        return this.isCollection(getterMethod.getReturnType()) || this.isMap(getterMethod.getReturnType());
    }

    private boolean isCollection(TypeMirror candidate) {
        return this.isSubType(candidate, Collection.class);
    }

    private boolean isMap(TypeMirror candidate) {
        return this.isSubType(candidate, Map.class);
    }

    private boolean isSubType(TypeMirror candidate, Class<?> clazz) {
        String className = clazz.getCanonicalName();
        TypeMirror classType = this.typeUtils.erasure(this.elementUtils.getTypeElement(className).asType());
        return TypeUtilsJDK6Fix.isSubType(this.typeUtils, candidate, classType);
    }

    public int distanceTo(Type assignableOther) {
        return this.distanceTo(this.typeMirror, assignableOther.typeMirror);
    }

    private int distanceTo(TypeMirror base, TypeMirror targetType) {
        if (this.typeUtils.isSameType(base, targetType)) {
            return 0;
        }
        if (!this.typeUtils.isAssignable(base, targetType)) {
            return -1;
        }
        List<? extends TypeMirror> directSupertypes = this.typeUtils.directSupertypes(base);
        int minDistanceOfSuperToTargetType = Integer.MAX_VALUE;
        for (TypeMirror typeMirror : directSupertypes) {
            int distanceToTargetType = this.distanceTo(typeMirror, targetType);
            if (distanceToTargetType < 0) continue;
            minDistanceOfSuperToTargetType = Math.min(minDistanceOfSuperToTargetType, distanceToTargetType);
        }
        return 1 + minDistanceOfSuperToTargetType;
    }

    public boolean canAccess(Type type, ExecutableElement method) {
        if (method.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return false;
        }
        if (method.getModifiers().contains((Object)Modifier.PROTECTED)) {
            return this.isAssignableTo(type) || this.getPackageName().equals(type.getPackageName());
        }
        if (!method.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return this.getPackageName().equals(type.getPackageName());
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Type other = (Type)obj;
        return this.typeUtils.isSameType(this.typeMirror, other.typeMirror);
    }

    @Override
    public int compareTo(Type o) {
        return this.getFullyQualifiedName().compareTo(o.getFullyQualifiedName());
    }

    public String toString() {
        return this.typeMirror.toString();
    }
}

