/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model.source;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import org.mapstruct.ap.prism.MappingPrism;
import org.mapstruct.ap.prism.MappingsPrism;
import org.mapstruct.ap.util.AnnotationProcessingException;

public class Mapping {
    private static final Pattern JAVA_EXPRESSION = Pattern.compile("^java\\((.*)\\)$");
    private final String sourceName;
    private final String sourceParameterName;
    private final String sourcePropertyName;
    private final String constant;
    private final String expression;
    private final String javaExpression;
    private final String targetName;
    private final String dateFormat;
    private final boolean isIgnored;
    private final AnnotationMirror mirror;
    private final AnnotationValue sourceAnnotationValue;
    private final AnnotationValue targetAnnotationValue;

    public static Map<String, List<Mapping>> fromMappingsPrism(MappingsPrism mappingsAnnotation, Element element, Messager messager) {
        HashMap<String, List<Mapping>> mappings = new HashMap<String, List<Mapping>>();
        for (MappingPrism mappingPrism : mappingsAnnotation.value()) {
            Mapping mapping;
            if (!mappings.containsKey(mappingPrism.source())) {
                mappings.put(mappingPrism.source(), new ArrayList());
            }
            if ((mapping = Mapping.fromMappingPrism(mappingPrism, element, messager)) == null) continue;
            ((List)mappings.get(mappingPrism.source())).add(mapping);
        }
        return mappings;
    }

    public static Mapping fromMappingPrism(MappingPrism mappingPrism, Element element, Messager messager) {
        String[] sourceNameParts = Mapping.getSourceNameParts(mappingPrism.source(), element, mappingPrism.mirror, mappingPrism.values.source());
        if (mappingPrism.source().isEmpty() && mappingPrism.constant().isEmpty() && mappingPrism.expression().isEmpty() && !mappingPrism.ignore().booleanValue()) {
            messager.printMessage(Diagnostic.Kind.ERROR, "Either define a source, a constant or an expression in a Mapping", element);
            return null;
        }
        if (!mappingPrism.source().isEmpty() && !mappingPrism.constant().isEmpty()) {
            messager.printMessage(Diagnostic.Kind.ERROR, "Source and constant are both defined in Mapping, either define a source or a constant", element);
            return null;
        }
        if (!mappingPrism.source().isEmpty() && !mappingPrism.expression().isEmpty()) {
            messager.printMessage(Diagnostic.Kind.ERROR, "Source and expression are both defined in Mapping, either define a source or an expression", element);
            return null;
        }
        if (!mappingPrism.expression().isEmpty() && !mappingPrism.constant().isEmpty()) {
            messager.printMessage(Diagnostic.Kind.ERROR, "Expression and constant are both defined in Mapping, either define an expression or a constant", element);
            return null;
        }
        return new Mapping(mappingPrism.source(), sourceNameParts != null ? sourceNameParts[0] : null, sourceNameParts != null ? sourceNameParts[1] : mappingPrism.source(), mappingPrism.constant(), mappingPrism.expression(), mappingPrism.target(), mappingPrism.dateFormat(), mappingPrism.ignore(), mappingPrism.mirror, mappingPrism.values.source(), mappingPrism.values.target());
    }

    private static String[] getSourceNameParts(String sourceName, Element element, AnnotationMirror annotationMirror, AnnotationValue annotationValue) {
        if (!sourceName.contains(".")) {
            return null;
        }
        String[] parts = sourceName.split("\\.");
        if (parts.length != 2) {
            throw new AnnotationProcessingException("Mapping of nested attributes not supported yet.", element, annotationMirror, annotationValue);
        }
        return parts;
    }

    private Mapping(String sourceName, String sourceParameterName, String sourcePropertyName, String constant, String expression, String targetName, String dateFormat, boolean isIgnored, AnnotationMirror mirror, AnnotationValue sourceAnnotationValue, AnnotationValue targetAnnotationValue) {
        this.sourceName = sourceName;
        this.sourceParameterName = sourceParameterName;
        this.sourcePropertyName = sourcePropertyName;
        this.constant = constant;
        this.expression = expression;
        Matcher javaExpressionMatcher = JAVA_EXPRESSION.matcher(expression);
        this.javaExpression = javaExpressionMatcher.matches() ? javaExpressionMatcher.group(1).trim() : "";
        this.targetName = targetName.equals("") ? sourceName : targetName;
        this.dateFormat = dateFormat;
        this.isIgnored = isIgnored;
        this.mirror = mirror;
        this.sourceAnnotationValue = sourceAnnotationValue;
        this.targetAnnotationValue = targetAnnotationValue;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getSourcePropertyName() {
        return this.sourcePropertyName;
    }

    public String getSourceParameterName() {
        return this.sourceParameterName;
    }

    public String getConstant() {
        return this.constant;
    }

    public String getJavaExpression() {
        return this.javaExpression;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public boolean isIgnored() {
        return this.isIgnored;
    }

    public AnnotationMirror getMirror() {
        return this.mirror;
    }

    public AnnotationValue getSourceAnnotationValue() {
        return this.sourceAnnotationValue;
    }

    public AnnotationValue getTargetAnnotationValue() {
        return this.targetAnnotationValue;
    }

    public Mapping reverse() {
        Mapping reverse = null;
        if (this.constant != null && this.expression != null) {
            reverse = new Mapping(this.targetName, null, this.targetName, this.constant, this.expression, this.sourceName, this.dateFormat, this.isIgnored, this.mirror, this.sourceAnnotationValue, this.targetAnnotationValue);
        }
        return reverse;
    }

    public String toString() {
        return "Mapping {\n    sourceName='" + this.sourceName + "'," + "\n    targetName='" + this.targetName + "'," + "\n}";
    }
}

