/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model.source;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;
import org.mapstruct.ap.model.common.Type;
import org.mapstruct.ap.model.source.SourceMethod;
import org.mapstruct.ap.util.TypeUtilsJDK6Fix;

public class MethodMatcher {
    private final SourceMethod candidateMethod;
    private final Types typeUtils;

    MethodMatcher(Types typeUtils, SourceMethod candidateMethod) {
        this.typeUtils = typeUtils;
        this.candidateMethod = candidateMethod;
    }

    boolean matches(List<Type> sourceTypes, Type targetType) {
        List<? extends VariableElement> candidateParameters = this.candidateMethod.getExecutable().getParameters();
        if (candidateParameters.size() != sourceTypes.size()) {
            return false;
        }
        HashMap<TypeVariable, TypeMirror> genericTypesMap = new HashMap<TypeVariable, TypeMirror>();
        int i = 0;
        Iterator<? extends VariableElement> iterator = candidateParameters.iterator();
        while (iterator.hasNext()) {
            TypeMatcher parameterMatcher = new TypeMatcher(Assignability.VISITED_ASSIGNABLE_FROM, genericTypesMap);
            VariableElement candidateParameter = iterator.next();
            if (((Boolean)parameterMatcher.visit(candidateParameter.asType(), sourceTypes.get(i++).getTypeMirror())).booleanValue()) continue;
            return false;
        }
        TypeMatcher returnTypeMatcher = new TypeMatcher(Assignability.VISITED_ASSIGNABLE_TO, genericTypesMap);
        TypeMirror candidateReturnType = this.candidateMethod.getExecutable().getReturnType();
        if (!((Boolean)returnTypeMatcher.visit(candidateReturnType, targetType.getTypeMirror())).booleanValue()) {
            if (targetType.isPrimitive()) {
                TypeMatcher boxedReturnTypeMatcher = new TypeMatcher(Assignability.VISITED_ASSIGNABLE_TO, genericTypesMap);
                TypeMirror boxedType = this.typeUtils.boxedClass((PrimitiveType)targetType.getTypeMirror()).asType();
                if (!((Boolean)boxedReturnTypeMatcher.visit(candidateReturnType, boxedType)).booleanValue()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (this.candidateMethod.getExecutable().getTypeParameters().size() != genericTypesMap.size()) {
            return false;
        }
        for (Map.Entry entry : genericTypesMap.entrySet()) {
            if (this.isWithinBounds((TypeMirror)entry.getValue(), this.getTypeParamFromCandidate((TypeMirror)entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private TypeParameterElement getTypeParamFromCandidate(TypeMirror t) {
        for (TypeParameterElement typeParameterElement : this.candidateMethod.getExecutable().getTypeParameters()) {
            if (!typeParameterElement.asType().equals(t)) continue;
            return typeParameterElement;
        }
        return null;
    }

    private boolean isWithinBounds(TypeMirror t, TypeParameterElement tpe) {
        List<? extends TypeMirror> bounds = tpe.getBounds();
        if (t != null && bounds != null) {
            for (TypeMirror typeMirror : bounds) {
                if (typeMirror.getKind().equals((Object)TypeKind.DECLARED) && TypeUtilsJDK6Fix.isSubType(this.typeUtils, t, typeMirror)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private class TypeMatcher
    extends SimpleTypeVisitor6<Boolean, TypeMirror> {
        private final Assignability assignability;
        private final Map<TypeVariable, TypeMirror> genericTypesMap;

        public TypeMatcher(Assignability assignability, Map<TypeVariable, TypeMirror> genericTypesMap) {
            super(Boolean.FALSE);
            this.assignability = assignability;
            this.genericTypesMap = genericTypesMap;
        }

        @Override
        public Boolean visitPrimitive(PrimitiveType t, TypeMirror p) {
            return MethodMatcher.this.typeUtils.isSameType(t, p);
        }

        @Override
        public Boolean visitArray(ArrayType t, TypeMirror p) {
            if (p.getKind().equals((Object)TypeKind.ARRAY)) {
                return t.getComponentType().accept(this, ((ArrayType)p).getComponentType());
            }
            return Boolean.FALSE;
        }

        @Override
        public Boolean visitDeclared(DeclaredType t, TypeMirror p) {
            if (p.getKind() == TypeKind.DECLARED) {
                DeclaredType t1 = (DeclaredType)p;
                if (this.assignabilityMatches(t, t1) && t.getTypeArguments().size() == t1.getTypeArguments().size()) {
                    for (int i = 0; i < t.getTypeArguments().size(); ++i) {
                        if (t.getTypeArguments().get(i).accept(this, t1.getTypeArguments().get(i)).booleanValue()) continue;
                        return Boolean.FALSE;
                    }
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            return Boolean.FALSE;
        }

        private boolean assignabilityMatches(DeclaredType visited, DeclaredType param) {
            if (this.assignability == Assignability.VISITED_ASSIGNABLE_TO) {
                return MethodMatcher.this.typeUtils.isAssignable(this.toRawType(visited), this.toRawType(param));
            }
            return MethodMatcher.this.typeUtils.isAssignable(this.toRawType(param), this.toRawType(visited));
        }

        private DeclaredType toRawType(DeclaredType t) {
            return MethodMatcher.this.typeUtils.getDeclaredType((TypeElement)t.asElement(), new TypeMirror[0]);
        }

        @Override
        public Boolean visitTypeVariable(TypeVariable t, TypeMirror p) {
            if (this.genericTypesMap.containsKey(t)) {
                TypeMirror p1 = this.genericTypesMap.get(t);
                return MethodMatcher.this.typeUtils.isSameType(p, p1);
            }
            if (TypeUtilsJDK6Fix.isSubType(MethodMatcher.this.typeUtils, t.getLowerBound(), p) && TypeUtilsJDK6Fix.isSubType(MethodMatcher.this.typeUtils, p, t.getUpperBound())) {
                this.genericTypesMap.put(t, p);
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        @Override
        public Boolean visitWildcard(WildcardType t, TypeMirror p) {
            TypeMirror extendsBound = t.getExtendsBound();
            if (extendsBound != null) {
                switch (extendsBound.getKind()) {
                    case DECLARED: {
                        return TypeUtilsJDK6Fix.isSubType(MethodMatcher.this.typeUtils, p, extendsBound);
                    }
                    case TYPEVAR: {
                        return MethodMatcher.this.isWithinBounds(p, MethodMatcher.this.getTypeParamFromCandidate(extendsBound));
                    }
                }
                return Boolean.FALSE;
            }
            TypeMirror superBound = t.getSuperBound();
            if (superBound != null) {
                switch (superBound.getKind()) {
                    case DECLARED: {
                        return TypeUtilsJDK6Fix.isSubType(MethodMatcher.this.typeUtils, superBound, p) || MethodMatcher.this.typeUtils.isSameType(p, superBound);
                    }
                    case TYPEVAR: {
                        TypeParameterElement typeParameter = MethodMatcher.this.getTypeParamFromCandidate(superBound);
                        if (!MethodMatcher.this.isWithinBounds(p, typeParameter)) {
                            return Boolean.FALSE;
                        }
                        TypeMirror superBoundAsDeclared = typeParameter.getBounds().get(0);
                        return TypeUtilsJDK6Fix.isSubType(MethodMatcher.this.typeUtils, superBoundAsDeclared, p) || MethodMatcher.this.typeUtils.isSameType(p, superBoundAsDeclared);
                    }
                }
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
    }

    private static enum Assignability {
        VISITED_ASSIGNABLE_FROM,
        VISITED_ASSIGNABLE_TO;

    }
}

