/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.processor;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.mapstruct.CollectionMappingStrategy;
import org.mapstruct.ap.model.Assignment;
import org.mapstruct.ap.model.BeanMappingMethod;
import org.mapstruct.ap.model.Decorator;
import org.mapstruct.ap.model.DefaultMapperReference;
import org.mapstruct.ap.model.DelegatingMethod;
import org.mapstruct.ap.model.EnumMappingMethod;
import org.mapstruct.ap.model.FactoryMethod;
import org.mapstruct.ap.model.IterableMappingMethod;
import org.mapstruct.ap.model.MapMappingMethod;
import org.mapstruct.ap.model.Mapper;
import org.mapstruct.ap.model.MapperReference;
import org.mapstruct.ap.model.MappingMethod;
import org.mapstruct.ap.model.PropertyMapping;
import org.mapstruct.ap.model.assignment.AdderWrapper;
import org.mapstruct.ap.model.assignment.AssignmentFactory;
import org.mapstruct.ap.model.assignment.AssignmentWrapper;
import org.mapstruct.ap.model.assignment.GetterCollectionOrMapWrapper;
import org.mapstruct.ap.model.assignment.LocalVarWrapper;
import org.mapstruct.ap.model.assignment.NewCollectionOrMapWrapper;
import org.mapstruct.ap.model.assignment.NullCheckWrapper;
import org.mapstruct.ap.model.assignment.SetterCollectionOrMapWrapper;
import org.mapstruct.ap.model.assignment.SetterWrapper;
import org.mapstruct.ap.model.common.ModelElement;
import org.mapstruct.ap.model.common.Parameter;
import org.mapstruct.ap.model.common.Type;
import org.mapstruct.ap.model.common.TypeFactory;
import org.mapstruct.ap.model.source.EnumMapping;
import org.mapstruct.ap.model.source.Mapping;
import org.mapstruct.ap.model.source.SourceMethod;
import org.mapstruct.ap.model.source.selector.MethodSelectors;
import org.mapstruct.ap.option.Options;
import org.mapstruct.ap.option.ReportingPolicy;
import org.mapstruct.ap.prism.DecoratedWithPrism;
import org.mapstruct.ap.prism.MapperPrism;
import org.mapstruct.ap.processor.ModelElementProcessor;
import org.mapstruct.ap.processor.creation.MappingResolver;
import org.mapstruct.ap.util.Executables;
import org.mapstruct.ap.util.MapperConfig;
import org.mapstruct.ap.util.Strings;

public class MapperCreationProcessor
implements ModelElementProcessor<List<SourceMethod>, Mapper> {
    private Elements elementUtils;
    private Types typeUtils;
    private Messager messager;
    private Options options;
    private TypeFactory typeFactory;
    private MappingResolver mappingResolver;

    @Override
    public Mapper process(ModelElementProcessor.ProcessorContext context, TypeElement mapperTypeElement, List<SourceMethod> sourceModel) {
        this.elementUtils = context.getElementUtils();
        this.typeUtils = context.getTypeUtils();
        this.messager = context.getMessager();
        this.options = context.getOptions();
        this.typeFactory = context.getTypeFactory();
        this.mappingResolver = new MappingResolver(this.messager, this.typeFactory, this.elementUtils, this.typeUtils);
        return this.getMapper(mapperTypeElement, sourceModel);
    }

    @Override
    public int getPriority() {
        return 1000;
    }

    private Mapper getMapper(TypeElement element, List<SourceMethod> methods) {
        List<MapperReference> mapperReferences = this.getReferencedMappers(element);
        List<MappingMethod> mappingMethods = this.getMappingMethods(mapperReferences, methods, element);
        mappingMethods.addAll(this.mappingResolver.getVirtualMethodsToGenerate());
        Mapper mapper = new Mapper.Builder().element(element).mappingMethods(mappingMethods).mapperReferences(mapperReferences).suppressGeneratorTimestamp(this.options.isSuppressGeneratorTimestamp()).decorator(this.getDecorator(element, methods)).typeFactory(this.typeFactory).elementUtils(this.elementUtils).build();
        return mapper;
    }

    private ReportingPolicy getEffectiveUnmappedTargetPolicy(TypeElement element) {
        MapperConfig mapperSettings = MapperConfig.getInstanceOn(element);
        boolean setViaAnnotation = mapperSettings.isSetUnmappedTargetPolicy();
        ReportingPolicy annotationValue = ReportingPolicy.valueOf(mapperSettings.unmappedTargetPolicy());
        if (setViaAnnotation || this.options.getUnmappedTargetPolicy() == null) {
            return annotationValue;
        }
        return this.options.getUnmappedTargetPolicy();
    }

    private CollectionMappingStrategy getEffectiveCollectionMappingStrategy(TypeElement element) {
        MapperConfig mapperSettings = MapperConfig.getInstanceOn(element);
        return mapperSettings.getCollectionMappingStrategy();
    }

    private Decorator getDecorator(TypeElement element, List<SourceMethod> methods) {
        DecoratedWithPrism decoratorPrism = DecoratedWithPrism.getInstanceOn(element);
        if (decoratorPrism == null) {
            return null;
        }
        TypeElement decoratorElement = (TypeElement)this.typeUtils.asElement(decoratorPrism.value());
        if (!this.typeUtils.isAssignable(decoratorElement.asType(), element.asType())) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Specified decorator type is no subtype of the annotated mapper type.", new Object[0]), element, decoratorPrism.mirror);
        }
        ArrayList<MappingMethod> mappingMethods = new ArrayList<MappingMethod>(methods.size());
        for (SourceMethod mappingMethod : methods) {
            boolean implementationRequired = true;
            for (ExecutableElement method : ElementFilter.methodsIn(decoratorElement.getEnclosedElements())) {
                if (!this.elementUtils.overrides(method, mappingMethod.getExecutable(), decoratorElement)) continue;
                implementationRequired = false;
                break;
            }
            Type declaringMapper = mappingMethod.getDeclaringMapper();
            if (!implementationRequired || declaringMapper != null && !declaringMapper.equals(this.typeFactory.getType(element))) continue;
            mappingMethods.add(new DelegatingMethod(mappingMethod));
        }
        boolean hasDelegateConstructor = false;
        boolean hasDefaultConstructor = false;
        for (ExecutableElement constructor : ElementFilter.constructorsIn(decoratorElement.getEnclosedElements())) {
            if (constructor.getParameters().isEmpty()) {
                hasDefaultConstructor = true;
                continue;
            }
            if (constructor.getParameters().size() != 1 || !this.typeUtils.isAssignable(element.asType(), constructor.getParameters().iterator().next().asType())) continue;
            hasDelegateConstructor = true;
        }
        if (!hasDelegateConstructor && !hasDefaultConstructor) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Specified decorator type has no default constructor nor a constructor with a single parameter accepting the decorated mapper type.", new Object[0]), element, decoratorPrism.mirror);
        }
        return Decorator.getInstance(this.elementUtils, this.typeFactory, element, decoratorPrism, mappingMethods, hasDelegateConstructor, this.options.isSuppressGeneratorTimestamp());
    }

    private List<MapperReference> getReferencedMappers(TypeElement element) {
        LinkedList<MapperReference> mapperReferences = new LinkedList<MapperReference>();
        LinkedList<String> variableNames = new LinkedList<String>();
        MapperConfig mapperPrism = MapperConfig.getInstanceOn(element);
        for (TypeMirror usedMapper : mapperPrism.uses()) {
            DefaultMapperReference mapperReference = DefaultMapperReference.getInstance(this.typeFactory.getType(usedMapper), MapperPrism.getInstanceOn(this.typeUtils.asElement(usedMapper)) != null, this.typeFactory, variableNames);
            mapperReferences.add(mapperReference);
            variableNames.add(mapperReference.getVariableName());
        }
        return mapperReferences;
    }

    private List<MappingMethod> getMappingMethods(List<MapperReference> mapperReferences, List<SourceMethod> methods, TypeElement element) {
        ArrayList<MappingMethod> mappingMethods = new ArrayList<MappingMethod>();
        for (SourceMethod method : methods) {
            if (!method.requiresImplementation()) continue;
            SourceMethod reverseMappingMethod = this.getReverseMappingMethod(methods, method);
            boolean hasFactoryMethod = false;
            if (method.isIterableMapping()) {
                IterableMappingMethod iterableMappingMethod;
                if (method.getIterableMapping() == null && reverseMappingMethod != null && reverseMappingMethod.getIterableMapping() != null) {
                    method.setIterableMapping(reverseMappingMethod.getIterableMapping());
                }
                hasFactoryMethod = (iterableMappingMethod = this.getIterableMappingMethod(mapperReferences, methods, method)).getFactoryMethod() != null;
                mappingMethods.add(iterableMappingMethod);
            } else if (method.isMapMapping()) {
                MapMappingMethod mapMappingMethod;
                if (method.getMapMapping() == null && reverseMappingMethod != null && reverseMappingMethod.getMapMapping() != null) {
                    method.setMapMapping(reverseMappingMethod.getMapMapping());
                }
                hasFactoryMethod = (mapMappingMethod = this.getMapMappingMethod(mapperReferences, methods, method)).getFactoryMethod() != null;
                mappingMethods.add(mapMappingMethod);
            } else if (method.isEnumMapping()) {
                EnumMappingMethod enumMappingMethod;
                if (method.getMappings().isEmpty() && reverseMappingMethod != null && !reverseMappingMethod.getMappings().isEmpty()) {
                    method.setMappings(this.reverse(reverseMappingMethod.getMappings()));
                }
                if ((enumMappingMethod = this.getEnumMappingMethod(method)) != null) {
                    mappingMethods.add(enumMappingMethod);
                }
            } else {
                BeanMappingMethod beanMappingMethod;
                if (method.getMappings().isEmpty() && reverseMappingMethod != null && !reverseMappingMethod.getMappings().isEmpty()) {
                    method.setMappings(this.reverse(reverseMappingMethod.getMappings()));
                }
                if ((beanMappingMethod = this.getBeanMappingMethod(mapperReferences, methods, method, element)) != null) {
                    hasFactoryMethod = beanMappingMethod.getFactoryMethod() != null;
                    mappingMethods.add(beanMappingMethod);
                }
            }
            if (hasFactoryMethod) continue;
            this.reportErrorIfNoImplementationTypeIsRegisteredForInterfaceReturnType(method);
        }
        return mappingMethods;
    }

    private FactoryMethod getFactoryMethod(List<MapperReference> mapperReferences, List<SourceMethod> methods, Type returnType) {
        FactoryMethod result = null;
        for (SourceMethod method : methods) {
            List<Type> parameterTypes;
            if (method.requiresImplementation() || method.isIterableMapping() || method.isMapMapping() || !method.getSourceParameters().isEmpty() || !method.matches(parameterTypes = MethodSelectors.getParameterTypes(this.typeFactory, method.getParameters(), null, returnType), returnType)) continue;
            if (result == null) {
                MapperReference mapperReference = this.findMapperReference(mapperReferences, method);
                result = AssignmentFactory.createFactory(method, mapperReference);
                continue;
            }
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Ambiguous factory methods: \"%s\" conflicts with \"%s\".", result, method), method.getExecutable());
        }
        return result;
    }

    private void reportErrorIfNoImplementationTypeIsRegisteredForInterfaceReturnType(SourceMethod method) {
        if (method.getReturnType().getTypeMirror().getKind() != TypeKind.VOID && method.getReturnType().isInterface() && method.getReturnType().getImplementationType() == null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("No implementation type is registered for return type %s.", method.getReturnType()), method.getExecutable());
        }
    }

    private Map<String, List<Mapping>> reverse(Map<String, List<Mapping>> mappings) {
        HashMap<String, List<Mapping>> reversed = new HashMap<String, List<Mapping>>();
        for (List<Mapping> mappingList : mappings.values()) {
            for (Mapping mapping : mappingList) {
                Mapping reverseMapping;
                if (!reversed.containsKey(mapping.getTargetName())) {
                    reversed.put(mapping.getTargetName(), new ArrayList());
                }
                if ((reverseMapping = mapping.reverse()) == null) continue;
                ((List)reversed.get(mapping.getTargetName())).add(reverseMapping);
            }
        }
        return reversed;
    }

    private PropertyMapping getPropertyMapping(List<MapperReference> mapperReferences, List<SourceMethod> methods, SourceMethod method, ExecutableElement targetAccessor, String targetPropertyName, Parameter parameter) {
        String sourcePropertyName;
        Mapping mapping = method.getMappingByTargetPropertyName(targetPropertyName);
        String dateFormat = null;
        if (mapping != null) {
            dateFormat = mapping.getDateFormat();
            if (Executables.isSetterMethod(targetAccessor)) {
                if (!mapping.getConstant().isEmpty()) {
                    return this.getConstantMapping(mapperReferences, methods, method, "\"" + mapping.getConstant() + "\"", targetAccessor, dateFormat);
                }
                if (!mapping.getJavaExpression().isEmpty()) {
                    return this.getJavaExpressionMapping(method, mapping.getJavaExpression(), targetAccessor);
                }
            }
            sourcePropertyName = mapping.getSourcePropertyName();
        } else {
            sourcePropertyName = targetPropertyName;
        }
        List<ExecutableElement> sourceGetters = parameter.getType().getGetters();
        for (ExecutableElement sourceAccessor : sourceGetters) {
            List<Mapping> sourceMappings = method.getMappings().get(sourcePropertyName);
            if (method.getMappings().containsKey(sourcePropertyName)) {
                for (Mapping sourceMapping : sourceMappings) {
                    boolean mapsToOtherTarget;
                    boolean bl = mapsToOtherTarget = !sourceMapping.getTargetName().equals(targetPropertyName);
                    if (!Executables.getPropertyName(sourceAccessor).equals(sourcePropertyName) || mapsToOtherTarget) continue;
                    return this.getPropertyMapping(mapperReferences, methods, method, parameter, sourceAccessor, targetAccessor, targetPropertyName, dateFormat);
                }
                continue;
            }
            if (!Executables.getPropertyName(sourceAccessor).equals(sourcePropertyName)) continue;
            return this.getPropertyMapping(mapperReferences, methods, method, parameter, sourceAccessor, targetAccessor, targetPropertyName, dateFormat);
        }
        return null;
    }

    private BeanMappingMethod getBeanMappingMethod(List<MapperReference> mapperReferences, List<SourceMethod> methods, SourceMethod method, TypeElement element) {
        ReportingPolicy unmappedTargetPolicy = this.getEffectiveUnmappedTargetPolicy(element);
        CollectionMappingStrategy cmStrategy = this.getEffectiveCollectionMappingStrategy(element);
        ArrayList<PropertyMapping> propertyMappings = new ArrayList<PropertyMapping>();
        HashSet<String> mappedTargetProperties = new HashSet<String>();
        HashSet<String> ignoredTargetProperties = new HashSet<String>();
        if (!this.reportErrorIfMappedPropertiesDontExist(method)) {
            return null;
        }
        ArrayList<ExecutableElement> targetAccessors = new ArrayList<ExecutableElement>();
        targetAccessors.addAll(method.getResultType().getSetters());
        targetAccessors.addAll(method.getResultType().getAlternativeTargetAccessors());
        for (ExecutableElement targetAccessor : targetAccessors) {
            String targetPropertyName = Executables.getPropertyName(targetAccessor);
            Mapping mapping = method.getMappingByTargetPropertyName(targetPropertyName);
            if (mapping != null && mapping.isIgnored()) {
                ignoredTargetProperties.add(targetPropertyName);
                continue;
            }
            if (cmStrategy.equals((Object)CollectionMappingStrategy.SETTER_PREFERRED) || cmStrategy.equals((Object)CollectionMappingStrategy.ADDER_PREFERRED)) {
                Type targetType;
                ExecutableElement adderMethod = null;
                if (Executables.isSetterMethod(targetAccessor)) {
                    targetType = this.typeFactory.getSingleParameter(targetAccessor).getType();
                    if (cmStrategy.equals((Object)CollectionMappingStrategy.ADDER_PREFERRED)) {
                        adderMethod = method.getResultType().getAdderForType(targetType, targetPropertyName);
                    }
                } else if (Executables.isGetterMethod(targetAccessor)) {
                    targetType = this.typeFactory.getReturnType(targetAccessor);
                    adderMethod = method.getResultType().getAdderForType(targetType, targetPropertyName);
                }
                if (adderMethod != null) {
                    targetAccessor = adderMethod;
                }
            }
            PropertyMapping propertyMapping = null;
            if (mapping != null && mapping.getSourceParameterName() != null) {
                Parameter parameter = method.getSourceParameter(mapping.getSourceParameterName());
                propertyMapping = this.getPropertyMapping(mapperReferences, methods, method, targetAccessor, targetPropertyName, parameter);
            }
            if (propertyMapping == null) {
                for (Parameter sourceParameter : method.getSourceParameters()) {
                    PropertyMapping newPropertyMapping = this.getPropertyMapping(mapperReferences, methods, method, targetAccessor, targetPropertyName, sourceParameter);
                    if (propertyMapping != null && newPropertyMapping != null) {
                        this.messager.printMessage(Diagnostic.Kind.ERROR, "Several possible source properties for target property \"" + targetPropertyName + "\".", method.getExecutable());
                        break;
                    }
                    if (newPropertyMapping == null) continue;
                    propertyMapping = newPropertyMapping;
                }
            }
            if (propertyMapping == null) continue;
            propertyMappings.add(propertyMapping);
            mappedTargetProperties.add(targetPropertyName);
        }
        Set<String> targetProperties = Executables.getPropertyNames(targetAccessors);
        this.reportErrorForUnmappedTargetPropertiesIfRequired(method, unmappedTargetPolicy, targetProperties, mappedTargetProperties, ignoredTargetProperties);
        FactoryMethod factoryMethod = this.getFactoryMethod(mapperReferences, methods, method.getReturnType());
        return new BeanMappingMethod(method, propertyMappings, factoryMethod);
    }

    private void reportErrorForUnmappedTargetPropertiesIfRequired(SourceMethod method, ReportingPolicy unmappedTargetPolicy, Set<String> targetProperties, Set<String> mappedTargetProperties, Set<String> ignoredTargetProperties) {
        HashSet<String> unmappedTargetProperties = new HashSet<String>();
        for (String property : targetProperties) {
            if (mappedTargetProperties.contains(property) || ignoredTargetProperties.contains(property)) continue;
            unmappedTargetProperties.add(property);
        }
        if (!unmappedTargetProperties.isEmpty() && unmappedTargetPolicy.requiresReport()) {
            this.messager.printMessage(unmappedTargetPolicy.getDiagnosticKind(), MessageFormat.format("Unmapped target {0,choice,1#property|1<properties}: \"{1}\"", unmappedTargetProperties.size(), Strings.join(unmappedTargetProperties, ", ")), method.getExecutable());
        }
    }

    private SourceMethod getReverseMappingMethod(List<SourceMethod> rawMethods, SourceMethod method) {
        for (SourceMethod oneMethod : rawMethods) {
            if (!oneMethod.reverses(method)) continue;
            return oneMethod;
        }
        return null;
    }

    private boolean hasSourceProperty(SourceMethod method, String propertyName) {
        for (Parameter parameter : method.getSourceParameters()) {
            if (!this.hasSourceProperty(parameter, propertyName)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSourceProperty(Parameter parameter, String propertyName) {
        List<ExecutableElement> getters = parameter.getType().getGetters();
        return Executables.getPropertyNames(getters).contains(propertyName);
    }

    private boolean reportErrorIfMappedPropertiesDontExist(SourceMethod method) {
        if (method.isConfiguredByReverseMappingMethod()) {
            return true;
        }
        ArrayList<ExecutableElement> targetAccessors = new ArrayList<ExecutableElement>();
        targetAccessors.addAll(method.getResultType().getSetters());
        targetAccessors.addAll(method.getResultType().getAlternativeTargetAccessors());
        Set<String> targetProperties = Executables.getPropertyNames(targetAccessors);
        boolean foundUnmappedProperty = false;
        for (List<Mapping> mappedProperties : method.getMappings().values()) {
            for (Mapping mappedProperty : mappedProperties) {
                if (mappedProperty.isIgnored()) continue;
                if (mappedProperty.getSourceParameterName() != null) {
                    Parameter sourceParameter = method.getSourceParameter(mappedProperty.getSourceParameterName());
                    if (sourceParameter == null) {
                        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Method has no parameter named \"%s\".", mappedProperty.getSourceParameterName()), method.getExecutable(), mappedProperty.getMirror(), mappedProperty.getSourceAnnotationValue());
                        foundUnmappedProperty = true;
                    } else if (!this.hasSourceProperty(sourceParameter, mappedProperty.getSourcePropertyName())) {
                        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("The type of parameter \"%s\" has no property named \"%s\".", mappedProperty.getSourceParameterName(), mappedProperty.getSourcePropertyName()), method.getExecutable(), mappedProperty.getMirror(), mappedProperty.getSourceAnnotationValue());
                        foundUnmappedProperty = true;
                    }
                } else if (mappedProperty.getConstant().isEmpty() && mappedProperty.getJavaExpression().isEmpty() && !this.hasSourceProperty(method, mappedProperty.getSourcePropertyName())) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("No property named \"%s\" exists in source parameter(s).", mappedProperty.getSourceName()), method.getExecutable(), mappedProperty.getMirror(), mappedProperty.getSourceAnnotationValue());
                    foundUnmappedProperty = true;
                }
                if (targetProperties.contains(mappedProperty.getTargetName())) continue;
                this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Unknown property \"%s\" in return type %s.", mappedProperty.getTargetName(), method.getResultType()), method.getExecutable(), mappedProperty.getMirror(), mappedProperty.getTargetAnnotationValue());
                foundUnmappedProperty = true;
            }
        }
        return !foundUnmappedProperty;
    }

    private PropertyMapping getPropertyMapping(List<MapperReference> mapperReferences, List<SourceMethod> methods, SourceMethod method, Parameter parameter, ExecutableElement sourceAccessor, ExecutableElement targetAccessor, String targetPropertyName, String dateFormat) {
        TargetAccessorType targetAccessorType;
        Type targetType;
        Type sourceType;
        String sourceReference = parameter.getName() + "." + sourceAccessor.getSimpleName().toString() + "()";
        String iteratorReference = null;
        boolean sourceIsCollection = false;
        if (Executables.isSetterMethod(targetAccessor)) {
            sourceType = this.typeFactory.getReturnType(sourceAccessor);
            targetType = this.typeFactory.getSingleParameter(targetAccessor).getType();
            targetAccessorType = TargetAccessorType.SETTER;
        } else if (Executables.isAdderMethod(targetAccessor)) {
            sourceType = this.typeFactory.getReturnType(sourceAccessor);
            if (sourceType.isCollectionType()) {
                sourceIsCollection = true;
                sourceType = sourceType.getTypeParameters().get(0);
                iteratorReference = Executables.getElementNameForAdder(targetAccessor);
            }
            targetType = this.typeFactory.getSingleParameter(targetAccessor).getType();
            targetAccessorType = TargetAccessorType.ADDER;
        } else {
            sourceType = this.typeFactory.getReturnType(sourceAccessor);
            targetType = this.typeFactory.getReturnType(targetAccessor);
            targetAccessorType = TargetAccessorType.GETTER;
        }
        String sourcePropertyName = Executables.getPropertyName(sourceAccessor);
        String mappedElement = "property '" + sourcePropertyName + "'";
        Assignment assignment = this.mappingResolver.getTargetAssignment(method, mappedElement, mapperReferences, methods, sourceType, targetType, targetPropertyName, dateFormat, iteratorReference != null ? iteratorReference : sourceReference);
        if (assignment != null) {
            if (targetType.isCollectionOrMapType()) {
                if (targetAccessorType == TargetAccessorType.SETTER) {
                    AssignmentWrapper newCollectionOrMap = null;
                    if (assignment.getType() == Assignment.AssignmentType.DIRECT) {
                        newCollectionOrMap = new NewCollectionOrMapWrapper(assignment, targetType.getImportTypes());
                        newCollectionOrMap = new SetterWrapper(newCollectionOrMap, method.getThrownTypes());
                    }
                    assignment = new SetterWrapper(assignment, method.getThrownTypes());
                    assignment = new SetterCollectionOrMapWrapper(assignment, targetAccessor.getSimpleName().toString(), newCollectionOrMap);
                } else {
                    assignment = new SetterWrapper(assignment, method.getThrownTypes());
                    assignment = new GetterCollectionOrMapWrapper(assignment);
                }
                if (assignment.getType() == Assignment.AssignmentType.DIRECT) {
                    assignment = new NullCheckWrapper(assignment);
                }
            } else if (targetAccessorType == TargetAccessorType.SETTER) {
                assignment = new SetterWrapper(assignment, method.getThrownTypes());
                if (!sourceType.isPrimitive() && (assignment.getType() == Assignment.AssignmentType.TYPE_CONVERTED || assignment.getType() == Assignment.AssignmentType.TYPE_CONVERTED_MAPPED || assignment.getType() == Assignment.AssignmentType.DIRECT && targetType.isPrimitive())) {
                    assignment = new NullCheckWrapper(assignment);
                }
            } else if (sourceIsCollection) {
                assignment = new AdderWrapper(assignment, method.getThrownTypes(), sourceReference, sourceType);
            } else {
                assignment = new SetterWrapper(assignment, method.getThrownTypes());
                assignment = new NullCheckWrapper(assignment);
            }
        } else {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Can't map property \"%s %s\" to \"%s %s\".", sourceType, sourcePropertyName, targetType, targetPropertyName), method.getExecutable());
        }
        return new PropertyMapping(parameter.getName(), targetAccessor.getSimpleName().toString(), targetType, assignment);
    }

    private PropertyMapping getConstantMapping(List<MapperReference> mapperReferences, List<SourceMethod> methods, SourceMethod method, String constantExpression, ExecutableElement targetAccessor, String dateFormat) {
        String targetPropertyName;
        Type targetType;
        Type sourceType;
        String mappedElement = "constant '" + constantExpression + "'";
        Assignment assignment = this.mappingResolver.getTargetAssignment(method, mappedElement, mapperReferences, methods, sourceType = this.typeFactory.getType(String.class), targetType = this.typeFactory.getSingleParameter(targetAccessor).getType(), targetPropertyName = Executables.getPropertyName(targetAccessor), dateFormat, constantExpression);
        if (assignment != null) {
            assignment = new SetterWrapper(assignment, method.getThrownTypes());
        } else {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Can't map \"%s %s\" to \"%s %s\".", sourceType, constantExpression, targetType, targetPropertyName), method.getExecutable());
        }
        return new PropertyMapping(targetAccessor.getSimpleName().toString(), targetType, assignment);
    }

    private PropertyMapping getJavaExpressionMapping(SourceMethod method, String javaExpression, ExecutableElement targetAcessor) {
        Type targetType = this.typeFactory.getSingleParameter(targetAcessor).getType();
        ModelElement assignment = AssignmentFactory.createSimple(javaExpression);
        assignment = new SetterWrapper((Assignment)((Object)assignment), method.getThrownTypes());
        return new PropertyMapping(targetAcessor.getSimpleName().toString(), targetType, (Assignment)((Object)assignment));
    }

    private IterableMappingMethod getIterableMappingMethod(List<MapperReference> mapperReferences, List<SourceMethod> methods, SourceMethod method) {
        String conversionStr;
        String dateFormat;
        Type targetElementType;
        Type sourceElementType = method.getSourceParameters().iterator().next().getType().getTypeParameters().get(0);
        Assignment assignment = this.mappingResolver.getTargetAssignment(method, "collection element", mapperReferences, methods, sourceElementType, targetElementType = method.getResultType().getTypeParameters().get(0), null, dateFormat = method.getIterableMapping() != null ? method.getIterableMapping().getDateFormat() : null, conversionStr = Strings.getSaveVariableName(sourceElementType.getName(), method.getParameterNames()));
        if (assignment == null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Can't create implementation of method %s. Found no method nor built-in conversion for mapping source element type into target element type.", method), method.getExecutable());
        }
        assignment = new SetterWrapper(assignment, method.getThrownTypes());
        FactoryMethod factoryMethod = this.getFactoryMethod(mapperReferences, methods, method.getReturnType());
        return new IterableMappingMethod(method, assignment, factoryMethod);
    }

    private MapMappingMethod getMapMappingMethod(List<MapperReference> mapperReferences, List<SourceMethod> methods, SourceMethod method) {
        String valueDateFormat;
        Type valueTargetType;
        Type valueSourceType;
        Assignment valueAssignment;
        String keyDateFormat;
        Type keyTargetType;
        List<Type> sourceTypeParams = method.getSourceParameters().iterator().next().getType().getTypeParameters();
        List<Type> resultTypeParams = method.getResultType().getTypeParameters();
        Type keySourceType = sourceTypeParams.get(0);
        Assignment keyAssignment = this.mappingResolver.getTargetAssignment(method, "map key", mapperReferences, methods, keySourceType, keyTargetType = resultTypeParams.get(0), null, keyDateFormat = method.getMapMapping() != null ? method.getMapMapping().getKeyFormat() : null, "entry.getKey()");
        if (keyAssignment == null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Can't create implementation of method %s. Found no method nor built-in conversion for mapping source key type to target key type.", method), method.getExecutable());
        }
        if ((valueAssignment = this.mappingResolver.getTargetAssignment(method, "map value", mapperReferences, methods, valueSourceType = sourceTypeParams.get(1), valueTargetType = resultTypeParams.get(1), null, valueDateFormat = method.getMapMapping() != null ? method.getMapMapping().getValueFormat() : null, "entry.getValue()")) == null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Can't create implementation of method %s. Found no method nor built-in conversion for mapping source value type to target value type.", method), method.getExecutable());
        }
        FactoryMethod factoryMethod = this.getFactoryMethod(mapperReferences, methods, method.getReturnType());
        keyAssignment = new LocalVarWrapper(keyAssignment, method.getThrownTypes());
        valueAssignment = new LocalVarWrapper(valueAssignment, method.getThrownTypes());
        return new MapMappingMethod(method, keyAssignment, valueAssignment, factoryMethod);
    }

    private EnumMappingMethod getEnumMappingMethod(SourceMethod method) {
        if (!this.reportErrorIfMappedEnumConstantsDontExist(method) || !this.reportErrorIfSourceEnumConstantsWithoutCorrespondingTargetConstantAreNotMapped(method)) {
            return null;
        }
        ArrayList<EnumMapping> enumMappings = new ArrayList<EnumMapping>();
        List<String> sourceEnumConstants = method.getSourceParameters().iterator().next().getType().getEnumConstants();
        Map<String, List<Mapping>> mappings = method.getMappings();
        for (String enumConstant : sourceEnumConstants) {
            List<Mapping> mappedConstants = mappings.get(enumConstant);
            if (mappedConstants == null) {
                enumMappings.add(new EnumMapping(enumConstant, enumConstant));
                continue;
            }
            if (mappedConstants.size() == 1) {
                enumMappings.add(new EnumMapping(enumConstant, mappedConstants.iterator().next().getTargetName()));
                continue;
            }
            ArrayList<String> targetConstants = new ArrayList<String>(mappedConstants.size());
            for (Mapping mapping : mappedConstants) {
                targetConstants.add(mapping.getTargetName());
            }
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("One enum constant must not be mapped to more than one target constant, but constant %s is mapped to %s.", enumConstant, Strings.join(targetConstants, ", ")), method.getExecutable());
        }
        return new EnumMappingMethod(method, enumMappings);
    }

    private boolean reportErrorIfMappedEnumConstantsDontExist(SourceMethod method) {
        if (method.isConfiguredByReverseMappingMethod()) {
            return true;
        }
        List<String> sourceEnumConstants = method.getSourceParameters().iterator().next().getType().getEnumConstants();
        List<String> targetEnumConstants = method.getReturnType().getEnumConstants();
        boolean foundIncorrectMapping = false;
        for (List<Mapping> mappedConstants : method.getMappings().values()) {
            for (Mapping mappedConstant : mappedConstants) {
                if (mappedConstant.getSourceName() == null) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "A source constant must be specified for mappings of an enum mapping method.", method.getExecutable(), mappedConstant.getMirror());
                    foundIncorrectMapping = true;
                } else if (!sourceEnumConstants.contains(mappedConstant.getSourceName())) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Constant %s doesn't exist in enum type %s.", mappedConstant.getSourceName(), method.getSourceParameters().iterator().next().getType()), method.getExecutable(), mappedConstant.getMirror(), mappedConstant.getSourceAnnotationValue());
                    foundIncorrectMapping = true;
                }
                if (mappedConstant.getTargetName() == null) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "A target constant must be specified for mappings of an enum mapping method.", method.getExecutable(), mappedConstant.getMirror());
                    foundIncorrectMapping = true;
                    continue;
                }
                if (targetEnumConstants.contains(mappedConstant.getTargetName())) continue;
                this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Constant %s doesn't exist in enum type %s.", mappedConstant.getTargetName(), method.getReturnType()), method.getExecutable(), mappedConstant.getMirror(), mappedConstant.getTargetAnnotationValue());
                foundIncorrectMapping = true;
            }
        }
        return !foundIncorrectMapping;
    }

    private boolean reportErrorIfSourceEnumConstantsWithoutCorrespondingTargetConstantAreNotMapped(SourceMethod method) {
        List<String> sourceEnumConstants = method.getSourceParameters().iterator().next().getType().getEnumConstants();
        List<String> targetEnumConstants = method.getReturnType().getEnumConstants();
        Set<String> mappedSourceEnumConstants = method.getMappings().keySet();
        ArrayList<String> unmappedSourceEnumConstants = new ArrayList<String>();
        for (String sourceEnumConstant : sourceEnumConstants) {
            if (targetEnumConstants.contains(sourceEnumConstant) || mappedSourceEnumConstants.contains(sourceEnumConstant)) continue;
            unmappedSourceEnumConstants.add(sourceEnumConstant);
        }
        if (!unmappedSourceEnumConstants.isEmpty()) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("The following constants from the source enum have no corresponding constant in the target enum and must be be mapped via @Mapping: %s", Strings.join(unmappedSourceEnumConstants, ", ")), method.getExecutable());
        }
        return unmappedSourceEnumConstants.isEmpty();
    }

    private MapperReference findMapperReference(List<MapperReference> mapperReferences, SourceMethod method) {
        for (MapperReference ref : mapperReferences) {
            if (!ref.getType().equals(method.getDeclaringMapper())) continue;
            return ref;
        }
        return null;
    }

    private static enum TargetAccessorType {
        GETTER,
        SETTER,
        ADDER;

    }
}

