/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.mapstruct.ap.model.common.Parameter;
import org.mapstruct.ap.model.common.Type;
import org.mapstruct.ap.model.common.TypeFactory;
import org.mapstruct.ap.model.source.IterableMapping;
import org.mapstruct.ap.model.source.MapMapping;
import org.mapstruct.ap.model.source.Mapping;
import org.mapstruct.ap.model.source.SourceMethod;
import org.mapstruct.ap.prism.IterableMappingPrism;
import org.mapstruct.ap.prism.MapMappingPrism;
import org.mapstruct.ap.prism.MappingPrism;
import org.mapstruct.ap.prism.MappingsPrism;
import org.mapstruct.ap.processor.ModelElementProcessor;
import org.mapstruct.ap.util.AnnotationProcessingException;
import org.mapstruct.ap.util.MapperConfig;

public class MethodRetrievalProcessor
implements ModelElementProcessor<Void, List<SourceMethod>> {
    private Messager messager;
    private TypeFactory typeFactory;
    private Types typeUtils;

    @Override
    public List<SourceMethod> process(ModelElementProcessor.ProcessorContext context, TypeElement mapperTypeElement, Void sourceModel) {
        this.messager = context.getMessager();
        this.typeFactory = context.getTypeFactory();
        this.typeUtils = context.getTypeUtils();
        return this.retrieveMethods(mapperTypeElement, mapperTypeElement);
    }

    @Override
    public int getPriority() {
        return 1;
    }

    private List<SourceMethod> retrieveMethods(TypeElement usedMapper, TypeElement mapperToImplement) {
        ArrayList<SourceMethod> methods = new ArrayList<SourceMethod>();
        for (ExecutableElement executable : ElementFilter.methodsIn(this.allEnclosingElementsIncludeSuper(usedMapper))) {
            SourceMethod method = this.getMethod(usedMapper, executable, mapperToImplement);
            if (method == null) continue;
            methods.add(method);
        }
        if (usedMapper.equals(mapperToImplement)) {
            MapperConfig mapperSettings = MapperConfig.getInstanceOn(usedMapper);
            if (!mapperSettings.isValid()) {
                throw new AnnotationProcessingException("Couldn't retrieve @Mapper annotation", usedMapper, mapperSettings.getAnnotationMirror());
            }
            for (TypeMirror mapper : mapperSettings.uses()) {
                methods.addAll(this.retrieveMethods(this.asTypeElement(mapper), mapperToImplement));
            }
        }
        return methods;
    }

    private TypeElement asTypeElement(TypeMirror usedMapper) {
        return (TypeElement)((DeclaredType)usedMapper).asElement();
    }

    private List<Element> allEnclosingElementsIncludeSuper(TypeElement element) {
        ArrayList<Element> enclosedElements = new ArrayList<Element>(element.getEnclosedElements());
        for (TypeMirror typeMirror : element.getInterfaces()) {
            enclosedElements.addAll(this.allEnclosingElementsIncludeSuper(this.asTypeElement(typeMirror)));
        }
        if (this.hasNonObjectSuperclass(element)) {
            enclosedElements.addAll(this.allEnclosingElementsIncludeSuper(this.asTypeElement(element.getSuperclass())));
        }
        return enclosedElements;
    }

    private boolean hasNonObjectSuperclass(TypeElement element) {
        return element.getSuperclass().getKind() == TypeKind.DECLARED && this.asTypeElement(element.getSuperclass()).getSuperclass().getKind() == TypeKind.DECLARED;
    }

    private SourceMethod getMethod(TypeElement usedMapper, ExecutableElement method, TypeElement mapperToImplement) {
        List<Parameter> parameters = this.typeFactory.getParameters(method);
        boolean methodRequiresImplementation = method.getModifiers().contains((Object)Modifier.ABSTRACT);
        boolean containsTargetTypeParameter = SourceMethod.containsTargetTypeParameter(parameters);
        if (usedMapper.equals(mapperToImplement) && methodRequiresImplementation) {
            return this.getMethodRequiringImplementation(method, parameters, containsTargetTypeParameter);
        }
        if (this.isValidReferencedMethod(parameters) || this.isValidFactoryMethod(parameters)) {
            return this.getReferencedMethod(usedMapper, method, mapperToImplement, parameters);
        }
        return null;
    }

    private SourceMethod getMethodRequiringImplementation(ExecutableElement method, List<Parameter> parameters, boolean containsTargetTypeParameter) {
        Type resultType;
        Parameter targetParameter;
        Type returnType = this.typeFactory.getReturnType(method);
        List<Type> exceptionTypes = this.typeFactory.getThrownTypes(method);
        List<Parameter> sourceParameters = this.extractSourceParameters(parameters);
        boolean isValid = this.checkParameterAndReturnType(method, sourceParameters, targetParameter = this.extractTargetParameter(parameters), resultType = this.selectResultType(returnType, targetParameter), returnType, containsTargetTypeParameter);
        if (!isValid) {
            return null;
        }
        return SourceMethod.forMethodRequiringImplementation(method, parameters, returnType, exceptionTypes, this.getMappings(method), IterableMapping.fromPrism(IterableMappingPrism.getInstanceOn(method)), MapMapping.fromPrism(MapMappingPrism.getInstanceOn(method)), this.typeUtils);
    }

    private SourceMethod getReferencedMethod(TypeElement usedMapper, ExecutableElement method, TypeElement mapperToImplement, List<Parameter> parameters) {
        Type returnType = this.typeFactory.getReturnType(method);
        List<Type> exceptionTypes = this.typeFactory.getThrownTypes(method);
        Type usedMapperAsType = this.typeFactory.getType(usedMapper);
        Type mapperToImplementAsType = this.typeFactory.getType(mapperToImplement);
        if (!mapperToImplementAsType.canAccess(usedMapperAsType, method)) {
            return null;
        }
        return SourceMethod.forReferencedMethod(usedMapper.equals(mapperToImplement) ? null : usedMapperAsType, method, parameters, returnType, exceptionTypes, this.typeUtils);
    }

    private boolean isValidReferencedMethod(List<Parameter> parameters) {
        return this.isValidReferencedOrFactoryMethod(1, parameters);
    }

    private boolean isValidFactoryMethod(List<Parameter> parameters) {
        return this.isValidReferencedOrFactoryMethod(0, parameters);
    }

    private boolean isValidReferencedOrFactoryMethod(int sourceParamCount, List<Parameter> parameters) {
        int validSourceParameters = 0;
        int targetParameters = 0;
        int targetTypeParameters = 0;
        for (Parameter param : parameters) {
            if (param.isMappingTarget()) {
                ++targetParameters;
            }
            if (param.isTargetType()) {
                ++targetTypeParameters;
            }
            if (param.isMappingTarget() || param.isTargetType()) continue;
            ++validSourceParameters;
        }
        return validSourceParameters == sourceParamCount && targetParameters == 0 && targetTypeParameters <= 1 && parameters.size() == validSourceParameters + targetParameters + targetTypeParameters;
    }

    private Parameter extractTargetParameter(List<Parameter> parameters) {
        for (Parameter param : parameters) {
            if (!param.isMappingTarget()) continue;
            return param;
        }
        return null;
    }

    private List<Parameter> extractSourceParameters(List<Parameter> parameters) {
        ArrayList<Parameter> sourceParameters = new ArrayList<Parameter>(parameters.size());
        for (Parameter param : parameters) {
            if (param.isMappingTarget()) continue;
            sourceParameters.add(param);
        }
        return sourceParameters;
    }

    private Type selectResultType(Type returnType, Parameter targetParameter) {
        if (null != targetParameter) {
            return targetParameter.getType();
        }
        return returnType;
    }

    private boolean checkParameterAndReturnType(ExecutableElement method, List<Parameter> sourceParameters, Parameter targetParameter, Type resultType, Type returnType, boolean containsTargetTypeParameter) {
        if (sourceParameters.isEmpty()) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Can't generate mapping method with no input arguments.", method);
            return false;
        }
        if (targetParameter != null && sourceParameters.size() + 1 != method.getParameters().size()) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Can't generate mapping method with more than one @MappingTarget parameter.", method);
            return false;
        }
        if (resultType.getTypeMirror().getKind() == TypeKind.VOID) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Can't generate mapping method with return type void.", method);
            return false;
        }
        if (returnType.getTypeMirror().getKind() != TypeKind.VOID && !resultType.isAssignableTo(returnType)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "The result type is not assignable to the the return type.", method);
            return false;
        }
        Type parameterType = sourceParameters.get(0).getType();
        if (parameterType.isIterableType() && !resultType.isIterableType()) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Can't generate mapping method from iterable type to non-iterable type.", method);
            return false;
        }
        if (containsTargetTypeParameter) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Can't generate mapping method that has a parameter annotated with @TargetType.", method);
            return false;
        }
        if (!parameterType.isIterableType() && resultType.isIterableType()) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Can't generate mapping method from non-iterable type to iterable type.", method);
            return false;
        }
        if (parameterType.isPrimitive()) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Can't generate mapping method with primitive parameter type.", method);
            return false;
        }
        if (resultType.isPrimitive()) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Can't generate mapping method with primitive return type.", method);
            return false;
        }
        if (parameterType.isEnumType() && !resultType.isEnumType()) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Can't generate mapping method from enum type to non-enum type.", method);
            return false;
        }
        if (!parameterType.isEnumType() && resultType.isEnumType()) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Can't generate mapping method from non-enum type to enum type.", method);
            return false;
        }
        return true;
    }

    private Map<String, List<Mapping>> getMappings(ExecutableElement method) {
        HashMap<String, List<Mapping>> mappings = new HashMap<String, List<Mapping>>();
        MappingPrism mappingAnnotation = MappingPrism.getInstanceOn(method);
        MappingsPrism mappingsAnnotation = MappingsPrism.getInstanceOn(method);
        if (mappingAnnotation != null) {
            Mapping mapping;
            if (!mappings.containsKey(mappingAnnotation.source())) {
                mappings.put(mappingAnnotation.source(), new ArrayList());
            }
            if ((mapping = Mapping.fromMappingPrism(mappingAnnotation, method, this.messager)) != null) {
                ((List)mappings.get(mappingAnnotation.source())).add(mapping);
            }
        }
        if (mappingsAnnotation != null) {
            mappings.putAll(Mapping.fromMappingsPrism(mappingsAnnotation, method, this.messager));
        }
        return mappings;
    }
}

