/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.processor.creation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.mapstruct.ap.conversion.ConversionProvider;
import org.mapstruct.ap.conversion.Conversions;
import org.mapstruct.ap.model.Assignment;
import org.mapstruct.ap.model.MapperReference;
import org.mapstruct.ap.model.VirtualMappingMethod;
import org.mapstruct.ap.model.assignment.AssignmentFactory;
import org.mapstruct.ap.model.assignment.Direct;
import org.mapstruct.ap.model.common.DefaultConversionContext;
import org.mapstruct.ap.model.common.Type;
import org.mapstruct.ap.model.common.TypeFactory;
import org.mapstruct.ap.model.source.Method;
import org.mapstruct.ap.model.source.SourceMethod;
import org.mapstruct.ap.model.source.builtin.BuiltInMappingMethods;
import org.mapstruct.ap.model.source.builtin.BuiltInMethod;
import org.mapstruct.ap.model.source.selector.MethodSelectors;
import org.mapstruct.ap.util.Strings;

public class MappingResolver {
    private final Messager messager;
    private final TypeFactory typeFactory;
    private final Conversions conversions;
    private final BuiltInMappingMethods builtInMethods;
    private final Types typeUtils;
    private final MethodSelectors methodSelectors;
    private final Set<VirtualMappingMethod> virtualMethods;

    public MappingResolver(Messager messager, TypeFactory typeFactory, Elements elementUtils, Types typeUtils) {
        this.messager = messager;
        this.typeFactory = typeFactory;
        this.conversions = new Conversions(elementUtils, typeFactory);
        this.builtInMethods = new BuiltInMappingMethods(typeFactory);
        this.virtualMethods = new HashSet<VirtualMappingMethod>();
        this.methodSelectors = new MethodSelectors(typeUtils, typeFactory);
        this.typeUtils = typeUtils;
    }

    public Assignment getTargetAssignment(SourceMethod mappingMethod, String mappedElement, List<MapperReference> mapperReferences, List<SourceMethod> methods, Type sourceType, Type targetType, String targetPropertyName, String dateFormat, String sourceReference) {
        ResolvingAttempt attempt = new ResolvingAttempt(mappingMethod, mappedElement, mapperReferences, methods, targetPropertyName, dateFormat, sourceReference, this);
        return attempt.getTargetAssignment(sourceType, targetType);
    }

    public Set<VirtualMappingMethod> getVirtualMethodsToGenerate() {
        return this.virtualMethods;
    }

    private boolean isPropertyMappable(Type sourceType, Type targetType) {
        boolean collectionOrMapTargetTypeHasCompatibleConstructor = false;
        if (sourceType.isCollectionType() && targetType.isCollectionType()) {
            collectionOrMapTargetTypeHasCompatibleConstructor = this.collectionTypeHasCompatibleConstructor(sourceType, targetType.getImplementationType() != null ? targetType.getImplementationType() : targetType);
        }
        if (sourceType.isMapType() && targetType.isMapType()) {
            collectionOrMapTargetTypeHasCompatibleConstructor = this.mapTypeHasCompatibleConstructor(sourceType, targetType.getImplementationType() != null ? targetType.getImplementationType() : targetType);
        }
        return (targetType.isCollectionType() || targetType.isMapType()) && collectionOrMapTargetTypeHasCompatibleConstructor;
    }

    private boolean collectionTypeHasCompatibleConstructor(Type sourceType, Type targetType) {
        TypeMirror sourceElementType = sourceType.getTypeParameters().isEmpty() ? this.typeFactory.getType(Object.class).getTypeMirror() : sourceType.getTypeParameters().get(0).getTypeMirror();
        TypeMirror targetElementType = targetType.getTypeParameters().isEmpty() ? this.typeFactory.getType(Object.class).getTypeMirror() : targetType.getTypeParameters().get(0).getTypeMirror();
        return this.typeUtils.isAssignable(sourceElementType, targetElementType);
    }

    private boolean mapTypeHasCompatibleConstructor(Type sourceType, Type targetType) {
        TypeMirror sourceKeyType = null;
        TypeMirror targetKeyType = null;
        TypeMirror sourceValueType = null;
        TypeMirror targetValueType = null;
        if (sourceType.getTypeParameters().isEmpty()) {
            sourceKeyType = this.typeFactory.getType(Object.class).getTypeMirror();
            sourceValueType = this.typeFactory.getType(Object.class).getTypeMirror();
        } else {
            sourceKeyType = sourceType.getTypeParameters().get(0).getTypeMirror();
            sourceValueType = sourceType.getTypeParameters().get(1).getTypeMirror();
        }
        if (targetType.getTypeParameters().isEmpty()) {
            targetKeyType = this.typeFactory.getType(Object.class).getTypeMirror();
            targetValueType = this.typeFactory.getType(Object.class).getTypeMirror();
        } else {
            targetKeyType = targetType.getTypeParameters().get(0).getTypeMirror();
            targetValueType = targetType.getTypeParameters().get(1).getTypeMirror();
        }
        return this.typeUtils.isAssignable(sourceKeyType, targetKeyType) && this.typeUtils.isAssignable(sourceValueType, targetValueType);
    }

    private static class ResolvingAttempt {
        private final SourceMethod mappingMethod;
        private final String mappedElement;
        private final List<MapperReference> mapperReferences;
        private final List<SourceMethod> methods;
        private final String targetPropertyName;
        private final String dateFormat;
        private final String sourceReference;
        private final MappingResolver context;
        private final Set<VirtualMappingMethod> virtualMethodCandidates;

        private ResolvingAttempt(SourceMethod mappingMethod, String mappedElement, List<MapperReference> mapperReferences, List<SourceMethod> methods, String targetPropertyName, String dateFormat, String sourceReference, MappingResolver context) {
            this.mappingMethod = mappingMethod;
            this.mappedElement = mappedElement;
            this.mapperReferences = mapperReferences;
            this.methods = methods;
            this.targetPropertyName = targetPropertyName;
            this.dateFormat = dateFormat;
            this.sourceReference = sourceReference;
            this.context = context;
            this.virtualMethodCandidates = new HashSet<VirtualMappingMethod>();
        }

        private Assignment getTargetAssignment(Type sourceType, Type targetType) {
            Assignment referencedMethod = this.resolveViaMethod(sourceType, targetType);
            if (referencedMethod != null) {
                referencedMethod.setAssignment(AssignmentFactory.createSimple(this.sourceReference));
                this.context.virtualMethods.addAll(this.virtualMethodCandidates);
                return referencedMethod;
            }
            if (sourceType.isAssignableTo(targetType) || this.context.isPropertyMappable(sourceType, targetType)) {
                Direct simpleAssignment = AssignmentFactory.createSimple(this.sourceReference);
                return simpleAssignment;
            }
            Assignment conversion = this.resolveViaConversion(sourceType, targetType);
            if (conversion != null) {
                conversion.setAssignment(AssignmentFactory.createSimple(this.sourceReference));
                return conversion;
            }
            referencedMethod = this.resolveViaMethodAndMethod(sourceType, targetType);
            if (referencedMethod != null) {
                this.context.virtualMethods.addAll(this.virtualMethodCandidates);
                return referencedMethod;
            }
            referencedMethod = this.resolveViaConversionAndMethod(sourceType, targetType);
            if (referencedMethod != null) {
                this.context.virtualMethods.addAll(this.virtualMethodCandidates);
                return referencedMethod;
            }
            conversion = this.resolveViaMethodAndConversion(sourceType, targetType);
            if (conversion != null) {
                this.context.virtualMethods.addAll(this.virtualMethodCandidates);
                return conversion;
            }
            return null;
        }

        private Assignment resolveViaConversion(Type sourceType, Type targetType) {
            ConversionProvider conversionProvider = this.context.conversions.getConversion(sourceType, targetType);
            if (conversionProvider == null) {
                return null;
            }
            DefaultConversionContext ctx = new DefaultConversionContext(this.context.typeFactory, targetType, this.dateFormat);
            return conversionProvider.to(ctx);
        }

        private Assignment resolveViaMethod(Type sourceType, Type targetType) {
            SourceMethod matchingSourceMethod = this.getBestMatch(this.methods, sourceType, targetType);
            if (matchingSourceMethod != null) {
                return this.getMappingMethodReference(matchingSourceMethod, this.mapperReferences, targetType);
            }
            BuiltInMethod matchingBuiltInMethod = this.getBestMatch(this.context.builtInMethods.getBuiltInMethods(), sourceType, targetType);
            if (matchingBuiltInMethod != null) {
                this.virtualMethodCandidates.add(new VirtualMappingMethod(matchingBuiltInMethod));
                DefaultConversionContext ctx = new DefaultConversionContext(this.context.typeFactory, targetType, this.dateFormat);
                Assignment methodReference = AssignmentFactory.createMethodReference(matchingBuiltInMethod, ctx);
                methodReference.setAssignment(AssignmentFactory.createSimple(this.sourceReference));
                return methodReference;
            }
            return null;
        }

        private Assignment resolveViaMethodAndMethod(Type sourceType, Type targetType) {
            ArrayList<SourceMethod> methodYCandidates = new ArrayList<SourceMethod>(this.methods);
            methodYCandidates.addAll(this.context.builtInMethods.getBuiltInMethods());
            Assignment methodRefY = null;
            for (Method method : methodYCandidates) {
                if (method.getSourceParameters().size() != 1 || (methodRefY = this.resolveViaMethod(method.getSourceParameters().get(0).getType(), targetType)) == null) continue;
                Assignment methodRefX = this.resolveViaMethod(sourceType, method.getSourceParameters().get(0).getType());
                if (methodRefX != null) {
                    methodRefY.setAssignment(methodRefX);
                    methodRefX.setAssignment(AssignmentFactory.createSimple(this.sourceReference));
                    break;
                }
                this.virtualMethodCandidates.clear();
                methodRefY = null;
            }
            return methodRefY;
        }

        private Assignment resolveViaConversionAndMethod(Type sourceType, Type targetType) {
            ArrayList<SourceMethod> methodYCandidates = new ArrayList<SourceMethod>(this.methods);
            methodYCandidates.addAll(this.context.builtInMethods.getBuiltInMethods());
            Assignment methodRefY = null;
            for (Method method : methodYCandidates) {
                if (method.getSourceParameters().size() != 1 || (methodRefY = this.resolveViaMethod(method.getSourceParameters().get(0).getType(), targetType)) == null) continue;
                Assignment conversionXRef = this.resolveViaConversion(sourceType, method.getSourceParameters().get(0).getType());
                if (conversionXRef != null) {
                    methodRefY.setAssignment(conversionXRef);
                    conversionXRef.setAssignment(new Direct(this.sourceReference));
                    break;
                }
                this.virtualMethodCandidates.clear();
                methodRefY = null;
            }
            return methodRefY;
        }

        private Assignment resolveViaMethodAndConversion(Type sourceType, Type targetType) {
            ArrayList<SourceMethod> methodXCandidates = new ArrayList<SourceMethod>(this.methods);
            methodXCandidates.addAll(this.context.builtInMethods.getBuiltInMethods());
            Assignment conversionYRef = null;
            for (Method method : methodXCandidates) {
                Assignment methodRefX;
                if (method.getSourceParameters().size() != 1 || (methodRefX = this.resolveViaMethod(sourceType, method.getReturnType())) == null) continue;
                conversionYRef = this.resolveViaConversion(method.getReturnType(), targetType);
                if (conversionYRef != null) {
                    conversionYRef.setAssignment(methodRefX);
                    methodRefX.setAssignment(new Direct(this.sourceReference));
                    break;
                }
                this.virtualMethodCandidates.clear();
                conversionYRef = null;
            }
            return conversionYRef;
        }

        private <T extends Method> T getBestMatch(List<T> methods, Type sourceType, Type returnType) {
            List<T> candidates = this.context.methodSelectors.getMatchingMethods(this.mappingMethod, methods, sourceType, returnType, this.targetPropertyName);
            if (candidates.size() > 1) {
                this.context.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Ambiguous mapping methods found for mapping " + this.mappedElement + " from %s to %s: %s.", sourceType, returnType, Strings.join(candidates, ", ")), this.mappingMethod.getExecutable());
            }
            if (!candidates.isEmpty()) {
                return (T)((Method)candidates.get(0));
            }
            return null;
        }

        private Assignment getMappingMethodReference(SourceMethod method, List<MapperReference> mapperReferences, Type targetType) {
            MapperReference mapperReference = this.findMapperReference(mapperReferences, method);
            return AssignmentFactory.createMethodReference(method, mapperReference, SourceMethod.containsTargetTypeParameter(method.getParameters()) ? targetType : null);
        }

        private MapperReference findMapperReference(List<MapperReference> mapperReferences, SourceMethod method) {
            for (MapperReference ref : mapperReferences) {
                if (!ref.getType().equals(method.getDeclaringMapper())) continue;
                return ref;
            }
            return null;
        }
    }
}

