/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.annotation.linear;

import de.bwaldvogel.liblinear.DenseLinear;
import de.bwaldvogel.liblinear.DenseProblem;
import de.bwaldvogel.liblinear.Feature;
import de.bwaldvogel.liblinear.Linear;
import de.bwaldvogel.liblinear.Model;
import de.bwaldvogel.liblinear.Parameter;
import de.bwaldvogel.liblinear.Problem;
import de.bwaldvogel.liblinear.SolverType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.data.dataset.GroupedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.feature.FeatureExtractor;
import org.openimaj.feature.FeatureVector;
import org.openimaj.ml.annotation.Annotated;
import org.openimaj.ml.annotation.AnnotatedObject;
import org.openimaj.ml.annotation.BatchAnnotator;
import org.openimaj.ml.annotation.ScoredAnnotation;
import org.openimaj.ml.annotation.utils.AnnotatedListHelper;
import org.openimaj.ml.annotation.utils.LiblinearHelper;

@Reference(type=ReferenceType.Article, author={"Fan, Rong-En", "Chang, Kai-Wei", "Hsieh, Cho-Jui", "Wang, Xiang-Rui", "Lin, Chih-Jen"}, title="LIBLINEAR: A Library for Large Linear Classification", year="2008", journal="J. Mach. Learn. Res.", pages={"1871", "", "1874"}, url="http://dl.acm.org/citation.cfm?id=1390681.1442794", month="june", publisher="JMLR.org", volume="9", customData={"date", "6/1/2008", "issn", "1532-4435", "numpages", "4", "acmid", "1442794"})
public class LiblinearAnnotator<OBJECT, ANNOTATION>
extends BatchAnnotator<OBJECT, ANNOTATION> {
    InternalModel<OBJECT, ANNOTATION> internal;

    public LiblinearAnnotator(FeatureExtractor<? extends FeatureVector, OBJECT> extractor, Mode mode, SolverType solver, double C, double eps) {
        this(extractor, mode, solver, C, eps, -1.0, false);
    }

    public LiblinearAnnotator(FeatureExtractor<? extends FeatureVector, OBJECT> extractor, Mode mode, SolverType solver, double C, double eps, double bias, boolean dense) {
        switch (mode) {
            case MULTICLASS: {
                this.internal = new Multiclass(solver, C, eps, bias, dense);
                break;
            }
            case MULTILABEL: {
                this.internal = new Multilabel(solver, C, eps, bias, dense);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled mode");
            }
        }
        this.internal.extractor = extractor;
    }

    @Override
    public void train(List<? extends Annotated<OBJECT, ANNOTATION>> data) {
        this.internal.train(data);
    }

    @Override
    public Set<ANNOTATION> getAnnotations() {
        return new HashSet(this.internal.annotationsList);
    }

    @Override
    public List<ScoredAnnotation<ANNOTATION>> annotate(OBJECT object) {
        return this.internal.annotate(object);
    }

    @Override
    public void train(GroupedDataset<ANNOTATION, ListDataset<OBJECT>, OBJECT> dataset) {
        this.internal.train(dataset);
    }

    static class Multilabel<OBJECT, ANNOTATION>
    extends InternalModel<OBJECT, ANNOTATION> {
        private Parameter parameter;
        private Model[] models;
        private static final int NEGATIVE_CLASS = 1;
        private static final int POSTIVE_CLASS = 2;

        public Multilabel(SolverType solver, double C, double eps, double bias, boolean dense) {
            this.parameter = new Parameter(solver, C, eps);
            this.dense = dense;
            this.bias = bias;
        }

        @Override
        public void train(List<? extends Annotated<OBJECT, ANNOTATION>> data) {
            AnnotatedListHelper helper = new AnnotatedListHelper(data);
            Set annotations = helper.getAnnotations();
            this.annotationsList = new ArrayList(annotations);
            int featureLength = ((FeatureVector)this.extractor.extractFeature(data.get(0).getObject())).length();
            this.models = new Model[this.annotationsList.size()];
            for (int i = 0; i < this.annotationsList.size(); ++i) {
                int k;
                int j;
                DenseProblem problem;
                Object annotation = this.annotationsList.get(i);
                List positive = helper.extractFeatures(annotation, this.extractor);
                List negative = helper.extractFeaturesExclude(annotation, this.extractor);
                if (this.dense) {
                    problem = new DenseProblem();
                    problem.l = positive.size() + negative.size();
                    problem.n = featureLength;
                    problem.bias = this.bias;
                    problem.x = new double[problem.l][];
                    problem.y = new double[problem.l];
                    for (j = 0; j < negative.size(); ++j) {
                        problem.x[j] = LiblinearHelper.convertDense((FeatureVector)negative.get(j), this.bias);
                        problem.y[j] = 1.0;
                    }
                    j = negative.size();
                    for (k = 0; k < positive.size(); ++k) {
                        problem.x[j] = LiblinearHelper.convertDense((FeatureVector)positive.get(k), this.bias);
                        problem.y[j] = 2.0;
                        ++j;
                    }
                    this.models[i] = DenseLinear.train((DenseProblem)problem, (Parameter)this.parameter);
                    continue;
                }
                problem = new Problem();
                problem.l = positive.size() + negative.size();
                problem.n = featureLength;
                problem.bias = this.bias;
                problem.x = new Feature[problem.l][];
                problem.y = new double[problem.l];
                for (j = 0; j < negative.size(); ++j) {
                    problem.x[j] = LiblinearHelper.convert((FeatureVector)negative.get(j), this.bias);
                    problem.y[j] = 1.0;
                }
                j = negative.size();
                for (k = 0; k < positive.size(); ++k) {
                    problem.x[j] = LiblinearHelper.convert((FeatureVector)positive.get(k), this.bias);
                    problem.y[j] = 2.0;
                    ++j;
                }
                this.models[i] = Linear.train((Problem)problem, (Parameter)this.parameter);
            }
        }

        @Override
        public List<ScoredAnnotation<ANNOTATION>> annotate(OBJECT object) {
            ArrayList<ScoredAnnotation<ANNOTATION>> result = new ArrayList<ScoredAnnotation<ANNOTATION>>();
            if (this.dense) {
                double[] feature = this.computeFeatureDense(object);
                for (int i = 0; i < this.annotationsList.size(); ++i) {
                    double prob;
                    double clz;
                    if (this.parameter.getSolverType().isLogisticRegressionSolver()) {
                        double[] probs = new double[this.annotationsList.size()];
                        clz = DenseLinear.predictProbability((Model)this.models[i], (double[])feature, (double[])probs);
                        prob = probs[(int)clz - 1];
                    } else {
                        double[] prob_estimates = new double[2];
                        clz = DenseLinear.predictValues((Model)this.models[i], (double[])feature, (double[])prob_estimates);
                        this.computeProbabilities(prob_estimates);
                        prob = prob_estimates[(int)clz - 1];
                    }
                    if (clz != 2.0) continue;
                    result.add(new ScoredAnnotation(this.annotationsList.get(i), (float)prob));
                }
            } else {
                Feature[] feature = this.computeFeature(object);
                for (int i = 0; i < this.annotationsList.size(); ++i) {
                    double prob;
                    double clz;
                    if (this.parameter.getSolverType().isLogisticRegressionSolver()) {
                        double[] probs = new double[this.annotationsList.size()];
                        clz = Linear.predictProbability((Model)this.models[i], (Feature[])feature, (double[])probs);
                        prob = probs[(int)clz - 1];
                    } else {
                        double[] prob_estimates = new double[2];
                        clz = Linear.predictValues((Model)this.models[i], (Feature[])feature, (double[])prob_estimates);
                        this.computeProbabilities(prob_estimates);
                        prob = prob_estimates[(int)clz - 1];
                    }
                    if (clz != 2.0) continue;
                    result.add(new ScoredAnnotation(this.annotationsList.get(i), (float)prob));
                }
            }
            return result;
        }

        @Override
        public void train(GroupedDataset<ANNOTATION, ListDataset<OBJECT>, OBJECT> dataset) {
            this.train(AnnotatedObject.createList(dataset));
        }
    }

    static class Multiclass<OBJECT, ANNOTATION>
    extends InternalModel<OBJECT, ANNOTATION> {
        private Parameter parameter;
        private Model model;

        public Multiclass(SolverType solver, double C, double eps, double bias, boolean dense) {
            this.parameter = new Parameter(solver, C, eps);
            this.dense = dense;
            this.bias = bias;
        }

        @Override
        public void train(GroupedDataset<ANNOTATION, ListDataset<OBJECT>, OBJECT> dataset) {
            this.annotationsList = new ArrayList(dataset.getGroups());
            int nItems = dataset.numInstances();
            int featureLength = ((FeatureVector)this.extractor.extractFeature(dataset.getRandomInstance())).length();
            if (this.dense) {
                DenseProblem problem = new DenseProblem();
                problem.l = nItems;
                problem.n = featureLength + 1;
                problem.bias = this.bias;
                problem.x = new double[nItems][];
                problem.y = new double[nItems];
                int i = 0;
                for (Object annotation : dataset.getGroups()) {
                    for (Object object : (ListDataset)dataset.get(annotation)) {
                        problem.y[i] = this.annotationsList.indexOf(annotation) + 1;
                        problem.x[i] = this.computeFeatureDense(object);
                        ++i;
                    }
                }
                this.model = DenseLinear.train((DenseProblem)problem, (Parameter)this.parameter);
            } else {
                Problem problem = new Problem();
                problem.l = nItems;
                problem.n = featureLength;
                problem.bias = this.bias;
                problem.x = new Feature[nItems][];
                problem.y = new double[nItems];
                int i = 0;
                for (Object annotation : dataset.getGroups()) {
                    for (Object object : (ListDataset)dataset.get(annotation)) {
                        problem.y[i] = this.annotationsList.indexOf(annotation) + 1;
                        problem.x[i] = this.computeFeature(object);
                        ++i;
                    }
                }
                this.model = Linear.train((Problem)problem, (Parameter)this.parameter);
            }
        }

        @Override
        public void train(List<? extends Annotated<OBJECT, ANNOTATION>> data) {
            AnnotatedListHelper helper = new AnnotatedListHelper(data);
            Set annotations = helper.getAnnotations();
            this.annotationsList = new ArrayList(annotations);
            int nItems = data.size();
            int featureLength = ((FeatureVector)this.extractor.extractFeature(data.get(0).getObject())).length();
            if (this.dense) {
                DenseProblem problem = new DenseProblem();
                problem.l = nItems;
                problem.n = featureLength;
                problem.bias = this.bias;
                problem.x = new double[nItems][];
                problem.y = new double[nItems];
                for (int i = 0; i < nItems; ++i) {
                    Annotated<OBJECT, ANNOTATION> object = data.get(i);
                    if (object.getAnnotations().size() != 1) {
                        throw new IllegalArgumentException("A multiclass problem cannot have more than one class per instance");
                    }
                    ANNOTATION annotation = object.getAnnotations().iterator().next();
                    problem.y[i] = this.annotationsList.indexOf(annotation) + 1;
                    problem.x[i] = this.computeFeatureDense(object.getObject());
                }
                this.model = DenseLinear.train((DenseProblem)problem, (Parameter)this.parameter);
            } else {
                Problem problem = new Problem();
                problem.l = nItems;
                problem.n = featureLength;
                problem.bias = this.bias;
                problem.x = new Feature[nItems][];
                problem.y = new double[nItems];
                for (int i = 0; i < nItems; ++i) {
                    Annotated<OBJECT, ANNOTATION> object = data.get(i);
                    if (object.getAnnotations().size() != 1) {
                        throw new IllegalArgumentException("A multiclass problem cannot have more than one class per instance");
                    }
                    ANNOTATION annotation = object.getAnnotations().iterator().next();
                    problem.y[i] = this.annotationsList.indexOf(annotation) + 1;
                    problem.x[i] = this.computeFeature(object.getObject());
                }
                this.model = Linear.train((Problem)problem, (Parameter)this.parameter);
            }
        }

        @Override
        public List<ScoredAnnotation<ANNOTATION>> annotate(OBJECT object) {
            double prob;
            double clz;
            Object[] feature;
            if (this.dense) {
                feature = this.computeFeatureDense(object);
                if (this.parameter.getSolverType().isLogisticRegressionSolver()) {
                    double[] probs = new double[this.annotationsList.size()];
                    clz = DenseLinear.predictProbability((Model)this.model, (double[])feature, (double[])probs) - 1.0;
                    prob = probs[(int)clz];
                } else {
                    double[] prob_estimates = new double[this.annotationsList.size()];
                    clz = DenseLinear.predictValues((Model)this.model, (double[])feature, (double[])prob_estimates) - 1.0;
                    this.computeProbabilities(prob_estimates);
                    prob = prob_estimates[(int)clz];
                }
            } else {
                feature = this.computeFeature(object);
                if (this.parameter.getSolverType().isLogisticRegressionSolver()) {
                    double[] probs = new double[this.annotationsList.size()];
                    clz = Linear.predictProbability((Model)this.model, (Feature[])feature, (double[])probs) - 1.0;
                    prob = probs[(int)clz];
                } else {
                    double[] prob_estimates = new double[this.annotationsList.size()];
                    clz = Linear.predictValues((Model)this.model, (Feature[])feature, (double[])prob_estimates) - 1.0;
                    this.computeProbabilities(prob_estimates);
                    prob = prob_estimates[(int)clz];
                }
            }
            ArrayList<ScoredAnnotation<ANNOTATION>> result = new ArrayList<ScoredAnnotation<ANNOTATION>>(1);
            result.add(new ScoredAnnotation(this.annotationsList.get((int)clz), (float)prob));
            return result;
        }
    }

    static abstract class InternalModel<OBJECT, ANNOTATION> {
        ArrayList<ANNOTATION> annotationsList;
        FeatureExtractor<? extends FeatureVector, OBJECT> extractor;
        boolean dense;
        double bias = -1.0;
        boolean estimateProbabilities = true;

        InternalModel() {
        }

        public abstract void train(List<? extends Annotated<OBJECT, ANNOTATION>> var1);

        public abstract void train(GroupedDataset<ANNOTATION, ListDataset<OBJECT>, OBJECT> var1);

        public abstract List<ScoredAnnotation<ANNOTATION>> annotate(OBJECT var1);

        Feature[] computeFeature(OBJECT object) {
            FeatureVector feature = (FeatureVector)this.extractor.extractFeature(object);
            return LiblinearHelper.convert(feature, this.bias);
        }

        double[] computeFeatureDense(OBJECT object) {
            FeatureVector feature = (FeatureVector)this.extractor.extractFeature(object);
            return LiblinearHelper.convertDense(feature, this.bias);
        }

        void computeProbabilities(double[] prob_estimates) {
            if (!this.estimateProbabilities) {
                return;
            }
            int nr_class = this.annotationsList.size();
            int nr_w = nr_class == 2 ? 1 : nr_class;
            for (int i = 0; i < nr_w; ++i) {
                prob_estimates[i] = 1.0 / (1.0 + Math.exp(-prob_estimates[i]));
            }
            if (nr_class == 2) {
                prob_estimates[1] = 1.0 - prob_estimates[0];
            } else {
                int i;
                double sum = 0.0;
                for (i = 0; i < nr_class; ++i) {
                    sum += prob_estimates[i];
                }
                for (i = 0; i < nr_class; ++i) {
                    prob_estimates[i] = prob_estimates[i] / sum;
                }
            }
        }
    }

    public static enum Mode {
        MULTICLASS,
        MULTILABEL;

    }
}

