/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.linear.data;

import java.util.Random;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Vector;
import org.openimaj.math.matrix.GramSchmidtProcess;
import org.openimaj.ml.linear.data.DataGenerator;
import org.openimaj.ml.linear.learner.perceptron.PerceptronClass;
import org.openimaj.util.pair.IndependentPair;

public class LinearPerceptronDataGenerator
implements DataGenerator<double[], PerceptronClass> {
    private Vector origin;
    private Vector direction;
    private Random rng;
    private double range;
    private int dims;
    private double prop;
    private double error = 0.0;

    public LinearPerceptronDataGenerator(double range, int dims, double prop) {
        this(range, dims, prop, -1);
    }

    public LinearPerceptronDataGenerator(double range, int dims, double prop, int seed) {
        this.range = range;
        this.dims = dims;
        this.prop = prop;
        this.rng = seed < 0 ? new Random() : new Random(seed);
        int limitedDim = this.rng.nextInt(dims);
        double validRange = this.range * prop;
        double start = (this.range - validRange) / 2.0;
        double[] startPoint = new double[dims];
        double[] endPoint = new double[dims];
        double[] originPoint = new double[dims];
        for (int i = 0; i < endPoint.length; ++i) {
            if (i == limitedDim) {
                startPoint[i] = 0.0;
                endPoint[i] = range;
                originPoint[i] = start + this.rng.nextDouble() * validRange;
                continue;
            }
            startPoint[i] = start + this.rng.nextDouble() * validRange;
            endPoint[i] = start + this.rng.nextDouble() * validRange;
            originPoint[i] = this.rng.nextDouble() * range;
        }
        this.direction = (DenseVector)new DenseVector(endPoint).add(-1.0, (Vector)new DenseVector(startPoint));
        this.origin = new DenseVector(originPoint);
    }

    private double nextRandomValue() {
        return this.rng.nextDouble() * this.range;
    }

    @Override
    public IndependentPair<double[], PerceptronClass> generate() {
        double[] randomPoint;
        double sgn;
        PerceptronClass sgnClass;
        double decide = Math.signum(this.rng.nextDouble() - 0.5);
        if (decide == 0.0) {
            decide = 1.0;
        }
        PerceptronClass dec = PerceptronClass.fromSign(decide);
        do {
            randomPoint = new double[this.dims];
            for (int i = 0; i < randomPoint.length; ++i) {
                randomPoint[i] = this.nextRandomValue();
            }
            DenseVector v = new DenseVector(randomPoint);
            v.add(-1.0, this.origin);
            Vector d = this.direction.copy();
            double dot = v.dot(d);
            sgn = Math.signum(dot);
            if (sgn == 0.0) {
                sgn = 1.0;
            }
            if (!(this.rng.nextDouble() < this.error)) continue;
            sgn = -sgn;
        } while (!(sgnClass = PerceptronClass.fromSign(sgn)).equals((Object)dec));
        return IndependentPair.pair((Object)randomPoint, (Object)((Object)sgnClass));
    }

    public Vector getOrigin() {
        return this.origin;
    }

    public Vector getNormDirection() {
        return this.direction;
    }

    public Vector[] getPlane() {
        Vector[] allInclusive = new GramSchmidtProcess().apply(new DenseVector(this.direction).getData());
        Vector[] ret = new Vector[allInclusive.length - 1];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = allInclusive[i + 1];
        }
        return ret;
    }

    public void setError(double d) {
        this.error = d;
    }
}

