/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.linear.learner;

import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.math.matrix.Matrix;
import org.apache.log4j.Logger;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.math.matrix.CFMatrixUtils;
import org.openimaj.ml.linear.learner.BilinearSparseOnlineLearner;

@Reference(author={"Andre F. T. Martins"}, title="The Geometry of Constrained Structured Prediction: Applications to Inference and Learning of Natural Language Syntax", type=ReferenceType.Phdthesis, year="2012")
public class BilinearUnmixedSparseOnlineLearner
extends BilinearSparseOnlineLearner {
    static Logger logger = Logger.getLogger(BilinearUnmixedSparseOnlineLearner.class);

    @Override
    protected Matrix updateW(Matrix currentW, double wLossWeighted, double weightedLambda) {
        Matrix current = currentW;
        int iter = 0;
        Double biconvextol = (Double)this.params.getTyped("biconvex_tol");
        Integer maxiter = (Integer)this.params.getTyped("biconvex_maxiter");
        while (true) {
            Matrix newcurrent = super.updateW(current, wLossWeighted, weightedLambda);
            double sumchange = CFMatrixUtils.absSum((Matrix)((Matrix)current.minus((Ring)newcurrent)));
            double total = CFMatrixUtils.absSum((Matrix)current);
            double ratio = sumchange / total;
            current = newcurrent;
            if (ratio < biconvextol || iter >= maxiter) break;
            ++iter;
        }
        logger.debug((Object)("W tolerance reached after iteration: " + iter));
        return current;
    }

    @Override
    protected Matrix updateU(Matrix currentU, Matrix neww, double uLossWeighted, double weightedLambda) {
        Matrix current = currentU;
        int iter = 0;
        Double biconvextol = (Double)this.params.getTyped("biconvex_tol");
        Integer maxiter = (Integer)this.params.getTyped("biconvex_maxiter");
        while (true) {
            Matrix newcurrent = super.updateU(current, neww, uLossWeighted, weightedLambda);
            double sumchange = CFMatrixUtils.absSum((Matrix)((Matrix)current.minus((Ring)newcurrent)));
            double total = CFMatrixUtils.absSum((Matrix)current);
            double ratio = sumchange / total;
            current = newcurrent;
            if (ratio < biconvextol || iter >= maxiter) break;
            ++iter;
        }
        logger.debug((Object)("U tolerance reached after iteration: " + iter));
        return current;
    }
}

