/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.linear.learner.init;

import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.mtj.DenseMatrix;
import gov.sandia.cognition.math.matrix.mtj.DenseMatrixFactoryMTJ;
import org.openimaj.ml.linear.learner.init.AbstractContextAwareInitStrategy;

public abstract class CurrentValueMean
extends AbstractContextAwareInitStrategy<Matrix, Matrix> {
    @Override
    public Matrix init(int rows, int cols) {
        Matrix currentValues = this.getCurrentValues();
        Vector mean = (Vector)currentValues.sumOfRows().scale((double)(1.0f / (float)currentValues.getNumRows()));
        DenseMatrix m = DenseMatrixFactoryMTJ.INSTANCE.createMatrix(rows, cols);
        for (int r = 0; r < m.getNumRows(); ++r) {
            m.setRow(r, mean);
        }
        return m;
    }

    public abstract Matrix getCurrentValues();
}

