/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.linear.learner.matlib.regul;

import ch.akuhn.matrix.Matrix;
import ch.akuhn.matrix.Vector;
import org.openimaj.ml.linear.learner.matlib.regul.Regulariser;

public class L1Regulariser
implements Regulariser {
    @Override
    public Matrix prox(Matrix W, double lambda) {
        return this.softThreshold(W, lambda);
    }

    private Matrix softThreshold(Matrix w, double lambda) {
        Matrix ret = w.newInstance();
        int rowi = 0;
        for (Vector row : w.rows()) {
            for (Vector.Entry ent : row.entries()) {
                if (ent.value < -lambda) {
                    ret.put(rowi, ent.index, ent.value + lambda);
                    continue;
                }
                if (!(ent.value > lambda)) continue;
                ret.put(rowi, ent.index, ent.value - lambda);
            }
            ++rowi;
        }
        return ret;
    }
}

