/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.timeseries.collection;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.openimaj.ml.timeseries.IncompatibleTimeSeriesException;
import org.openimaj.ml.timeseries.TimeSeries;
import org.openimaj.ml.timeseries.TimeSeriesSetException;
import org.openimaj.ml.timeseries.collection.TimeSeriesCollection;

public abstract class SynchronisedTimeSeriesCollection<ALLINPUT, SINGLEINPUT, TIMESERIES extends SynchronisedTimeSeriesCollection<ALLINPUT, SINGLEINPUT, TIMESERIES, INTERNALSERIES>, INTERNALSERIES extends TimeSeries<ALLINPUT, SINGLEINPUT, INTERNALSERIES>>
extends TimeSeriesCollection<ALLINPUT, SINGLEINPUT, TIMESERIES, INTERNALSERIES> {
    long[] time;

    @Override
    public void addTimeSeries(String name, INTERNALSERIES series) throws IncompatibleTimeSeriesException {
        if (this.time == null) {
            this.time = ((TimeSeries)series).getTimes();
        } else if (!Arrays.equals(this.time, ((TimeSeries)series).getTimes())) {
            throw new IncompatibleTimeSeriesException();
        }
        super.addTimeSeries(name, series);
    }

    @Override
    public INTERNALSERIES series(String name) {
        return (INTERNALSERIES)((TimeSeries)this.timeSeriesHolder.get(name));
    }

    @Override
    public Collection<INTERNALSERIES> allseries() {
        return this.timeSeriesHolder.values();
    }

    @Override
    public long[] getTimes() {
        return this.time;
    }

    @Override
    public void set(long[] time, Map<String, ALLINPUT> data) throws TimeSeriesSetException {
        this.time = time;
        Object intitalInstance = this.internalNewInstance();
        this.timeSeriesHolder = new HashMap();
        for (Map.Entry<String, ALLINPUT> l : data.entrySet()) {
            Object intital = ((TimeSeries)intitalInstance).newInstance();
            ((TimeSeries)intital).set(time, l.getValue());
            this.timeSeriesHolder.put(l.getKey(), intital);
        }
    }

    @Override
    public Map<String, ALLINPUT> getData() {
        HashMap ret = new HashMap();
        for (Map.Entry held : this.timeSeriesHolder.entrySet()) {
            ret.put(held.getKey(), ((TimeSeries)held.getValue()).getData());
        }
        return ret;
    }

    @Override
    public int size() {
        if (this.time != null) {
            return this.time.length;
        }
        return 0;
    }

    @Override
    public void internalAssign(TIMESERIES interpolate) {
        this.time = ((SynchronisedTimeSeriesCollection)interpolate).time;
        this.timeSeriesHolder = ((SynchronisedTimeSeriesCollection)interpolate).timeSeriesHolder;
    }

    @Override
    public String toString() {
        return "Synchronised Time series";
    }

    public abstract ALLINPUT flatten();
}

