/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.timeseries.processor;

import java.util.LinkedList;
import org.openimaj.ml.timeseries.TimeSeries;
import org.openimaj.ml.timeseries.TimeSeriesArithmaticOperator;
import org.openimaj.ml.timeseries.collection.TimeSeriesCollectionAssignable;
import org.openimaj.ml.timeseries.processor.TimeSeriesProcessor;

public class IntervalSummationProcessor<ALLDATA, DATA, TS extends TimeSeries<ALLDATA, DATA, TS> & TimeSeriesCollectionAssignable<DATA, TS>>
implements TimeSeriesProcessor<ALLDATA, DATA, TS> {
    private long[] times;

    public IntervalSummationProcessor(long[] times) {
        this.times = times;
    }

    @Override
    public void process(TS series) {
        LinkedList<Long> times = new LinkedList<Long>();
        LinkedList data = new LinkedList();
        times.addLast(this.times[0]);
        long firstTime = ((TimeSeries)series).getTimes()[0];
        Object interval = ((TimeSeries)series).get(firstTime, this.times[0]);
        long previousTime = -1L;
        if (((TimeSeries)interval).size() > 0) {
            long[] intervalTimes = ((TimeSeries)interval).getTimes();
            previousTime = intervalTimes[intervalTimes.length - 1] + 1L;
        } else {
            previousTime = this.times[0] + 1L;
        }
        data.addLast(((TimeSeriesArithmaticOperator)interval).sum());
        for (int i = 1; i < this.times.length; ++i) {
            long currentTime = this.times[i];
            interval = ((TimeSeries)series).get(previousTime, currentTime);
            if (((TimeSeries)interval).size() > 0) {
                long[] intervalTimes = ((TimeSeries)interval).getTimes();
                previousTime = intervalTimes[intervalTimes.length - 1] + 1L;
            } else {
                previousTime = currentTime + 1L;
            }
            times.add(currentTime);
            data.add(((TimeSeriesArithmaticOperator)interval).sum());
        }
        ((TimeSeriesCollectionAssignable)series).internalAssign(times, data);
    }
}

