/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.customize.defaults;

import java.io.OutputStream;
import java.util.regex.Pattern;
import org.rapidoid.RapidoidThing;
import org.rapidoid.gui.GUI;
import org.rapidoid.http.Req;
import org.rapidoid.http.Resp;
import org.rapidoid.http.customize.PageDecorator;
import org.rapidoid.u.U;
import org.rapidoid.web.Screen;
import org.rapidoid.writable.Writable;
import org.rapidoid.writable.WritableOutputStream;
import org.rapidoid.writable.WritableUtils;

public class DefaultPageDecorator
extends RapidoidThing
implements PageDecorator {
    private static final String FULL_PAGE_REGEX = "(?s)^(?:\\s*(<!--(?:.*?)-->)*?)*?<(!DOCTYPE\\s+html|html)>";
    private static final Pattern FULL_PAGE_PATTERN = Pattern.compile("(?s)^(?:\\s*(<!--(?:.*?)-->)*?)*?<(!DOCTYPE\\s+html|html)>");

    @Override
    public void renderPage(Req req, String content, OutputStream out) throws Exception {
        U.notNull((Object)content, (String)"page content", (Object[])new Object[0]);
        Resp resp = req.response();
        if (this.isFullPage(req, content)) {
            WritableUtils.writeUTF8((Writable)new WritableOutputStream(out), (String)content);
            return;
        }
        Screen screen = resp.screen();
        screen.content(new Object[]{GUI.hardcoded((String)content)});
        screen.render(out);
    }

    private boolean isFullPage(Req req, String content) {
        return req.attr("_embedded", false) != false && content.startsWith("<!--EMBEDDED-->") || FULL_PAGE_PATTERN.matcher(content).find();
    }
}

