/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.handler;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.rapidoid.annotation.TransactionMode;
import org.rapidoid.ctx.With;
import org.rapidoid.datamodel.Results;
import org.rapidoid.http.FastHttp;
import org.rapidoid.http.HttpRoutes;
import org.rapidoid.http.HttpStatus;
import org.rapidoid.http.HttpUtils;
import org.rapidoid.http.HttpWrapper;
import org.rapidoid.http.MediaType;
import org.rapidoid.http.NotFound;
import org.rapidoid.http.Req;
import org.rapidoid.http.customize.Customization;
import org.rapidoid.http.handler.AbstractHttpHandler;
import org.rapidoid.http.handler.HandlerInvocation;
import org.rapidoid.http.impl.MaybeReq;
import org.rapidoid.http.impl.RouteOptions;
import org.rapidoid.http.impl.lowlevel.HttpIO;
import org.rapidoid.jpa.JPA;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.log.Log;
import org.rapidoid.log.LogLevel;
import org.rapidoid.net.abstracts.Channel;
import org.rapidoid.security.Secure;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;
import org.rapidoid.util.TokenAuthData;

public abstract class AbstractDecoratingHttpHandler
extends AbstractHttpHandler {
    private static final String CTX_TAG_INIT = "init";
    private static final String CTX_TAG_HANDLER = "handler";
    private static final String CTX_TAG_ERROR = "error";
    private static final HttpWrapper[] NO_WRAPPERS = new HttpWrapper[0];
    private final FastHttp http;

    public AbstractDecoratingHttpHandler(FastHttp http, HttpRoutes routes, RouteOptions options) {
        super(options);
        this.http = http;
    }

    @Override
    public boolean needsParams() {
        return true;
    }

    @Override
    public final HttpStatus handle(Channel ctx, boolean isKeepAlive, Req req, Object extra) {
        return this.options.managed() ? this.handleDecorating(ctx, isKeepAlive, req, extra) : this.handleNonDecorating(ctx, isKeepAlive, req, extra);
    }

    private HttpStatus handleNonDecorating(Channel ctx, boolean isKeepAlive, Req req, Object extra) {
        Object result;
        MaybeReq maybeReq = HttpUtils.maybe(req);
        try {
            result = this.handleReqAndPostProcess(ctx, isKeepAlive, req, extra);
            result = HttpUtils.postprocessResult(req, result);
            if (req != null && req.isAsync() || result == HttpStatus.ASYNC) {
                return HttpStatus.ASYNC;
            }
        }
        catch (Exception e) {
            HttpIO.INSTANCE.writeResponse(maybeReq, ctx, isKeepAlive, 500, this.contentType, "Internal server error!".getBytes());
            Log.error((String)"Error occurred during un-managed request processing", (String)"request", (Object)req, (String)CTX_TAG_ERROR, (Object)e);
            return HttpStatus.ERROR;
        }
        if (this.contentType == MediaType.JSON) {
            HttpIO.INSTANCE.writeAsJson(maybeReq, ctx, 200, isKeepAlive, result);
        } else {
            HttpIO.INSTANCE.write200(maybeReq, ctx, isKeepAlive, this.contentType, Msc.toBytes((Object)result));
        }
        return HttpStatus.DONE;
    }

    private HttpStatus handleDecorating(Channel ctx, boolean isKeepAlive, Req req, Object extra) {
        if (!ctx.isAsync()) {
            ctx.async();
        }
        this.execHandlerJob(ctx, isKeepAlive, this.options.contentType(), req, extra);
        return HttpStatus.ASYNC;
    }

    private Set<String> userRoles(Req req, String username) {
        if (username != null) {
            try {
                return Customization.of(req).rolesProvider().getRolesForUser(req, username);
            }
            catch (Exception e) {
                throw U.rte((Throwable)e);
            }
        }
        return Collections.emptySet();
    }

    private TransactionMode before(Req req, String username, Set<String> roles) {
        if (U.notEmpty(this.options.roles()) && !Secure.hasAnyRole((String)username, roles, this.options.roles())) {
            throw new SecurityException("The user doesn't have the required roles!");
        }
        req.response().view(this.options.view()).contentType(this.options.contentType()).mvc(this.options.mvc());
        TransactionMode txMode = (TransactionMode)U.or((Object)this.options.transaction(), (Object)TransactionMode.NONE);
        if (txMode == TransactionMode.AUTO) {
            txMode = HttpUtils.isGetReq(req) ? TransactionMode.READ_ONLY : TransactionMode.READ_WRITE;
        }
        return txMode;
    }

    private void execHandlerJob(final Channel channel, final boolean isKeepAlive, final MediaType contentType, final Req req, final Object extra) {
        With.tag((String)CTX_TAG_INIT).exchange((Object)req).run(new Runnable(){
            volatile String username = null;
            volatile Set<String> roles = null;
            volatile Set<String> scope = null;

            @Override
            public void run() {
                try {
                    TokenAuthData auth = HttpUtils.getAuth(req);
                    if (auth != null) {
                        this.username = auth.user;
                    }
                    if (U.isEmpty((String)this.username)) {
                        HttpUtils.clearUserData(req);
                    }
                    this.roles = AbstractDecoratingHttpHandler.this.userRoles(req, this.username);
                    this.scope = auth != null ? auth.scope : null;
                    TransactionMode txMode = AbstractDecoratingHttpHandler.this.before(req, this.username, this.roles);
                    U.notNull((Object)txMode, (String)"txMode", (Object[])new Object[0]);
                    HttpWrapper[] wrappers = AbstractDecoratingHttpHandler.this.httpWrappers != null ? AbstractDecoratingHttpHandler.this.httpWrappers : (HttpWrapper[])U.or((Object)Customization.of(req).wrappers(), (Object)NO_WRAPPERS);
                    Runnable handleRequest = AbstractDecoratingHttpHandler.this.handlerWithWrappers(channel, isKeepAlive, contentType, req, extra, wrappers, txMode);
                    With.tag((String)AbstractDecoratingHttpHandler.CTX_TAG_HANDLER).exchange((Object)req).username(this.username).roles(this.roles).scope(this.scope).run(handleRequest);
                }
                catch (Throwable e) {
                    AbstractDecoratingHttpHandler.this.execErrorHandler(req, this.username, this.roles, this.scope, e);
                }
            }
        });
    }

    private HttpStatus execErrorHandler(final Req req, String username, Set<String> roles, Set<String> scope, final Throwable error) {
        With.tag((String)CTX_TAG_ERROR).exchange((Object)req).username(username).roles(roles).scope(scope).run(new Runnable(){

            @Override
            public void run() {
                AbstractDecoratingHttpHandler.this.handleError(req, error);
            }
        });
        return HttpStatus.ASYNC;
    }

    private Runnable handlerWithWrappers(final Channel channel, final boolean isKeepAlive, final MediaType contentType, final Req req, final Object extra, final HttpWrapper[] wrappers, final TransactionMode txMode) {
        return new Runnable(){

            @Override
            public void run() {
                Object result;
                try {
                    result = !U.isEmpty((Object[])wrappers) ? AbstractDecoratingHttpHandler.this.wrap(channel, isKeepAlive, req, 0, extra, wrappers) : AbstractDecoratingHttpHandler.this.handleReqMaybeInTx(channel, isKeepAlive, req, extra, txMode);
                    result = HttpUtils.postprocessResult(req, result);
                }
                catch (Throwable e) {
                    result = e;
                }
                AbstractDecoratingHttpHandler.this.complete(channel, isKeepAlive, contentType, req, result);
            }
        };
    }

    private Object handleReqMaybeInTx(final Channel channel, final boolean isKeepAlive, final Req req, final Object extra, TransactionMode txMode) throws Exception {
        if (txMode != null && txMode != TransactionMode.NONE) {
            final AtomicReference result = new AtomicReference();
            JPA.transaction((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        result.set(AbstractDecoratingHttpHandler.this.handleReqAndPostProcess(channel, isKeepAlive, req, extra));
                    }
                    catch (Exception e) {
                        throw U.rte((String)"Error occured inside the transactional web handler!", (Throwable)e);
                    }
                }
            }, (txMode == TransactionMode.READ_ONLY ? 1 : 0) != 0);
            return result.get();
        }
        return this.handleReqAndPostProcess(channel, isKeepAlive, req, extra);
    }

    private Runnable txWrap(final TransactionMode txMode, final Runnable handleRequest) {
        if (txMode != null && txMode != TransactionMode.NONE) {
            return new Runnable(){

                @Override
                public void run() {
                    JPA.transaction((Runnable)handleRequest, (txMode == TransactionMode.READ_ONLY ? 1 : 0) != 0);
                }
            };
        }
        return handleRequest;
    }

    private Object wrap(final Channel channel, final boolean isKeepAlive, final Req req, final int index, final Object extra, final HttpWrapper[] wrappers) throws Exception {
        HttpWrapper wrapper = wrappers[index];
        HandlerInvocation invocation = new HandlerInvocation(){

            @Override
            public Object invoke() throws Exception {
                return this.invokeAndTransformResult(null);
            }

            @Override
            public Object invokeAndTransformResult(Mapper<Object, Object> transformation) throws Exception {
                try {
                    int next = index + 1;
                    Object val = next < wrappers.length ? AbstractDecoratingHttpHandler.this.wrap(channel, isKeepAlive, req, next, extra, wrappers) : AbstractDecoratingHttpHandler.this.handleReqAndPostProcess(channel, isKeepAlive, req, extra);
                    return transformation != null ? transformation.map(val) : val;
                }
                catch (Throwable e) {
                    return e;
                }
            }
        };
        return wrapper.wrap(req, invocation);
    }

    private Object handleError(Req req, Throwable e) {
        req.revert();
        req.async();
        HttpIO.INSTANCE.error(req, e, LogLevel.ERROR);
        req.done();
        return req;
    }

    protected abstract Object handleReq(Channel var1, boolean var2, Req var3, Object var4) throws Exception;

    private Object handleReqAndPostProcess(Channel ctx, boolean isKeepAlive, Req req, Object extra) throws Exception {
        Object result = this.handleReq(ctx, isKeepAlive, req, extra);
        if (result instanceof Results) {
            result = ((Results)result).all();
        }
        return result;
    }

    public void complete(Channel ctx, boolean isKeepAlive, MediaType contentType, Req req, Object result) {
        if (result == null || result instanceof NotFound) {
            this.http.notFound(ctx, isKeepAlive, contentType, this, req);
            return;
        }
        if (result instanceof HttpStatus) {
            this.complete(ctx, isKeepAlive, contentType, req, U.rte((String)"HttpStatus result is not supported!"));
            return;
        }
        if (result instanceof Throwable) {
            this.handleError(req, (Throwable)result);
            return;
        }
        HttpUtils.resultToResponse(req, result);
        if (!req.isAsync()) {
            req.done();
        }
    }
}

