/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.handler;

import java.util.Map;
import org.rapidoid.RapidoidThing;
import org.rapidoid.http.HttpWrapper;
import org.rapidoid.http.MediaType;
import org.rapidoid.http.Route;
import org.rapidoid.http.handler.HttpHandler;
import org.rapidoid.http.impl.RouteOptions;
import org.rapidoid.u.U;

public abstract class AbstractHttpHandler
extends RapidoidThing
implements HttpHandler {
    protected final RouteOptions options;
    protected final MediaType contentType;
    protected final HttpWrapper[] httpWrappers;
    protected volatile Route route;

    public AbstractHttpHandler(RouteOptions options) {
        this.options = options;
        this.contentType = options.contentType();
        this.httpWrappers = options.wrappers();
    }

    @Override
    public boolean needsParams() {
        return false;
    }

    @Override
    public MediaType contentType() {
        return this.contentType;
    }

    @Override
    public Map<String, String> getParams() {
        return null;
    }

    @Override
    public HttpHandler getHandler() {
        return this;
    }

    @Override
    public RouteOptions options() {
        return this.options;
    }

    protected String contentTypeInfo(String inside) {
        String type;
        if (this.contentType == MediaType.HTML_UTF_8) {
            type = this.options.mvc() ? "mvc" : "html";
        } else if (this.contentType == MediaType.JSON) {
            type = "json";
        } else if (this.contentType == MediaType.PLAIN_TEXT_UTF_8) {
            type = "plain";
        } else if (this.contentType == MediaType.BINARY) {
            type = "binary";
        } else {
            return inside;
        }
        return U.frmt((String)"%s(%s)", (Object[])new Object[]{type, inside});
    }

    @Override
    public void setRoute(Route route) {
        this.route = route;
    }

    @Override
    public Route getRoute() {
        return this.route;
    }
}

