/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.impl;

import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.rapidoid.RapidoidThing;
import org.rapidoid.buffer.Buf;
import org.rapidoid.buffer.BufUtil;
import org.rapidoid.cache.Cache;
import org.rapidoid.cls.Cls;
import org.rapidoid.collection.ChangeTrackingMap;
import org.rapidoid.collection.Coll;
import org.rapidoid.commons.Str;
import org.rapidoid.http.FastHttp;
import org.rapidoid.http.HttpHeaders;
import org.rapidoid.http.HttpMetadata;
import org.rapidoid.http.HttpRoutes;
import org.rapidoid.http.HttpUtils;
import org.rapidoid.http.MediaType;
import org.rapidoid.http.Req;
import org.rapidoid.http.Resp;
import org.rapidoid.http.Route;
import org.rapidoid.http.SimpleHttpResp;
import org.rapidoid.http.customize.BeanParameterFactory;
import org.rapidoid.http.customize.Customization;
import org.rapidoid.http.customize.JsonRequestBodyParser;
import org.rapidoid.http.customize.SessionManager;
import org.rapidoid.http.impl.CachedResp;
import org.rapidoid.http.impl.HTTPCacheKey;
import org.rapidoid.http.impl.HttpRoutesImpl;
import org.rapidoid.http.impl.MaybeReq;
import org.rapidoid.http.impl.RespImpl;
import org.rapidoid.http.impl.TokenStatus;
import org.rapidoid.http.impl.lowlevel.HttpIO;
import org.rapidoid.io.Upload;
import org.rapidoid.log.Log;
import org.rapidoid.log.LogLevel;
import org.rapidoid.net.abstracts.Channel;
import org.rapidoid.net.abstracts.IRequest;
import org.rapidoid.u.U;
import org.rapidoid.util.Constants;
import org.rapidoid.util.Msc;

public class ReqImpl
extends RapidoidThing
implements Req,
Constants,
HttpMetadata,
IRequest,
MaybeReq {
    public static final long UNDEFINED = Long.MAX_VALUE;
    private final FastHttp http;
    private final Channel channel;
    private volatile boolean stopped = false;
    private volatile boolean isKeepAlive;
    private volatile String verb;
    private volatile String uri;
    private volatile String path;
    private volatile String query;
    private volatile String zone;
    private volatile String contextPath;
    private volatile byte[] body;
    private final Map<String, String> params;
    private final Map<String, String> headers;
    private final Map<String, String> cookies;
    private final Map<String, Object> posted;
    private final Map<String, List<Upload>> files;
    private final Map<String, Object> attrs = Collections.synchronizedMap(new HashMap());
    private volatile Map<String, Object> data;
    private volatile ChangeTrackingMap<String, Serializable> token;
    final AtomicBoolean tokenChanged = new AtomicBoolean();
    private volatile TokenStatus tokenStatus = TokenStatus.PENDING;
    private volatile ChangeTrackingMap<String, Serializable> session;
    private final AtomicBoolean sessionChanged = new AtomicBoolean();
    private volatile RespImpl response;
    private volatile boolean rendering;
    private volatile long posContentLengthValue;
    private volatile long posBeforeBody = Long.MAX_VALUE;
    private volatile boolean async;
    private volatile boolean done;
    private volatile boolean completed;
    private volatile boolean pendingBodyParsing;
    private final MediaType defaultContentType;
    private final HttpRoutesImpl routes;
    private final Route route;
    private final Customization custom;
    private final HTTPCacheKey cacheKey;
    private volatile boolean cached;
    private final long connId;
    private final long handle;
    private final long requestId;

    public ReqImpl(FastHttp http, Channel channel, boolean isKeepAlive, String verb, String uri, String path, String query, byte[] body, Map<String, String> params, Map<String, String> headers, Map<String, String> cookies, Map<String, Object> posted, Map<String, List<Upload>> files, boolean pendingBodyParsing, MediaType defaultContentType, String zone, Route route) {
        this.http = http;
        this.channel = channel;
        this.isKeepAlive = isKeepAlive;
        this.verb = verb;
        this.uri = uri;
        this.path = path;
        this.query = query;
        this.body = body;
        this.params = params;
        this.headers = headers;
        this.cookies = cookies;
        this.posted = posted;
        this.files = files;
        this.pendingBodyParsing = pendingBodyParsing;
        this.defaultContentType = defaultContentType;
        this.zone = zone;
        this.routes = http.routes();
        this.route = route;
        this.connId = channel.connId();
        this.handle = channel.handle();
        this.requestId = channel.requestId();
        this.custom = http.custom();
        this.cacheKey = this.createCacheKey();
    }

    private HTTPCacheKey createCacheKey() {
        return this.isCacheable() ? new HTTPCacheKey(this.host(), this.uri()) : null;
    }

    @Override
    public String verb() {
        return this.verb;
    }

    public Req verb(String verb) {
        this.verb = verb;
        return this;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    public Req uri(String uri) {
        this.uri = uri;
        return this;
    }

    @Override
    public String path() {
        return this.path;
    }

    public Req path(String path) {
        this.path = path;
        return this;
    }

    @Override
    public String query() {
        return this.query;
    }

    public Req query(String query) {
        this.query = query;
        return this;
    }

    @Override
    public byte[] body() {
        return this.body;
    }

    public Req body(byte[] body) {
        this.body = body;
        return this;
    }

    @Override
    public Map<String, String> params() {
        return this.params;
    }

    @Override
    public Map<String, String> headers() {
        return this.headers;
    }

    @Override
    public Map<String, String> cookies() {
        return this.cookies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> posted() {
        if (this.pendingBodyParsing) {
            ReqImpl reqImpl = this;
            synchronized (reqImpl) {
                if (this.pendingBodyParsing) {
                    this.pendingBodyParsing = false;
                    this.parseJsonBody();
                }
            }
        }
        return this.posted;
    }

    @Override
    public Map<String, List<Upload>> files() {
        return this.files;
    }

    @Override
    public String clientIpAddress() {
        return this.channel.address();
    }

    @Override
    public String realIpAddress() {
        return HttpUtils.inferRealIpAddress(this);
    }

    @Override
    public String host() {
        return this.header(HttpHeaders.HOST.name(), null);
    }

    public Req host(String host) {
        this.headers().put(HttpHeaders.HOST.name(), host);
        return this;
    }

    @Override
    public long connectionId() {
        return this.connId;
    }

    @Override
    public long requestId() {
        return this.requestId;
    }

    @Override
    public String param(String name) {
        return (String)U.notNull((Object)this.params().get(name), (String)"PARAMS[%s]", (Object[])new Object[]{name});
    }

    @Override
    public String param(String name, String defaultValue) {
        return this.withDefault(this.params().get(name), defaultValue);
    }

    @Override
    public <T> T param(Class<T> beanType) {
        return this.beanFrom(beanType, this.params());
    }

    @Override
    public String header(String name) {
        return (String)U.notNull((Object)this.headers().get(name.toLowerCase()), (String)"HEADERS[%s]", (Object[])new Object[]{name});
    }

    @Override
    public String header(String name, String defaultValue) {
        return (String)U.or((Object)this.headers().get(name.toLowerCase()), (Object)defaultValue);
    }

    @Override
    public String cookie(String name) {
        return (String)U.notNull((Object)this.cookies().get(name), (String)"COOKIES[%s]", (Object[])new Object[]{name});
    }

    @Override
    public String cookie(String name, String defaultValue) {
        return (String)U.or((Object)this.cookies().get(name), (Object)defaultValue);
    }

    @Override
    public <T extends Serializable> T posted(String name) {
        return (T)((Serializable)U.notNull((Object)this.posted().get(name), (String)"POSTED[%s]", (Object[])new Object[]{name}));
    }

    @Override
    public <T extends Serializable> T posted(String name, T defaultValue) {
        return this.withDefault(this.posted().get(name), defaultValue);
    }

    @Override
    public <T> T posted(Class<T> beanType) {
        return this.beanFrom(beanType, this.posted());
    }

    @Override
    public List<Upload> files(String name) {
        return (List)U.notNull(this.files().get(name), (String)"FILES[%s]", (Object[])new Object[]{name});
    }

    @Override
    public Upload file(String name) {
        List<Upload> uploads = this.files(name);
        U.must((uploads.size() == 1 ? 1 : 0) != 0, (String)"Expected exactly 1 uploaded file for parameter '%s', but found %s!", (Object)name, (Object)uploads.size());
        return uploads.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> data() {
        if (this.data == null) {
            ReqImpl reqImpl = this;
            synchronized (reqImpl) {
                if (this.data == null) {
                    Map allData = U.map();
                    allData.putAll(this.params);
                    allData.putAll(this.files);
                    allData.putAll(this.posted());
                    this.data = Collections.unmodifiableMap(allData);
                }
            }
        }
        return this.data;
    }

    @Override
    public <T> T data(String name) {
        return (T)U.notNull(this.data(name, null), (String)"DATA[%s]", (Object[])new Object[]{name});
    }

    @Override
    public <T> T data(String name, T defaultValue) {
        List<Upload> value = this.posted(name, null);
        if (value == null && (value = this.files().get(name)) == null) {
            value = this.param(name, null);
        }
        return this.withDefault(value, defaultValue);
    }

    @Override
    public <T> T data(Class<T> beanType) {
        return this.beanFrom(beanType, this.data());
    }

    private <T> T beanFrom(Class<T> beanType, Map<String, ?> properties) {
        String paramName = Str.uncapitalized((String)beanType.getSimpleName());
        BeanParameterFactory beanParameterFactory = this.custom().beanParameterFactory();
        try {
            return (T)beanParameterFactory.getParamValue(this, beanType, paramName, properties);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't instantiate a bean of type: " + beanType.getName());
        }
    }

    @Override
    public Map<String, Object> attrs() {
        return this.attrs;
    }

    @Override
    public <T> T attr(String name) {
        return (T)U.notNull((Object)this.attrs().get(name), (String)"ATTRS[%s]", (Object[])new Object[]{name});
    }

    @Override
    public <T> T attr(String name, T defaultValue) {
        return this.withDefault(this.attrs().get(name), defaultValue);
    }

    private <T> T withDefault(Object value, T defaultValue) {
        if (value != null) {
            return (T)(defaultValue != null ? Cls.convert((Object)value, (Class)Cls.of(defaultValue)) : value);
        }
        return defaultValue;
    }

    @Override
    public synchronized Resp response() {
        if (this.response == null) {
            this.response = new RespImpl(this);
            if (this.defaultContentType != null) {
                this.response.contentType(this.defaultContentType);
            }
        }
        return this.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRendering(int code, byte[] responseBody) {
        if (!this.isRendering()) {
            ReqImpl reqImpl = this;
            synchronized (reqImpl) {
                if (!this.isRendering()) {
                    this.respond(code, responseBody);
                }
            }
        }
    }

    private void respond(int code, byte[] responseBody) {
        MediaType contentType = HttpUtils.getDefaultContentType();
        if (this.tokenChanged.get()) {
            HttpUtils.saveTokenBeforeRenderingHeaders(this, this.token);
        }
        if (this.sessionChanged.get()) {
            this.saveSession((Map)this.session.decorated());
        }
        if (this.response != null) {
            contentType = (MediaType)U.or((Object)this.response.contentType(), (Object)contentType);
        }
        this.renderResponse(code, contentType, responseBody);
    }

    private void renderResponse(int code, MediaType contentType, byte[] responseBody) {
        this.rendering = true;
        this.completed = responseBody != null;
        HttpIO.INSTANCE.respond(HttpUtils.maybe(this), this.channel, this.connId, this.handle, code, this.isKeepAlive, contentType, responseBody, this.response != null ? this.response.headers() : null, this.response != null ? this.response.cookies() : null);
    }

    public void responded(long posContentLengthValue, long posBeforeBody, boolean completed) {
        this.posContentLengthValue = posContentLengthValue;
        this.posBeforeBody = posBeforeBody;
        this.completed = completed;
    }

    public void onHeadersCompleted() {
        this.posBeforeBody = this.channel.output().size();
    }

    private void writeResponseLength() {
        Buf out = this.channel.output();
        long posAfter = out.size();
        long contentLength = posAfter - this.posBeforeBody;
        if (!this.stopped && out.size() > 0) {
            BufUtil.startWriting((Buf)out);
            out.putNumAsText((int)this.posContentLengthValue, contentLength, false);
            BufUtil.doneWriting((Buf)out);
        }
        this.completed = true;
    }

    public boolean isRendering() {
        return this.rendering;
    }

    public ReqImpl completed(boolean completed) {
        this.completed = completed;
        return this;
    }

    @Override
    public synchronized Req done() {
        if (!this.done) {
            this.onDone();
            this.done = true;
        }
        return this;
    }

    private void onDone() {
        if (this.stopped) {
            return;
        }
        boolean willBeDone = true;
        if (!this.rendering) {
            this.renderResponseOrError();
            willBeDone = false;
        }
        if (!this.completed) {
            this.writeResponseLength();
            this.completed = true;
        }
        if (willBeDone) {
            HttpIO.INSTANCE.done(this);
        }
    }

    private void renderResponseOrError() {
        String err = this.validateResponse();
        if (err != null) {
            this.doRendering(500, err.getBytes());
        } else {
            this.renderResponse();
        }
    }

    private void renderResponse() {
        HttpUtils.postProcessResponse(this.response);
        if (this.response.raw() != null) {
            int posBeforeResponse = this.channel.output().size();
            byte[] bytes = Msc.toBytes((Object)this.response.raw());
            this.channel.write(bytes);
            if (this.willSaveToCache()) {
                this.posBeforeBody = posBeforeResponse + HttpUtils.findBodyStart(bytes);
            }
            this.completed = true;
            HttpIO.INSTANCE.done(this);
        } else {
            byte[] bytes = this.responseToBytes();
            this.doRendering(this.response.code(), bytes);
        }
    }

    private byte[] responseToBytes() {
        try {
            return this.response.renderToBytes();
        }
        catch (Throwable e) {
            HttpIO.INSTANCE.error(this, e, LogLevel.ERROR);
            try {
                return this.response.renderToBytes();
            }
            catch (Exception e1) {
                Log.error((String)"Internal rendering error!", (Throwable)e1);
                return HttpUtils.getErrorMessageAndSetCode(this.response, e1).getBytes();
            }
        }
    }

    private String validateResponse() {
        if (this.response == null) {
            return "Response wasn't provided!";
        }
        if (this.response.result() == null && this.response.body() == null && this.response.redirect() == null && this.response.file() == null && this.response.raw() == null && !this.response().mvc()) {
            return "Response content wasn't provided!";
        }
        if (this.response.contentType() == null && this.response.raw() == null) {
            return "Response content type wasn't provided!";
        }
        return null;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public HttpRoutes routes() {
        return this.routes;
    }

    @Override
    public Route route() {
        return this.route;
    }

    @Override
    public Customization custom() {
        return this.custom;
    }

    @Override
    public Req async() {
        this.async = true;
        if (this.channel.onSameThread()) {
            this.channel.async();
        }
        return this;
    }

    @Override
    public boolean isAsync() {
        return this.async;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String sessionId() {
        String sessionId = this.cookie("JSESSIONID", null);
        if (U.isEmpty((String)sessionId)) {
            sessionId = UUID.randomUUID().toString();
            Map<String, String> map = this.cookies;
            synchronized (map) {
                if (this.cookie("JSESSIONID", null) == null) {
                    this.cookies.put("JSESSIONID", sessionId);
                    this.response().cookie("JSESSIONID", sessionId, "HttpOnly");
                }
            }
        }
        return sessionId;
    }

    @Override
    public boolean hasSession() {
        return this.cookie("JSESSIONID", null) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Serializable> session() {
        if (this.session == null) {
            ReqImpl reqImpl = this;
            synchronized (reqImpl) {
                if (this.session == null) {
                    this.session = Coll.trackChanges(this.loadSession(), (AtomicBoolean)this.sessionChanged);
                }
            }
        }
        return this.session;
    }

    @Override
    public <T extends Serializable> T session(String name) {
        Serializable value = this.hasSession() ? this.session().get(name) : null;
        return (T)((Serializable)U.notNull((Object)value, (String)"SESSION[%s]", (Object[])new Object[]{name}));
    }

    @Override
    public <T extends Serializable> T session(String name, T defaultValue) {
        Serializable value = this.hasSession() ? this.session().get(name) : null;
        return this.withDefault(value, defaultValue);
    }

    @Override
    public boolean hasToken() {
        return U.notEmpty(this.token());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Serializable> token() {
        if (this.tokenStatus == TokenStatus.PENDING) {
            ReqImpl reqImpl = this;
            synchronized (reqImpl) {
                if (this.tokenStatus == TokenStatus.PENDING) {
                    Map<String, Serializable> tokenData = null;
                    try {
                        tokenData = HttpUtils.initAndDeserializeToken(this);
                        this.tokenStatus(tokenData != null ? TokenStatus.LOADED : TokenStatus.NONE);
                    }
                    catch (Exception e) {
                        Log.error((String)"Token deserialization error!", (Throwable)e);
                        this.tokenStatus(TokenStatus.INVALID);
                    }
                    this.token = Coll.trackChanges(Collections.synchronizedMap(U.safe(tokenData)), (AtomicBoolean)this.tokenChanged);
                }
            }
        }
        return this.token;
    }

    @Override
    public <T extends Serializable> T token(String name) {
        Serializable value = this.hasToken() ? this.token().get(name) : null;
        return (T)((Serializable)U.notNull((Object)value, (String)"TOKEN[%s]", (Object[])new Object[]{name}));
    }

    @Override
    public <T extends Serializable> T token(String name, T defaultValue) {
        Serializable value = this.hasToken() ? this.token().get(name) : null;
        return this.withDefault(value, defaultValue);
    }

    public TokenStatus tokenStatus() {
        return this.tokenStatus;
    }

    public Req tokenStatus(TokenStatus tokenStatus) {
        this.tokenStatus = tokenStatus;
        return this;
    }

    @Override
    public String zone() {
        return this.zone;
    }

    public Req zone(String zone) {
        this.zone = zone;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String contextPath() {
        if (this.contextPath == null) {
            ReqImpl reqImpl = this;
            synchronized (reqImpl) {
                if (this.contextPath == null) {
                    this.contextPath = HttpUtils.getContextPath(this);
                }
            }
        }
        return this.contextPath;
    }

    public Req contextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    public String toString() {
        String info = this.verb() + " " + this.path();
        if (U.notEmpty(this.params)) {
            info = info + "?" + U.join((String)"&", Msc.protectSensitiveInfo(this.params, (Object)"<...>").entrySet());
        }
        return info;
    }

    public Channel channel() {
        return this.channel;
    }

    public FastHttp http() {
        return this.http;
    }

    public void stop() {
        this.stopped = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public void revert() {
        this.rendering = false;
        this.posContentLengthValue = 0L;
        this.posBeforeBody = 0L;
        this.async = false;
        this.done = false;
        this.completed = false;
        this.response = null;
    }

    private void parseJsonBody() {
        if (U.notEmpty((Object)this.body())) {
            Map<String, ?> jsonData = null;
            JsonRequestBodyParser parser = this.custom().jsonRequestBodyParser();
            try {
                jsonData = parser.parseJsonBody(this, this.body);
            }
            catch (Exception e) {
                Log.error((String)"The attempt to parse the request body as JSON failed. Please make sure the correct content type is specified in the request header!", (Throwable)e);
            }
            if (jsonData != null) {
                this.posted.putAll(jsonData);
            }
        }
    }

    public Map<String, Serializable> loadSession() {
        SessionManager sessionManager = (SessionManager)U.notNull((Object)this.custom().sessionManager(), (String)"session manager", (Object[])new Object[0]);
        try {
            return sessionManager.loadSession(this, this.sessionId());
        }
        catch (Exception e) {
            throw U.rte((String)"Error occured while loading the session!", (Throwable)e);
        }
    }

    public void saveSession(Map<String, Serializable> session) {
        SessionManager sessionManager = (SessionManager)U.notNull((Object)this.custom().sessionManager(), (String)"session manager", (Object[])new Object[0]);
        try {
            sessionManager.saveSession(this, this.sessionId(), session);
        }
        catch (Exception e) {
            throw U.rte((String)"Error occured while saving the session!", (Throwable)e);
        }
    }

    @Override
    public OutputStream out() {
        if (this.response != null) {
            return this.response.out();
        }
        return this.startOutputStream(200);
    }

    public OutputStream startOutputStream(int respCode) {
        this.doRendering(respCode, null);
        BufUtil.startWriting((Buf)this.channel().output());
        return this.channel().outputStream();
    }

    @Override
    public MediaType contentType() {
        MediaType contentType = this.response != null ? this.response.contentType() : null;
        return (MediaType)U.or((Object)contentType, (Object)this.defaultContentType);
    }

    @Override
    public long handle() {
        return this.handle;
    }

    public boolean isKeepAlive() {
        return this.isKeepAlive;
    }

    public void doneProcessing() {
        this.done = true;
        if (this.willSaveToCache()) {
            this.saveToCache();
        }
    }

    private void saveToCache() {
        U.must((this.posBeforeBody != Long.MAX_VALUE ? 1 : 0) != 0);
        Buf out = this.channel.output();
        int posAfterBody = out.size();
        int bodyLength = (int)((long)posAfterBody - this.posBeforeBody);
        Cache<HTTPCacheKey, CachedResp> cache = this.route.cache();
        U.notNull(cache, (String)"route.cache", (Object[])new Object[0]);
        SimpleHttpResp proxyResp = new SimpleHttpResp();
        proxyResp.cookies = U.map((Map)U.safe(this.response != null ? this.response.cookies() : null));
        Map<String, String> headers = this.response != null ? this.response.headers() : Collections.emptyMap();
        HttpUtils.proxyResponseHeaders(headers, proxyResp);
        int n = proxyResp.code = this.response != null ? this.response.code() : 200;
        if (proxyResp.contentType == null) {
            MediaType mediaType = proxyResp.contentType = this.response != null ? this.response.contentType() : this.defaultContentType;
        }
        if (U.notEmpty(proxyResp.cookies) || this.hasToken()) {
            return;
        }
        ByteBuffer body = this.writeBodyToBuf(out, bodyLength);
        CachedResp cached = new CachedResp(proxyResp.code, proxyResp.contentType, proxyResp.headers, body);
        cache.set((Object)this.cacheKey, (Object)cached);
    }

    private ByteBuffer writeBodyToBuf(Buf out, int bodyLength) {
        ByteBuffer body = ByteBuffer.allocateDirect(bodyLength);
        out.writeTo(body, (int)this.posBeforeBody, bodyLength);
        body.flip();
        return body;
    }

    @Override
    public Req getReqOrNull() {
        return this;
    }

    private boolean willSaveToCache() {
        return this.cacheKey != null && !this.cached;
    }

    public HTTPCacheKey cacheKey() {
        return this.cacheKey;
    }

    public boolean cached() {
        return this.cached;
    }

    public ReqImpl cached(boolean cached) {
        this.cached = cached;
        return this;
    }

    private boolean isCacheable() {
        return this.route != null && HttpUtils.isGetReq(this) && this.route.cache() != null && this.cookies.isEmpty() && U.notEmpty((String)this.host()) && !this.hasToken();
    }
}

