/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.impl;

import java.util.Arrays;
import java.util.Set;
import org.rapidoid.RapidoidThing;
import org.rapidoid.annotation.TransactionMode;
import org.rapidoid.collection.Coll;
import org.rapidoid.http.HttpUtils;
import org.rapidoid.http.HttpWrapper;
import org.rapidoid.http.MediaType;
import org.rapidoid.http.RouteConfig;
import org.rapidoid.u.U;

public class RouteOptions
extends RapidoidThing
implements RouteConfig {
    private volatile MediaType contentType = HttpUtils.getDefaultContentType();
    private volatile boolean contentTypeCustomized;
    private volatile String view;
    private volatile boolean mvc;
    private volatile String zone;
    private volatile boolean managed = true;
    private volatile TransactionMode transaction = TransactionMode.NONE;
    private final Set<String> roles = Coll.synchronizedSet((Object[])new String[0]);
    private volatile HttpWrapper[] wrappers;
    private volatile long cacheTTL;
    private volatile int cacheCapacity = 100;

    public String toString() {
        return "RouteOptions{contentType=" + this.contentType + ", contentTypeCustomized=" + this.contentTypeCustomized + ", view='" + this.view + '\'' + ", mvc=" + this.mvc + ", zone='" + this.zone + '\'' + ", managed=" + this.managed + ", transaction=" + this.transaction + ", roles=" + this.roles + ", wrappers=" + Arrays.toString(this.wrappers) + ", cacheTTL=" + this.cacheTTL + ", cacheCapacity=" + this.cacheCapacity + '}';
    }

    @Override
    public MediaType contentType() {
        return this.contentType;
    }

    @Override
    public RouteOptions contentType(MediaType contentType) {
        this.contentType = contentType;
        this.contentTypeCustomized = true;
        return this;
    }

    @Override
    public String view() {
        return this.view;
    }

    @Override
    public RouteOptions view(String view) {
        HttpUtils.validateViewName(view);
        this.view = view;
        return this;
    }

    @Override
    public boolean mvc() {
        return this.mvc;
    }

    @Override
    public RouteOptions mvc(boolean mvc) {
        this.mvc = mvc;
        return this;
    }

    @Override
    public TransactionMode transaction() {
        return this.transaction;
    }

    @Override
    public RouteOptions transaction(TransactionMode transaction) {
        this.transaction = transaction;
        return this;
    }

    @Override
    public Set<String> roles() {
        return this.roles;
    }

    @Override
    public RouteOptions roles(String ... roles) {
        Coll.assign(this.roles, (Object[])roles);
        return this;
    }

    @Override
    public HttpWrapper[] wrappers() {
        return this.wrappers;
    }

    @Override
    public RouteOptions wrappers(HttpWrapper ... wrappers) {
        this.wrappers = wrappers;
        return this;
    }

    @Override
    public String zone() {
        return this.zone;
    }

    @Override
    public RouteOptions zone(String zone) {
        this.zone = zone;
        return this;
    }

    @Override
    public boolean managed() {
        return this.managed;
    }

    @Override
    public RouteOptions managed(boolean managed) {
        this.managed = managed;
        return this;
    }

    @Override
    public long cacheTTL() {
        return this.cacheTTL;
    }

    @Override
    public RouteOptions cacheTTL(long cacheTTL) {
        this.cacheTTL = cacheTTL;
        return this;
    }

    @Override
    public int cacheCapacity() {
        return this.cacheCapacity;
    }

    @Override
    public RouteOptions cacheCapacity(int cacheCapacity) {
        this.cacheCapacity = cacheCapacity;
        return this;
    }

    public RouteOptions copy() {
        RouteOptions copy = new RouteOptions();
        copy.contentType = this.contentType;
        copy.view = this.view;
        copy.mvc = this.mvc;
        copy.transaction = this.transaction;
        Coll.assign(copy.roles, this.roles);
        copy.wrappers = (HttpWrapper[])U.array((Object[])this.wrappers);
        copy.zone = this.zone;
        copy.managed = this.managed;
        copy.cacheTTL = this.cacheTTL;
        copy.cacheCapacity = this.cacheCapacity;
        return copy;
    }

    public boolean contentTypeCustomized() {
        return this.contentTypeCustomized;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouteOptions that = (RouteOptions)o;
        if (this.mvc != that.mvc) {
            return false;
        }
        if (this.managed != that.managed) {
            return false;
        }
        if (this.cacheTTL != that.cacheTTL) {
            return false;
        }
        if (this.cacheCapacity != that.cacheCapacity) {
            return false;
        }
        if (this.contentType != null ? !this.contentType.equals((Object)that.contentType) : that.contentType != null) {
            return false;
        }
        if (this.view != null ? !this.view.equals(that.view) : that.view != null) {
            return false;
        }
        if (this.zone != null ? !this.zone.equals(that.zone) : that.zone != null) {
            return false;
        }
        if (this.transaction != that.transaction) {
            return false;
        }
        if (this.roles != null ? !this.roles.equals(that.roles) : that.roles != null) {
            return false;
        }
        return Arrays.equals(this.wrappers, that.wrappers);
    }

    public int hashCode() {
        int result = this.contentType != null ? this.contentType.hashCode() : 0;
        result = 31 * result + (this.view != null ? this.view.hashCode() : 0);
        result = 31 * result + (this.mvc ? 1 : 0);
        result = 31 * result + (this.zone != null ? this.zone.hashCode() : 0);
        result = 31 * result + (this.managed ? 1 : 0);
        result = 31 * result + (this.transaction != null ? this.transaction.hashCode() : 0);
        result = 31 * result + (this.roles != null ? this.roles.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.wrappers);
        result = 31 * result + (int)(this.cacheTTL ^ this.cacheTTL >>> 32);
        result = 31 * result + (this.cacheCapacity ^ this.cacheCapacity >>> 32);
        return result;
    }
}

