/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.impl.lowlevel;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.rapidoid.RapidoidThing;
import org.rapidoid.activity.RapidoidThreadLocals;
import org.rapidoid.buffer.Buf;
import org.rapidoid.cls.Cls;
import org.rapidoid.commons.Dates;
import org.rapidoid.config.Conf;
import org.rapidoid.config.Config;
import org.rapidoid.ctx.Ctx;
import org.rapidoid.ctx.Ctxs;
import org.rapidoid.ctx.With;
import org.rapidoid.data.BufRange;
import org.rapidoid.data.JSON;
import org.rapidoid.http.HttpHeaders;
import org.rapidoid.http.HttpResponseCodes;
import org.rapidoid.http.HttpStatus;
import org.rapidoid.http.HttpUtils;
import org.rapidoid.http.MediaType;
import org.rapidoid.http.NotFound;
import org.rapidoid.http.Req;
import org.rapidoid.http.Resp;
import org.rapidoid.http.customize.Customization;
import org.rapidoid.http.impl.MaybeReq;
import org.rapidoid.http.impl.ReqImpl;
import org.rapidoid.job.Jobs;
import org.rapidoid.log.GlobalCfg;
import org.rapidoid.log.Log;
import org.rapidoid.log.LogLevel;
import org.rapidoid.net.AsyncLogic;
import org.rapidoid.net.abstracts.Channel;
import org.rapidoid.u.U;
import org.rapidoid.util.Constants;
import org.rapidoid.util.Msc;
import org.rapidoid.writable.ReusableWritable;
import org.rapidoid.writable.Writable;
import org.rapidoid.writable.WritableUtils;

class LowLevelHttpIO
extends RapidoidThing {
    private static final byte[] HTTP_200_OK = "HTTP/1.1 200 OK\r\n".getBytes();
    private static final byte[] HTTP_400_BAD_REQUEST = "HTTP/1.1 400 Bad Request\r\nContent-Length: 12\r\n\r\nBad Request!".getBytes();
    private static final byte[] HEADER_SEP = ": ".getBytes();
    private static final byte[] CONN_KEEP_ALIVE = "Connection: keep-alive\r\n".getBytes();
    private static final byte[] CONN_CLOSE = "Connection: close\r\n".getBytes();
    private static final byte[] SERVER_HEADER;
    private static final byte[] CONTENT_LENGTH_IS;
    private static final byte[] CONTENT_LENGTH_UNKNOWN;
    private static final int CONTENT_LENGTHS_SIZE = 5000;
    private static final byte[] DATE_IS;
    private static final byte[][] CONTENT_LENGTHS;
    private static final boolean MANDATORY_HEADER_CONNECTION;
    private static final boolean MANDATORY_HEADER_DATE;
    private static final boolean MANDATORY_HEADER_SERVER;
    private static final boolean MANDATORY_HEADER_CONTENT_TYPE;
    private static final byte[] UNIFORM_DATE;
    private static final AtomicLong ASYNC_ID_GEN;

    LowLevelHttpIO() {
    }

    void removeTrailingSlash(Buf buf, BufRange range) {
        if (range.length > 1 && buf.get(range.last()) == 47) {
            --range.length;
        }
    }

    void startResponse(Channel ctx, int code, boolean isKeepAlive, MediaType contentType) {
        ctx.write(code == 200 ? HTTP_200_OK : HttpResponseCodes.get(code));
        this.addDefaultHeaders(ctx, isKeepAlive, contentType);
    }

    private void addDefaultHeaders(Channel ctx, boolean isKeepAlive, MediaType contentType) {
        if (!isKeepAlive || MANDATORY_HEADER_CONNECTION) {
            ctx.write(isKeepAlive ? CONN_KEEP_ALIVE : CONN_CLOSE);
        }
        if (MANDATORY_HEADER_SERVER) {
            ctx.write(SERVER_HEADER);
        }
        if (MANDATORY_HEADER_DATE) {
            ctx.write(DATE_IS);
            if (!GlobalCfg.uniformOutput()) {
                ctx.write(Dates.getDateTimeBytes());
            } else {
                ctx.write(UNIFORM_DATE);
            }
            ctx.write(Constants.CR_LF);
        }
        if (MANDATORY_HEADER_CONTENT_TYPE) {
            ctx.write(contentType.asHttpHeader());
        }
    }

    void addCustomHeader(Channel ctx, byte[] name, byte[] value) {
        ctx.write(name);
        ctx.write(HEADER_SEP);
        ctx.write(value);
        ctx.write(Constants.CR_LF);
    }

    void writeResponse(MaybeReq req, Channel ctx, boolean isKeepAlive, int code, MediaType contentTypeHeader, byte[] content) {
        this.startResponse(ctx, code, isKeepAlive, contentTypeHeader);
        this.writeContentLengthAndBody(req, ctx, content);
    }

    void write200(MaybeReq req, Channel ctx, boolean isKeepAlive, MediaType contentTypeHeader, byte[] content) {
        this.writeResponse(req, ctx, isKeepAlive, 200, contentTypeHeader, content);
    }

    void error(Req req, Throwable error, LogLevel logLevel) {
        try {
            this.logError(req, error, logLevel);
            Resp resp = req.response().code(500).result(null);
            Object result = Customization.of(req).errorHandler().handleError(req, resp, error);
            result = HttpUtils.postprocessResult(req, result);
            HttpUtils.resultToResponse(req, result);
        }
        catch (Exception e) {
            Log.error((String)"An error occurred inside the error handler!", (Throwable)e);
            HttpUtils.resultToResponse(req, HttpUtils.getErrorInfo(req.response(), e));
        }
    }

    private void logError(Req req, Throwable error, LogLevel logLevel) {
        if (error instanceof NotFound) {
            return;
        }
        if (Msc.isValidationError((Throwable)error)) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Validation error when handling request: " + req));
                error.printStackTrace();
            }
            return;
        }
        if (error instanceof SecurityException) {
            Log.warn((String)("Access denied for request: " + req), (String)"client", (Object)req.clientIpAddress());
            return;
        }
        Log.log(null, (LogLevel)logLevel, (String)"Error occurred when handling request!", (String)"error", (Object)error);
    }

    HttpStatus errorAndDone(final Req req, final Throwable error, final LogLevel logLevel) {
        req.revert();
        req.async();
        Runnable errorHandler = new Runnable(){

            @Override
            public void run() {
                LowLevelHttpIO.this.error(req, error, logLevel);
                req.done();
            }
        };
        Ctx ctx = Ctxs.get();
        if (ctx == null) {
            With.exchange((Object)req).run(errorHandler);
        } else {
            Jobs.execute((Runnable)errorHandler);
        }
        return HttpStatus.ASYNC;
    }

    void writeContentLengthAndBody(MaybeReq req, Channel ctx, byte[] body) {
        this.writeContentLengthHeader(ctx, body.length);
        this.closeHeaders(req, ctx.output());
        ctx.write(body);
    }

    void writeContentLengthAndBody(MaybeReq req, Channel ctx, ByteArrayOutputStream body) {
        this.writeContentLengthHeader(ctx, body.size());
        this.closeHeaders(req, ctx.output());
        ctx.output().append(body);
    }

    void writeContentLengthHeader(Channel ctx, long contentLength) {
        if (contentLength < 5000L) {
            ctx.write(CONTENT_LENGTHS[(int)contentLength]);
        } else {
            ctx.write(CONTENT_LENGTH_IS);
            Buf out = ctx.output();
            out.putNumAsText(out.size(), contentLength, true);
            ctx.write(Constants.CR_LF);
        }
    }

    void writeAsJson(MaybeReq req, Channel ctx, int code, boolean isKeepAlive, Object value) {
        this.startResponse(ctx, code, isKeepAlive, MediaType.JSON);
        RapidoidThreadLocals locals = Msc.locals();
        ReusableWritable out = locals.jsonRenderingStream();
        JSON.stringify((Object)value, (OutputStream)out);
        this.writeContentLengthHeader(ctx, out.size());
        this.closeHeaders(req, ctx.output());
        ctx.write(out.array(), 0, out.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOnBufferAsJson(MaybeReq req, Channel ctx, int code, boolean isKeepAlive, Object value) {
        Buf output;
        this.startResponse(ctx, code, isKeepAlive, MediaType.JSON);
        Buf buf = output = ctx.output();
        synchronized (buf) {
            this.writeJsonBody(req, output.unwrap(), value);
        }
    }

    private void writeJsonBody(MaybeReq req, Buf out, Object value) {
        out.append(CONTENT_LENGTH_UNKNOWN);
        int posConLen = out.size() - 1;
        out.append(Constants.CR_LF);
        this.closeHeaders(req, out);
        int posBefore = out.size();
        JSON.stringify((Object)value, (OutputStream)out.asOutputStream());
        int posAfter = out.size();
        int contentLength = posAfter - posBefore;
        out.putNumAsText(posConLen, (long)contentLength, false);
    }

    void closeHeaders(MaybeReq req, Buf out) {
        out.append(Constants.CR_LF);
        ReqImpl reqq = (ReqImpl)req.getReqOrNull();
        if (reqq != null) {
            U.must((reqq.channel().output() == out ? 1 : 0) != 0);
            reqq.onHeadersCompleted();
        }
    }

    void writeContentLengthUnknown(Channel channel) {
        channel.write(CONTENT_LENGTH_UNKNOWN);
    }

    void done(Req req) {
        ReqImpl reqq = (ReqImpl)req;
        reqq.doneProcessing();
        Channel channel = reqq.channel();
        channel.send();
        channel.closeIf(!reqq.isKeepAlive());
    }

    void writeNum(Channel ctx, int value) {
        WritableUtils.putNumAsText((Writable)ctx.output(), (long)value);
    }

    void resume(MaybeReq maybeReq, Channel channel, AsyncLogic logic) {
        Req req = maybeReq.getReqOrNull();
        if (req != null) {
            channel.resume(req.connectionId(), req.handle(), logic);
        } else {
            logic.resumeAsync();
        }
    }

    void writeBadRequest(Channel channel) {
        channel.write(HTTP_400_BAD_REQUEST);
        channel.close();
    }

    void respond(final MaybeReq maybeReq, final Channel channel, long connId, long handle, final int code, final boolean isKeepAlive, final MediaType contentType, final Object body, final Map<String, String> headers, final Map<String, String> cookies) {
        final ReqImpl req = (ReqImpl)maybeReq.getReqOrNull();
        if (handle < 0L) {
            handle = req != null ? req.handle() : channel.handle();
        }
        if (connId < 0L) {
            connId = req != null ? req.connectionId() : channel.connId();
        }
        final long id = ASYNC_ID_GEN.incrementAndGet();
        channel.resume(connId, handle, new AsyncLogic(){

            public String toString() {
                String bb = body instanceof byte[] ? new String((byte[])body) : U.str((Object)body);
                return U.str((Object)U.join((String)":", (Object[])new Object[]{"#" + id, channel, code, bb, isKeepAlive, contentType}));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean resumeAsync() {
                LowLevelHttpIO.this.startResponse(channel, code, isKeepAlive, contentType);
                if (U.notEmpty((Map)headers)) {
                    for (Map.Entry e : headers.entrySet()) {
                        LowLevelHttpIO.this.addCustomHeader(channel, ((String)e.getKey()).getBytes(), ((String)e.getValue()).getBytes());
                    }
                }
                if (U.notEmpty((Map)cookies)) {
                    for (Map.Entry e : cookies.entrySet()) {
                        String cookie = (String)e.getKey() + "=" + (String)e.getValue();
                        LowLevelHttpIO.this.addCustomHeader(channel, HttpHeaders.SET_COOKIE.getBytes(), cookie.getBytes());
                    }
                }
                Buf output = channel.output();
                Channel channel2 = channel;
                synchronized (channel2) {
                    if (body == null) {
                        LowLevelHttpIO.this.writeContentLengthUnknown(channel);
                        int posContentLengthValue = output.size() - 1;
                        channel.write(Constants.CR_LF);
                        LowLevelHttpIO.this.closeHeaders(maybeReq, output);
                        long posBeforeBody = output.size();
                        if (req != null) {
                            req.responded(posContentLengthValue, posBeforeBody, false);
                        }
                    } else {
                        if (body instanceof byte[]) {
                            byte[] bytes = (byte[])body;
                            LowLevelHttpIO.this.writeContentLengthHeader(channel, bytes.length);
                            LowLevelHttpIO.this.closeHeaders(maybeReq, output);
                            channel.write(bytes);
                        } else if (body instanceof ByteBuffer) {
                            ByteBuffer buf = (ByteBuffer)body;
                            LowLevelHttpIO.this.writeContentLengthHeader(channel, buf.remaining());
                            LowLevelHttpIO.this.closeHeaders(maybeReq, output);
                            channel.write(buf);
                        } else {
                            throw U.rte((String)"Invalid response body type: %s", (Object[])new Object[]{Cls.of((Object)body)});
                        }
                        if (req != null) {
                            req.completed(true);
                            LowLevelHttpIO.this.done(req);
                        }
                    }
                }
                return true;
            }
        });
    }

    static {
        CONTENT_LENGTH_IS = "Content-Length: ".getBytes();
        CONTENT_LENGTH_UNKNOWN = "Content-Length: 0000000000".getBytes();
        DATE_IS = "Date: ".getBytes();
        CONTENT_LENGTHS = new byte[5000][];
        UNIFORM_DATE = "Sat, 10 Sep 2016 01:02:03 GMT".getBytes();
        ASYNC_ID_GEN = new AtomicLong();
        for (int len = 0; len < CONTENT_LENGTHS.length; ++len) {
            LowLevelHttpIO.CONTENT_LENGTHS[len] = (new String(CONTENT_LENGTH_IS) + len + new String(Constants.CR_LF)).getBytes();
        }
        HttpResponseCodes.init();
        String serverName = (String)Conf.HTTP.entry("serverName").or((Object)"Rapidoid");
        SERVER_HEADER = ("Server: " + serverName + "\r\n").getBytes();
        Config mandatoryHeaders = Conf.HTTP.sub(new String[]{"mandatoryHeaders"});
        MANDATORY_HEADER_CONNECTION = (Boolean)mandatoryHeaders.entry("connection").or((Object)true);
        MANDATORY_HEADER_DATE = (Boolean)mandatoryHeaders.entry("date").or((Object)true);
        MANDATORY_HEADER_SERVER = (Boolean)mandatoryHeaders.entry("server").or((Object)true);
        MANDATORY_HEADER_CONTENT_TYPE = (Boolean)mandatoryHeaders.entry("contentType").or((Object)true);
    }
}

