/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.net;

import org.rapidoid.RapidoidThing;
import org.rapidoid.config.Conf;
import org.rapidoid.net.Protocol;
import org.rapidoid.net.Server;
import org.rapidoid.net.impl.DefaultExchange;
import org.rapidoid.net.impl.RapidoidHelper;
import org.rapidoid.net.impl.RapidoidServerLoop;

public class ServerBuilder
extends RapidoidThing {
    private volatile String address = (String)Conf.NET.entry("address").or((Object)"0.0.0.0");
    private volatile int port = (Integer)Conf.NET.entry("port").or((Object)8080);
    private volatile int workers = (Integer)Conf.NET.entry("workers").or((Object)Runtime.getRuntime().availableProcessors());
    private volatile int bufSizeKB = (Integer)Conf.NET.entry("bufSizeKB").or((Object)16);
    private volatile boolean noDelay = (Boolean)Conf.NET.entry("noDelay").or((Object)false);
    private volatile boolean syncBufs = (Boolean)Conf.NET.entry("syncBufs").or((Object)true);
    private volatile Protocol protocol = null;
    private volatile Class<? extends DefaultExchange<?>> exchangeClass = null;
    private volatile Class<? extends RapidoidHelper> helperClass = RapidoidHelper.class;

    public ServerBuilder address(String address) {
        this.address = address;
        return this;
    }

    public String address() {
        return this.address;
    }

    public ServerBuilder port(int port) {
        this.port = port;
        return this;
    }

    public int port() {
        return this.port;
    }

    public ServerBuilder workers(int workers) {
        this.workers = workers;
        return this;
    }

    public int workers() {
        return this.workers;
    }

    public ServerBuilder protocol(Protocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public Protocol protocol() {
        return this.protocol;
    }

    public ServerBuilder exchangeClass(Class<? extends DefaultExchange<?>> exchangeClass) {
        this.exchangeClass = exchangeClass;
        return this;
    }

    public Class<? extends DefaultExchange<?>> exchangeClass() {
        return this.exchangeClass;
    }

    public ServerBuilder helperClass(Class<? extends RapidoidHelper> helperClass) {
        this.helperClass = helperClass;
        return this;
    }

    public Class<? extends RapidoidHelper> helperClass() {
        return this.helperClass;
    }

    public int bufSizeKB() {
        return this.bufSizeKB;
    }

    public void bufSizeKB(int bufSizeKB) {
        this.bufSizeKB = bufSizeKB;
    }

    public boolean noDelay() {
        return this.noDelay;
    }

    public void noDelay(boolean noDelay) {
        this.noDelay = noDelay;
    }

    public boolean syncBufs() {
        return this.syncBufs;
    }

    public ServerBuilder syncBufs(boolean syncBufs) {
        this.syncBufs = syncBufs;
        return this;
    }

    public Server build() {
        return new RapidoidServerLoop(this.protocol, this.exchangeClass, this.helperClass, this.address, this.port, this.workers, this.bufSizeKB, this.noDelay, this.syncBufs);
    }
}

