/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.net.impl;

import org.rapidoid.activity.LifecycleActivity;
import org.rapidoid.commons.Arr;
import org.rapidoid.log.Log;
import org.rapidoid.net.impl.LoopStatus;
import org.rapidoid.u.U;

public abstract class AbstractLoop<T>
extends LifecycleActivity<T>
implements Runnable {
    protected volatile Thread ownerThread;
    protected volatile LoopStatus status = LoopStatus.INIT;

    public AbstractLoop(String name) {
        super(name);
    }

    public LoopStatus status() {
        return this.status;
    }

    @Override
    public void run() {
        this.ownerThread = Thread.currentThread();
        Log.debug((String)"Starting event loop", (String)"name", (Object)this.name);
        this.setStatus(LoopStatus.BEFORE_LOOP);
        try {
            this.beforeLoop();
        }
        catch (Throwable e) {
            Log.error((String)"Error occured before loop is started", (String)"name", (Object)this.name, (String)"error", (Object)e);
            this.setStatus(LoopStatus.FAILED);
            return;
        }
        this.setStatus(LoopStatus.LOOP);
        while (this.status == LoopStatus.LOOP && !Thread.currentThread().isInterrupted()) {
            try {
                this.insideLoop();
            }
            catch (Throwable e) {
                Log.error((String)("Event loop exception in " + this.name), (Throwable)e);
            }
        }
        this.setStatus(LoopStatus.AFTER_LOOP);
        this.afterLoop();
        this.setStatus(LoopStatus.STOPPED);
        Log.debug((String)"Stopped event loop", (String)"name", (Object)this.name);
    }

    private void setStatus(LoopStatus status) {
        this.status = status;
    }

    protected synchronized void stopLoop() {
        Log.debug((String)"Stopping event loop", (String)"name", (Object)this.name);
        while (this.status == LoopStatus.INIT || this.status == LoopStatus.BEFORE_LOOP) {
            try {
                Thread.sleep(10L);
                Log.debug((String)"Waiting for event loop to initialize...", (String)"name", (Object)this.name);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.status == LoopStatus.LOOP) {
            this.status = LoopStatus.STOPPED;
        }
        Log.debug((String)"Stopped event loop", (String)"name", (Object)this.name);
    }

    protected void beforeLoop() {
    }

    protected abstract void insideLoop();

    protected void afterLoop() {
    }

    protected void assertStatus(LoopStatus expected) {
        if (this.status != expected) {
            throw new IllegalStateException("Expected status=" + (Object)((Object)expected) + " for event loop: " + this.name);
        }
    }

    protected boolean onSameThread() {
        return this.ownerThread == Thread.currentThread();
    }

    protected void checkOnSameThread() {
        if (!this.onSameThread()) {
            throw U.rte((String)"Not on the owner thread, expected %s, but found: %s", (Object[])new Object[]{this.ownerThread, Thread.currentThread()});
        }
    }

    public T start() {
        super.start();
        this.waitToStart();
        return (T)this;
    }

    public void waitForStatus(LoopStatus ... requiredStatuses) {
        while (!Arr.contains((Object[])requiredStatuses, (Object)((Object)this.status))) {
            U.sleep((long)5L);
        }
    }

    public void waitForStatusOtherThan(LoopStatus ... requiredStatuses) {
        while (Arr.contains((Object[])requiredStatuses, (Object)((Object)this.status))) {
            U.sleep((long)5L);
        }
    }

    public void waitToStart() {
        this.waitForStatusOtherThan(LoopStatus.INIT, LoopStatus.BEFORE_LOOP);
    }

    public T shutdown() {
        super.shutdown();
        this.waitToStop();
        return (T)this;
    }

    public void waitToStop() {
        this.waitForStatus(LoopStatus.STOPPED, LoopStatus.FAILED);
    }
}

