/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.net.impl;

import java.util.Map;
import org.rapidoid.RapidoidThing;
import org.rapidoid.buffer.Buf;
import org.rapidoid.buffer.BufProvider;
import org.rapidoid.data.BufRange;
import org.rapidoid.data.Data;
import org.rapidoid.data.KeyValueRanges;
import org.rapidoid.data.MultiData;
import org.rapidoid.net.impl.DecodedData;

public class DefaultMultiData
extends RapidoidThing
implements MultiData {
    private final BufProvider src;
    private final KeyValueRanges ranges;
    private Map<String, String> values;

    public DefaultMultiData(BufProvider src, KeyValueRanges ranges) {
        this.src = src;
        this.ranges = ranges;
    }

    public synchronized Map<String, String> get() {
        if (this.values == null) {
            this.values = this.ranges.toMap(this.src.buffer(), true, true, false);
        }
        return this.values;
    }

    public KeyValueRanges ranges() {
        return this.ranges;
    }

    public String toString() {
        return "MultiData [ranges=" + this.ranges + "]";
    }

    public String get(String name) {
        Data data = this.get_(name);
        return data != null ? data.get() : null;
    }

    public Data get_(String name) {
        Buf buf = this.src.buffer();
        BufRange range = this.ranges.get(buf, name.getBytes(), false);
        return range != null ? new DecodedData(this.src, range) : null;
    }

    public synchronized void reset() {
        this.values = null;
    }

    public void putExtras(Map<String, String> extras) {
        this.get().putAll(extras);
    }
}

