/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.corpus;

import com.aliasi.corpus.Corpus;
import com.aliasi.corpus.ObjectHandler;
import com.aliasi.util.AbstractExternalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListCorpus<E>
extends Corpus<ObjectHandler<E>>
implements Serializable {
    static final long serialVersionUID = 2705587926190761352L;
    private final List<E> mTrainCases = new ArrayList();
    private final List<E> mTestCases = new ArrayList();

    public void addTest(E e) {
        this.mTestCases.add(e);
    }

    public void addTrain(E e) {
        this.mTrainCases.add(e);
    }

    public void permuteCorpus(Random random) {
        Collections.shuffle(this.mTrainCases, random);
        Collections.shuffle(this.mTestCases, random);
    }

    @Override
    public void visitTrain(ObjectHandler<E> handler) {
        for (E e : this.mTrainCases) {
            handler.handle(e);
        }
    }

    @Override
    public void visitTest(ObjectHandler<E> handler) {
        for (E e : this.mTestCases) {
            handler.handle(e);
        }
    }

    Object writeReplace() {
        return new Serializer(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Serializer<F>
    extends AbstractExternalizable {
        static final long serialVersionUID = -5552459221218525839L;
        private final ListCorpus<F> mCorpus;

        public Serializer() {
            this(null);
        }

        public Serializer(ListCorpus<F> corpus) {
            this.mCorpus = corpus;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(((ListCorpus)this.mCorpus).mTrainCases.size());
            for (Object e : ((ListCorpus)this.mCorpus).mTrainCases) {
                out.writeObject(e);
            }
            out.writeInt(((ListCorpus)this.mCorpus).mTestCases.size());
            for (Object e : ((ListCorpus)this.mCorpus).mTestCases) {
                out.writeObject(e);
            }
        }

        @Override
        public Object read(ObjectInput in) throws IOException, ClassNotFoundException {
            ListCorpus<Object> corpus = new ListCorpus<Object>();
            int numTrain = in.readInt();
            for (int i = 0; i < numTrain; ++i) {
                Object e = in.readObject();
                corpus.addTrain(e);
            }
            int numTest = in.readInt();
            for (int i = 0; i < numTest; ++i) {
                Object e = in.readObject();
                corpus.addTest(e);
            }
            return corpus;
        }
    }
}

