/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.features;

import com.aliasi.chunk.Chunk;
import com.aliasi.chunk.Chunker;
import com.aliasi.chunk.Chunking;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.FeatureExtractor;
import com.aliasi.util.ObjectToDoubleMap;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkerFeatureExtractor
implements FeatureExtractor<CharSequence>,
Serializable {
    static final long serialVersionUID = 6331037082723097532L;
    private final Chunker mChunker;
    private final boolean mIncludePhrase;

    public ChunkerFeatureExtractor(Chunker chunker, boolean includePhrase) {
        this.mChunker = chunker;
        this.mIncludePhrase = includePhrase;
    }

    @Override
    public Map<String, ? extends Number> features(CharSequence in) {
        Chunking chunking = this.mChunker.chunk(in);
        Set<Chunk> chunkSet = chunking.chunkSet();
        if (chunkSet.isEmpty()) {
            return Collections.emptyMap();
        }
        ObjectToDoubleMap<String> features = new ObjectToDoubleMap<String>();
        CharSequence text = chunking.charSequence();
        for (Chunk chunk : chunkSet) {
            String chunkType = chunk.type();
            if (!this.mIncludePhrase) {
                features.increment(chunkType, 1.0);
                continue;
            }
            StringBuilder sb = new StringBuilder(chunkType);
            sb.append('_');
            sb.append(text, chunk.start(), chunk.end());
            features.increment(sb.toString(), 1.0);
        }
        return features;
    }

    Object writeReplace() {
        return new Serializer(this);
    }

    static class Serializer
    extends AbstractExternalizable {
        static final long serialVersionUID = 1943280252018121446L;
        final ChunkerFeatureExtractor mExtractor;

        public Serializer() {
            this(null);
        }

        public Serializer(ChunkerFeatureExtractor extractor) {
            this.mExtractor = extractor;
        }

        public Object read(ObjectInput in) throws IOException, ClassNotFoundException {
            Chunker chunker = (Chunker)in.readObject();
            boolean includePhrase = in.readBoolean();
            return new ChunkerFeatureExtractor(chunker, includePhrase);
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.mExtractor.mChunker);
            out.writeBoolean(this.mExtractor.mIncludePhrase);
        }
    }
}

