/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.features;

import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.FeatureExtractor;
import com.aliasi.util.ObjectToDoubleMap;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrefixedFeatureExtractor<E>
implements FeatureExtractor<E>,
Serializable {
    static final long serialVersionUID = -4693775065158617229L;
    private final FeatureExtractor<E> mBaseExtractor;
    private final String mPrefix;

    public PrefixedFeatureExtractor(String prefix, FeatureExtractor<E> extractor) {
        this.mPrefix = prefix;
        this.mBaseExtractor = extractor;
    }

    @Override
    public Map<String, ? extends Number> features(E in) {
        ObjectToDoubleMap<String> prefixedFeatureMap = new ObjectToDoubleMap<String>();
        Map<String, Number> featureMap = this.mBaseExtractor.features(in);
        for (Map.Entry<String, Number> entry : featureMap.entrySet()) {
            prefixedFeatureMap.set(this.mPrefix + entry.getKey(), entry.getValue().doubleValue());
        }
        return prefixedFeatureMap;
    }

    Object writeReplace() {
        return new Serializer(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Serializer<F>
    extends AbstractExternalizable {
        static final long serialVersionUID = 6332957246411784407L;
        final PrefixedFeatureExtractor<F> mPrefixedFeatureExtractor;

        public Serializer(PrefixedFeatureExtractor<F> prefixedFeatureExtractor) {
            this.mPrefixedFeatureExtractor = prefixedFeatureExtractor;
        }

        public Serializer() {
            this(null);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(((PrefixedFeatureExtractor)this.mPrefixedFeatureExtractor).mPrefix);
            out.writeObject(((PrefixedFeatureExtractor)this.mPrefixedFeatureExtractor).mBaseExtractor);
        }

        @Override
        public Object read(ObjectInput in) throws ClassNotFoundException, IOException {
            String prefix = in.readUTF();
            FeatureExtractor extractor = (FeatureExtractor)in.readObject();
            return new PrefixedFeatureExtractor(prefix, extractor);
        }
    }
}

