/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableCollection;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableList$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableList$Builder;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableList$SubList;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Lists;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ObjectArrays;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.RegularImmutableList;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.SingletonImmutableList;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.UnmodifiableIterator;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.UnmodifiableListIterator;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import javax.annotation.Nullable;

public abstract class ImmutableList
extends ImmutableCollection
implements List,
RandomAccess {
    private static final ImmutableList EMPTY = new RegularImmutableList(ObjectArrays.EMPTY_ARRAY);

    public static ImmutableList of() {
        return EMPTY;
    }

    public static ImmutableList of(Object object) {
        return new SingletonImmutableList(object);
    }

    public static ImmutableList of(Object object, Object object2) {
        return ImmutableList.construct(object, object2);
    }

    public static ImmutableList copyOf(Collection collection) {
        if (collection instanceof ImmutableCollection) {
            ImmutableList immutableList = ((ImmutableCollection)collection).asList();
            return immutableList.isPartialView() ? ImmutableList.asImmutableList(immutableList.toArray()) : immutableList;
        }
        return ImmutableList.construct(collection.toArray());
    }

    public static ImmutableList copyOf(Object[] objectArray) {
        switch (objectArray.length) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                return new SingletonImmutableList(objectArray[0]);
            }
        }
        return new RegularImmutableList(ObjectArrays.checkElementsNotNull((Object[])objectArray.clone()));
    }

    private static ImmutableList construct(Object ... objectArray) {
        return ImmutableList.asImmutableList(ObjectArrays.checkElementsNotNull(objectArray));
    }

    static ImmutableList asImmutableList(Object[] objectArray) {
        return ImmutableList.asImmutableList(objectArray, objectArray.length);
    }

    static ImmutableList asImmutableList(Object[] objectArray, int n) {
        switch (n) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                SingletonImmutableList singletonImmutableList = new SingletonImmutableList(objectArray[0]);
                return singletonImmutableList;
            }
        }
        if (n < objectArray.length) {
            objectArray = ObjectArrays.arraysCopyOf(objectArray, n);
        }
        return new RegularImmutableList(objectArray);
    }

    ImmutableList() {
    }

    @Override
    public UnmodifiableIterator iterator() {
        return this.listIterator();
    }

    public UnmodifiableListIterator listIterator() {
        return this.listIterator(0);
    }

    public UnmodifiableListIterator listIterator(int n) {
        return new ImmutableList$1(this, this.size(), n);
    }

    @Override
    public int indexOf(@Nullable Object object) {
        return object == null ? -1 : Lists.indexOfImpl(this, object);
    }

    @Override
    public int lastIndexOf(@Nullable Object object) {
        return object == null ? -1 : Lists.lastIndexOfImpl(this, object);
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return this.indexOf(object) >= 0;
    }

    public ImmutableList subList(int n, int n2) {
        Preconditions.checkPositionIndexes(n, n2, this.size());
        int n3 = n2 - n;
        switch (n3) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                return ImmutableList.of(this.get(n));
            }
        }
        return this.subListUnchecked(n, n2);
    }

    ImmutableList subListUnchecked(int n, int n2) {
        return new ImmutableList$SubList(this, n, n2 - n);
    }

    @Deprecated
    public final boolean addAll(int n, Collection collection) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final Object set(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final void add(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final Object remove(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final ImmutableList asList() {
        return this;
    }

    @Override
    int copyIntoArray(Object[] objectArray, int n) {
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            objectArray[n + i] = this.get(i);
        }
        return n + n2;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return Lists.equalsImpl(this, object);
    }

    @Override
    public int hashCode() {
        int n = 1;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            n = 31 * n + this.get(i).hashCode();
            n = ~(~n);
        }
        return n;
    }

    public static ImmutableList$Builder builder() {
        return new ImmutableList$Builder();
    }
}

