/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.hutool.core.convert.impl;

import com.dahuatech.hutool.core.bean.BeanUtil;
import com.dahuatech.hutool.core.bean.copier.BeanCopier;
import com.dahuatech.hutool.core.bean.copier.CopyOptions;
import com.dahuatech.hutool.core.bean.copier.ValueProvider;
import com.dahuatech.hutool.core.convert.AbstractConverter;
import com.dahuatech.hutool.core.map.MapProxy;
import com.dahuatech.hutool.core.util.ReflectUtil;
import com.dahuatech.hutool.core.util.TypeUtil;
import java.lang.reflect.Type;
import java.util.Map;

public class BeanConverter<T>
extends AbstractConverter<T> {
    private static final long serialVersionUID = 1L;
    private Type beanType;
    private Class<T> beanClass;
    private CopyOptions copyOptions;

    public BeanConverter(Type beanType) {
        this(beanType, CopyOptions.create().setIgnoreError(true));
    }

    public BeanConverter(Class<T> beanClass) {
        this(beanClass, CopyOptions.create().setIgnoreError(true));
    }

    public BeanConverter(Type beanType, CopyOptions copyOptions) {
        this.beanType = beanType;
        this.beanClass = TypeUtil.getClass(beanType);
        this.copyOptions = copyOptions;
    }

    @Override
    protected T convertInternal(Object value) {
        if (value instanceof Map || value instanceof ValueProvider || BeanUtil.isBean(value.getClass())) {
            if (value instanceof Map && this.beanClass.isInterface()) {
                return MapProxy.create((Map)value).toProxyBean(this.beanClass);
            }
            return BeanCopier.create(value, ReflectUtil.newInstanceIfPossible(this.beanClass), this.beanType, this.copyOptions).copy();
        }
        return null;
    }

    @Override
    public Class<T> getTargetType() {
        return this.beanClass;
    }
}

