/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.annotations.Beta;
import com.google.common.base.Ascii;
import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.net.HostAndPort;
import com.google.common.primitives.Bytes;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

@Beta
public class HttpUriBuilder {
    private String scheme;
    private String host;
    private int port = -1;
    private String path = "";
    private ListMultimap<String, String> params = LinkedListMultimap.create();
    private static byte[] PCHAR = new byte[]{97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 46, 95, 126, 33, 36, 39, 40, 41, 42, 43, 44, 59, 61, 58, 64};
    private static byte[] ALLOWED_PATH_CHARS = Bytes.concat((byte[][])new byte[][]{PCHAR, {47, 38}});
    private static byte[] ALLOWED_QUERY_CHARS = Bytes.concat((byte[][])new byte[][]{PCHAR, {47, 63}});

    private HttpUriBuilder() {
    }

    private HttpUriBuilder(URI previous) {
        this.scheme = previous.getScheme();
        this.host = previous.getHost();
        this.port = previous.getPort();
        this.path = this.percentDecode(previous.getRawPath());
        this.params.putAll(this.parseParams(previous.getRawQuery()));
    }

    public static HttpUriBuilder uriBuilder() {
        return new HttpUriBuilder();
    }

    public static HttpUriBuilder uriBuilderFrom(URI uri) {
        Preconditions.checkNotNull((Object)uri, (Object)"uri is null");
        return new HttpUriBuilder(uri);
    }

    public HttpUriBuilder scheme(String scheme) {
        Preconditions.checkNotNull((Object)scheme, (Object)"scheme is null");
        this.scheme = scheme;
        return this;
    }

    public HttpUriBuilder host(String host) {
        Preconditions.checkNotNull((Object)host, (Object)"host is null");
        Preconditions.checkArgument((!host.startsWith("[") ? 1 : 0) != 0, (Object)"host starts with a bracket");
        Preconditions.checkArgument((!host.endsWith("]") ? 1 : 0) != 0, (Object)"host ends with a bracket");
        if (host.contains(":")) {
            host = "[" + host + "]";
        }
        this.host = host;
        return this;
    }

    public HttpUriBuilder port(int port) {
        Preconditions.checkArgument((port >= 1 && port <= 65535 ? 1 : 0) != 0, (Object)"port must be in the range 1-65535");
        this.port = port;
        return this;
    }

    public HttpUriBuilder defaultPort() {
        this.port = -1;
        return this;
    }

    public HttpUriBuilder hostAndPort(HostAndPort hostAndPort) {
        Preconditions.checkNotNull((Object)hostAndPort, (Object)"hostAndPort is null");
        this.host = HttpUriBuilder.bracketedHostString(hostAndPort);
        this.port = hostAndPort.hasPort() ? hostAndPort.getPort() : -1;
        return this;
    }

    public HttpUriBuilder replacePath(String path) {
        Preconditions.checkNotNull((Object)path, (Object)"path is null");
        if (!path.equals("") && !path.startsWith("/")) {
            path = "/" + path;
        }
        this.path = path;
        return this;
    }

    public HttpUriBuilder appendPath(String path) {
        Preconditions.checkNotNull((Object)path, (Object)"path is null");
        StringBuilder builder = new StringBuilder(this.path);
        if (!this.path.endsWith("/")) {
            builder.append('/');
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        builder.append(path);
        this.path = builder.toString();
        return this;
    }

    public HttpUriBuilder replaceParameter(String name, String ... values) {
        return this.replaceParameter(name, Arrays.asList(values));
    }

    public HttpUriBuilder replaceParameter(String name, Iterable<String> values) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.params.removeAll((Object)name);
        this.addParameter(name, values);
        return this;
    }

    public HttpUriBuilder addParameter(String name, String ... values) {
        return this.addParameter(name, Arrays.asList(values));
    }

    public HttpUriBuilder addParameter(String name, Iterable<String> values) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        if (Iterables.isEmpty(values)) {
            this.params.put((Object)name, null);
        }
        for (String value : values) {
            this.params.put((Object)name, (Object)value);
        }
        return this;
    }

    public String toString() {
        String path;
        StringBuilder builder = new StringBuilder();
        builder.append(this.scheme);
        builder.append("://");
        if (this.host != null) {
            builder.append(this.host);
        }
        if (this.port != -1) {
            builder.append(':');
            builder.append(this.port);
        }
        if ((path = this.path).equals("") && !this.params.isEmpty()) {
            path = "/";
        }
        builder.append(this.encode(path, ALLOWED_PATH_CHARS));
        if (!this.params.isEmpty()) {
            builder.append('?');
            Iterator iterator = this.params.entries().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                builder.append(this.encode((String)entry.getKey(), ALLOWED_QUERY_CHARS));
                if (entry.getValue() != null) {
                    builder.append('=');
                    builder.append(this.encode((String)entry.getValue(), ALLOWED_QUERY_CHARS));
                }
                if (!iterator.hasNext()) continue;
                builder.append('&');
            }
        }
        return builder.toString();
    }

    public URI build() {
        Preconditions.checkState((this.scheme != null ? 1 : 0) != 0, (Object)"scheme has not been set");
        return URI.create(this.toString());
    }

    private ListMultimap<String, String> parseParams(String query) {
        LinkedListMultimap result = LinkedListMultimap.create();
        if (query != null) {
            Iterable pairs = Splitter.on((String)"&").omitEmptyStrings().split((CharSequence)query);
            for (String pair : pairs) {
                String[] parts = pair.split("=", 2);
                result.put((Object)this.percentDecode(parts[0]), (Object)this.percentDecode(parts[1]));
            }
        }
        return result;
    }

    private String encode(String input, byte ... allowed) {
        StringBuilder builder = new StringBuilder();
        ByteBuffer buffer = Charsets.UTF_8.encode(input);
        while (buffer.remaining() > 0) {
            byte b = buffer.get();
            if (Bytes.contains((byte[])allowed, (byte)b)) {
                builder.append((char)b);
                continue;
            }
            builder.append('%');
            builder.append(Ascii.toUpperCase((char)Character.forDigit(b >>> 4 & 0xF, 16)));
            builder.append(Ascii.toUpperCase((char)Character.forDigit(b & 0xF, 16)));
        }
        return builder.toString();
    }

    private String percentDecode(String encoded) {
        Preconditions.checkArgument((boolean)CharMatcher.ASCII.matchesAllOf((CharSequence)encoded), (Object)"string must be ASCII");
        ByteArrayOutputStream out = new ByteArrayOutputStream(encoded.length());
        for (int i = 0; i < encoded.length(); ++i) {
            char c = encoded.charAt(i);
            if (c == '%') {
                Preconditions.checkArgument((i + 2 < encoded.length() ? 1 : 0) != 0, (Object)"percent encoded value is truncated");
                int high = Character.digit(encoded.charAt(i + 1), 16);
                int low = Character.digit(encoded.charAt(i + 2), 16);
                Preconditions.checkArgument((high != -1 && low != -1 ? 1 : 0) != 0, (String)"percent encoded value is not a valid hex string: ", (Object[])new Object[]{encoded.substring(i, i + 2)});
                int value = high << 4 | low;
                out.write(value);
                i += 2;
                continue;
            }
            out.write(c);
        }
        try {
            return Charsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).decode(ByteBuffer.wrap(out.toByteArray())).toString();
        }
        catch (CharacterCodingException e) {
            throw new IllegalArgumentException("input does not represent a proper UTF8-encoded string");
        }
    }

    private static String bracketedHostString(HostAndPort hostAndPort) {
        String host = hostAndPort.getHostText();
        if (hostAndPort.toString().startsWith("[")) {
            return "[" + host + "]";
        }
        return host;
    }
}

