/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal.client;

import com.facebook.presto.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import com.facebook.presto.hadoop.shaded.com.google.common.base.Joiner;
import com.facebook.presto.hadoop.shaded.com.google.common.base.Preconditions;
import com.facebook.presto.hadoop.shaded.com.google.common.collect.ImmutableList;
import com.facebook.presto.hadoop.shaded.com.google.common.collect.Maps;
import com.facebook.presto.hadoop.shaded.com.google.common.util.concurrent.ListenableFuture;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.hdfs.qjournal.client.AsyncLogger;
import org.apache.hadoop.hdfs.qjournal.client.QuorumCall;
import org.apache.hadoop.hdfs.qjournal.protocol.QJournalProtocolProtos;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLogManifest;
import org.apache.jasper.compiler.JspUtil;

class AsyncLoggerSet {
    static final Log LOG = LogFactory.getLog(AsyncLoggerSet.class);
    private final List<AsyncLogger> loggers;
    private static final long INVALID_EPOCH = -1L;
    private long myEpoch = -1L;

    public AsyncLoggerSet(List<AsyncLogger> loggers) {
        this.loggers = ImmutableList.copyOf(loggers);
    }

    void setEpoch(long e) {
        Preconditions.checkState(!this.isEpochEstablished(), "Epoch already established: epoch=%s", this.myEpoch);
        this.myEpoch = e;
        for (AsyncLogger l : this.loggers) {
            l.setEpoch(e);
        }
    }

    public void setCommittedTxId(long txid) {
        for (AsyncLogger logger : this.loggers) {
            logger.setCommittedTxId(txid);
        }
    }

    boolean isEpochEstablished() {
        return this.myEpoch != -1L;
    }

    long getEpoch() {
        Preconditions.checkState(this.myEpoch != -1L, "No epoch created yet");
        return this.myEpoch;
    }

    void close() {
        for (AsyncLogger logger : this.loggers) {
            logger.close();
        }
    }

    void purgeLogsOlderThan(long minTxIdToKeep) {
        for (AsyncLogger logger : this.loggers) {
            logger.purgeLogsOlderThan(minTxIdToKeep);
        }
    }

    <V> Map<AsyncLogger, V> waitForWriteQuorum(QuorumCall<AsyncLogger, V> q, int timeoutMs, String operationName) throws IOException {
        int majority = this.getMajoritySize();
        try {
            q.waitFor(this.loggers.size(), majority, majority, timeoutMs, operationName);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted waiting " + timeoutMs + "ms for a " + "quorum of nodes to respond.");
        }
        catch (TimeoutException e) {
            throw new IOException("Timed out waiting " + timeoutMs + "ms for a " + "quorum of nodes to respond.");
        }
        if (q.countSuccesses() < majority) {
            q.rethrowException("Got too many exceptions to achieve quorum size " + this.getMajorityString());
        }
        return q.getResults();
    }

    int getMajoritySize() {
        return this.loggers.size() / 2 + 1;
    }

    String getMajorityString() {
        return this.getMajoritySize() + "/" + this.loggers.size();
    }

    int size() {
        return this.loggers.size();
    }

    public String toString() {
        return "[" + Joiner.on(", ").join(this.loggers) + "]";
    }

    void appendHtmlReport(StringBuilder sb) {
        sb.append("<table class=\"storage\">");
        sb.append("<thead><tr><td>JN</td><td>Status</td></tr></thead>\n");
        for (AsyncLogger l : this.loggers) {
            sb.append("<tr>");
            sb.append("<td>" + JspUtil.escapeXml((String)l.toString()) + "</td>");
            sb.append("<td>");
            l.appendHtmlReport(sb);
            sb.append("</td></tr>\n");
        }
        sb.append("</table>");
    }

    @VisibleForTesting
    List<AsyncLogger> getLoggersForTests() {
        return this.loggers;
    }

    public QuorumCall<AsyncLogger, QJournalProtocolProtos.GetJournalStateResponseProto> getJournalState() {
        HashMap<AsyncLogger, ListenableFuture<QJournalProtocolProtos.GetJournalStateResponseProto>> calls = Maps.newHashMap();
        for (AsyncLogger logger : this.loggers) {
            calls.put(logger, logger.getJournalState());
        }
        return QuorumCall.create(calls);
    }

    public QuorumCall<AsyncLogger, Boolean> isFormatted() {
        HashMap<AsyncLogger, ListenableFuture<Boolean>> calls = Maps.newHashMap();
        for (AsyncLogger logger : this.loggers) {
            calls.put(logger, logger.isFormatted());
        }
        return QuorumCall.create(calls);
    }

    public QuorumCall<AsyncLogger, QJournalProtocolProtos.NewEpochResponseProto> newEpoch(NamespaceInfo nsInfo, long epoch) {
        HashMap<AsyncLogger, ListenableFuture<QJournalProtocolProtos.NewEpochResponseProto>> calls = Maps.newHashMap();
        for (AsyncLogger logger : this.loggers) {
            calls.put(logger, logger.newEpoch(epoch));
        }
        return QuorumCall.create(calls);
    }

    public QuorumCall<AsyncLogger, Void> startLogSegment(long txid) {
        HashMap<AsyncLogger, ListenableFuture<Void>> calls = Maps.newHashMap();
        for (AsyncLogger logger : this.loggers) {
            calls.put(logger, logger.startLogSegment(txid));
        }
        return QuorumCall.create(calls);
    }

    public QuorumCall<AsyncLogger, Void> finalizeLogSegment(long firstTxId, long lastTxId) {
        HashMap<AsyncLogger, ListenableFuture<Void>> calls = Maps.newHashMap();
        for (AsyncLogger logger : this.loggers) {
            calls.put(logger, logger.finalizeLogSegment(firstTxId, lastTxId));
        }
        return QuorumCall.create(calls);
    }

    public QuorumCall<AsyncLogger, Void> sendEdits(long segmentTxId, long firstTxnId, int numTxns, byte[] data) {
        HashMap<AsyncLogger, ListenableFuture<Void>> calls = Maps.newHashMap();
        for (AsyncLogger logger : this.loggers) {
            ListenableFuture<Void> future = logger.sendEdits(segmentTxId, firstTxnId, numTxns, data);
            calls.put(logger, future);
        }
        return QuorumCall.create(calls);
    }

    public QuorumCall<AsyncLogger, RemoteEditLogManifest> getEditLogManifest(long fromTxnId, boolean forReading, boolean inProgressOk) {
        HashMap<AsyncLogger, ListenableFuture<RemoteEditLogManifest>> calls = Maps.newHashMap();
        for (AsyncLogger logger : this.loggers) {
            ListenableFuture<RemoteEditLogManifest> future = logger.getEditLogManifest(fromTxnId, forReading, inProgressOk);
            calls.put(logger, future);
        }
        return QuorumCall.create(calls);
    }

    QuorumCall<AsyncLogger, QJournalProtocolProtos.PrepareRecoveryResponseProto> prepareRecovery(long segmentTxId) {
        HashMap<AsyncLogger, ListenableFuture<QJournalProtocolProtos.PrepareRecoveryResponseProto>> calls = Maps.newHashMap();
        for (AsyncLogger logger : this.loggers) {
            ListenableFuture<QJournalProtocolProtos.PrepareRecoveryResponseProto> future = logger.prepareRecovery(segmentTxId);
            calls.put(logger, future);
        }
        return QuorumCall.create(calls);
    }

    QuorumCall<AsyncLogger, Void> acceptRecovery(QJournalProtocolProtos.SegmentStateProto log, URL fromURL) {
        HashMap<AsyncLogger, ListenableFuture<Void>> calls = Maps.newHashMap();
        for (AsyncLogger logger : this.loggers) {
            ListenableFuture<Void> future = logger.acceptRecovery(log, fromURL);
            calls.put(logger, future);
        }
        return QuorumCall.create(calls);
    }

    QuorumCall<AsyncLogger, Void> format(NamespaceInfo nsInfo) {
        HashMap<AsyncLogger, ListenableFuture<Void>> calls = Maps.newHashMap();
        for (AsyncLogger logger : this.loggers) {
            ListenableFuture<Void> future = logger.format(nsInfo);
            calls.put(logger, future);
        }
        return QuorumCall.create(calls);
    }
}

