/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.facebook.presto.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import com.facebook.presto.hadoop.shaded.org.apache.commons.daemon.Daemon;
import com.facebook.presto.hadoop.shaded.org.apache.commons.daemon.DaemonContext;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.security.SslSocketConnector;

public class SecureDataNodeStarter
implements Daemon {
    private String[] args;
    private SecureResources resources;
    private SSLFactory sslFactory;

    public void init(DaemonContext context) throws Exception {
        System.err.println("Initializing secure datanode resources");
        Configuration conf = new Configuration();
        this.args = context.getArguments();
        this.sslFactory = new SSLFactory(SSLFactory.Mode.SERVER, conf);
        this.resources = SecureDataNodeStarter.getSecureResources(this.sslFactory, conf);
    }

    public void start() throws Exception {
        System.err.println("Starting regular datanode initialization");
        DataNode.secureMain(this.args, this.resources);
    }

    public void destroy() {
        this.sslFactory.destroy();
    }

    public void stop() throws Exception {
    }

    @VisibleForTesting
    public static SecureResources getSecureResources(final SSLFactory sslFactory, Configuration conf) throws Exception {
        Object listener;
        InetSocketAddress streamingAddr = DataNode.getStreamingAddr(conf);
        int socketWriteTimeout = conf.getInt("dfs.datanode.socket.write.timeout", HdfsServerConstants.WRITE_TIMEOUT);
        ServerSocket ss = socketWriteTimeout > 0 ? ServerSocketChannel.open().socket() : new ServerSocket();
        ss.bind(streamingAddr, 0);
        if (ss.getLocalPort() != streamingAddr.getPort()) {
            throw new RuntimeException("Unable to bind on specified streaming port in secure context. Needed " + streamingAddr.getPort() + ", got " + ss.getLocalPort());
        }
        if (HttpConfig.isSecure()) {
            try {
                sslFactory.init();
            }
            catch (GeneralSecurityException ex) {
                throw new IOException(ex);
            }
            SslSocketConnector sslListener = new SslSocketConnector(){

                protected SSLServerSocketFactory createFactory() throws Exception {
                    return sslFactory.createSSLServerSocketFactory();
                }
            };
            listener = sslListener;
        } else {
            listener = HttpServer.createDefaultChannelConnector();
        }
        InetSocketAddress infoSocAddr = DataNode.getInfoAddr(conf);
        listener.setHost(infoSocAddr.getHostName());
        listener.setPort(infoSocAddr.getPort());
        listener.open();
        if (listener.getPort() != infoSocAddr.getPort()) {
            throw new RuntimeException("Unable to bind on specified info port in secure context. Needed " + streamingAddr.getPort() + ", got " + ss.getLocalPort());
        }
        System.err.println("Successfully obtained privileged resources (streaming port = " + ss + " ) (http listener port = " + listener.getConnection() + ")");
        if ((ss.getLocalPort() > 1023 || listener.getPort() > 1023) && UserGroupInformation.isSecurityEnabled()) {
            throw new RuntimeException("Cannot start secure datanode with unprivileged ports");
        }
        System.err.println("Opened streaming server at " + streamingAddr);
        System.err.println("Opened info server at " + infoSocAddr);
        return new SecureResources(ss, (Connector)listener);
    }

    public static class SecureResources {
        private final ServerSocket streamingSocket;
        private final Connector listener;

        public SecureResources(ServerSocket streamingSocket, Connector listener) {
            this.streamingSocket = streamingSocket;
            this.listener = listener;
        }

        public ServerSocket getStreamingSocket() {
            return this.streamingSocket;
        }

        public Connector getListener() {
            return this.listener;
        }
    }
}

