/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc.metrics;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterInt;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableRate;

@Metrics(about="Aggregate RPC metrics", context="rpc")
@InterfaceAudience.Private
public class RpcMetrics {
    static final Log LOG = LogFactory.getLog(RpcMetrics.class);
    final Server server;
    final MetricsRegistry registry;
    final String name;
    @Metric(value={"Number of received bytes"})
    MutableCounterLong receivedBytes;
    @Metric(value={"Number of sent bytes"})
    MutableCounterLong sentBytes;
    @Metric(value={"Queue time"})
    MutableRate rpcQueueTime;
    @Metric(value={"Processsing time"})
    MutableRate rpcProcessingTime;
    @Metric(value={"Number of authentication failures"})
    MutableCounterInt rpcAuthenticationFailures;
    @Metric(value={"Number of authentication successes"})
    MutableCounterInt rpcAuthenticationSuccesses;
    @Metric(value={"Number of authorization failures"})
    MutableCounterInt rpcAuthorizationFailures;
    @Metric(value={"Number of authorization sucesses"})
    MutableCounterInt rpcAuthorizationSuccesses;

    RpcMetrics(Server server) {
        String port = String.valueOf(server.getListenerAddress().getPort());
        this.name = "RpcActivityForPort" + port;
        this.server = server;
        this.registry = new MetricsRegistry("rpc").tag("port", "RPC port", port);
        LOG.debug("Initialized " + this.registry);
    }

    public String name() {
        return this.name;
    }

    public static RpcMetrics create(Server server) {
        RpcMetrics m = new RpcMetrics(server);
        return DefaultMetricsSystem.instance().register(m.name, null, m);
    }

    @Metric(value={"Number of open connections"})
    public int numOpenConnections() {
        return this.server.getNumOpenConnections();
    }

    @Metric(value={"Length of the call queue"})
    public int callQueueLength() {
        return this.server.getCallQueueLen();
    }

    public void incrAuthenticationFailures() {
        this.rpcAuthenticationFailures.incr();
    }

    public void incrAuthenticationSuccesses() {
        this.rpcAuthenticationSuccesses.incr();
    }

    public void incrAuthorizationSuccesses() {
        this.rpcAuthorizationSuccesses.incr();
    }

    public void incrAuthorizationFailures() {
        this.rpcAuthorizationFailures.incr();
    }

    public void shutdown() {
    }

    public void incrSentBytes(int count) {
        this.sentBytes.incr(count);
    }

    public void incrReceivedBytes(int count) {
        this.receivedBytes.incr(count);
    }

    public void addRpcQueueTime(int qTime) {
        this.rpcQueueTime.add(qTime);
    }

    public void addRpcProcessingTime(int processingTime) {
        this.rpcProcessingTime.add(processingTime);
    }
}

