/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token;

import com.facebook.presto.hadoop.shaded.com.google.common.collect.Maps;
import com.facebook.presto.hadoop.shaded.org.apache.commons.codec.binary.Base64;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenRenewer;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class Token<T extends TokenIdentifier>
implements Writable {
    public static final Log LOG = LogFactory.getLog(Token.class);
    private static Map<Text, Class<? extends TokenIdentifier>> tokenKindMap;
    private byte[] identifier;
    private byte[] password;
    private Text kind;
    private Text service;
    private TokenRenewer renewer;
    private static ServiceLoader<TokenRenewer> renewers;
    private static final TokenRenewer TRIVIAL_RENEWER;

    public Token(T id, SecretManager<T> mgr) {
        this.password = mgr.createPassword(id);
        this.identifier = ((TokenIdentifier)id).getBytes();
        this.kind = ((TokenIdentifier)id).getKind();
        this.service = new Text();
    }

    public Token(byte[] identifier, byte[] password, Text kind, Text service) {
        this.identifier = identifier;
        this.password = password;
        this.kind = kind;
        this.service = service;
    }

    public Token() {
        this.identifier = new byte[0];
        this.password = new byte[0];
        this.kind = new Text();
        this.service = new Text();
    }

    public Token(Token<T> other) {
        this.identifier = other.identifier;
        this.password = other.password;
        this.kind = other.kind;
        this.service = other.service;
    }

    public byte[] getIdentifier() {
        return this.identifier;
    }

    private static synchronized Class<? extends TokenIdentifier> getClassForIdentifier(Text kind) {
        Class<? extends TokenIdentifier> cls;
        if (tokenKindMap == null) {
            tokenKindMap = Maps.newHashMap();
            for (TokenIdentifier id : ServiceLoader.load(TokenIdentifier.class)) {
                tokenKindMap.put(id.getKind(), id.getClass());
            }
        }
        if ((cls = tokenKindMap.get(kind)) == null) {
            LOG.warn("Cannot find class for token kind " + kind);
            return null;
        }
        return cls;
    }

    public T decodeIdentifier() throws IOException {
        Class<TokenIdentifier> cls = Token.getClassForIdentifier(this.getKind());
        if (cls == null) {
            return null;
        }
        TokenIdentifier tokenIdentifier = ReflectionUtils.newInstance(cls, null);
        ByteArrayInputStream buf = new ByteArrayInputStream(this.identifier);
        DataInputStream in = new DataInputStream(buf);
        tokenIdentifier.readFields(in);
        in.close();
        return (T)tokenIdentifier;
    }

    public byte[] getPassword() {
        return this.password;
    }

    public synchronized Text getKind() {
        return this.kind;
    }

    @InterfaceAudience.Private
    public synchronized void setKind(Text newKind) {
        this.kind = newKind;
        this.renewer = null;
    }

    public Text getService() {
        return this.service;
    }

    public void setService(Text newService) {
        this.service = newService;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        int len = WritableUtils.readVInt(in);
        if (this.identifier == null || this.identifier.length != len) {
            this.identifier = new byte[len];
        }
        in.readFully(this.identifier);
        len = WritableUtils.readVInt(in);
        if (this.password == null || this.password.length != len) {
            this.password = new byte[len];
        }
        in.readFully(this.password);
        this.kind.readFields(in);
        this.service.readFields(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt(out, this.identifier.length);
        out.write(this.identifier);
        WritableUtils.writeVInt(out, this.password.length);
        out.write(this.password);
        this.kind.write(out);
        this.service.write(out);
    }

    private static String encodeWritable(Writable obj) throws IOException {
        DataOutputBuffer buf = new DataOutputBuffer();
        obj.write(buf);
        Base64 encoder = new Base64(0, null, true);
        byte[] raw = new byte[buf.getLength()];
        System.arraycopy(buf.getData(), 0, raw, 0, buf.getLength());
        return encoder.encodeToString(raw);
    }

    private static void decodeWritable(Writable obj, String newValue) throws IOException {
        Base64 decoder = new Base64(0, null, true);
        DataInputBuffer buf = new DataInputBuffer();
        byte[] decoded = decoder.decode(newValue);
        buf.reset(decoded, decoded.length);
        obj.readFields(buf);
    }

    public String encodeToUrlString() throws IOException {
        return Token.encodeWritable(this);
    }

    public void decodeFromUrlString(String newValue) throws IOException {
        Token.decodeWritable(this, newValue);
    }

    public boolean equals(Object right) {
        if (this == right) {
            return true;
        }
        if (right == null || this.getClass() != right.getClass()) {
            return false;
        }
        Token r = (Token)right;
        return Arrays.equals(this.identifier, r.identifier) && Arrays.equals(this.password, r.password) && this.kind.equals(r.kind) && this.service.equals(r.service);
    }

    public int hashCode() {
        return WritableComparator.hashBytes(this.identifier, this.identifier.length);
    }

    private static void addBinaryBuffer(StringBuilder buffer, byte[] bytes) {
        for (int idx = 0; idx < bytes.length; ++idx) {
            String num;
            if (idx != 0) {
                buffer.append(' ');
            }
            if ((num = Integer.toHexString(0xFF & bytes[idx])).length() < 2) {
                buffer.append('0');
            }
            buffer.append(num);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void identifierToString(StringBuilder buffer) {
        Object id = null;
        try {
            id = this.decodeIdentifier();
        }
        catch (IOException iOException) {
        }
        finally {
            if (id != null) {
                buffer.append("(").append((Object)id).append(")");
            } else {
                Token.addBinaryBuffer(buffer, this.identifier);
            }
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Kind: ");
        buffer.append(this.kind.toString());
        buffer.append(", Service: ");
        buffer.append(this.service.toString());
        buffer.append(", Ident: ");
        this.identifierToString(buffer);
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized TokenRenewer getRenewer() throws IOException {
        if (this.renewer != null) {
            return this.renewer;
        }
        this.renewer = TRIVIAL_RENEWER;
        ServiceLoader<TokenRenewer> serviceLoader = renewers;
        synchronized (serviceLoader) {
            for (TokenRenewer canidate : renewers) {
                if (!canidate.handleKind(this.kind)) continue;
                this.renewer = canidate;
                return this.renewer;
            }
        }
        LOG.warn("No TokenRenewer defined for token kind " + this.kind);
        return this.renewer;
    }

    public boolean isManaged() throws IOException {
        return this.getRenewer().isManaged(this);
    }

    public long renew(Configuration conf) throws IOException, InterruptedException {
        return this.getRenewer().renew(this, conf);
    }

    public void cancel(Configuration conf) throws IOException, InterruptedException {
        this.getRenewer().cancel(this, conf);
    }

    static {
        renewers = ServiceLoader.load(TokenRenewer.class);
        TRIVIAL_RENEWER = new TrivialRenewer();
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
    @InterfaceStability.Evolving
    public static class TrivialRenewer
    extends TokenRenewer {
        protected Text getKind() {
            return null;
        }

        @Override
        public boolean handleKind(Text kind) {
            return kind.equals(this.getKind());
        }

        @Override
        public boolean isManaged(Token<?> token) {
            return false;
        }

        @Override
        public long renew(Token<?> token, Configuration conf) {
            throw new UnsupportedOperationException("Token renewal is not supported  for " + ((Token)token).kind + " tokens");
        }

        @Override
        public void cancel(Token<?> token, Configuration conf) throws IOException, InterruptedException {
            throw new UnsupportedOperationException("Token cancel is not supported  for " + ((Token)token).kind + " tokens");
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class PrivateToken<T extends TokenIdentifier>
    extends Token<T> {
        public PrivateToken(Token<T> token) {
            super(token);
        }
    }
}

