/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import com.google.common.base.Preconditions;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;

class ExponentialBackOff {
    private final long initialWait;
    private final long maxWait;
    private final String serverUpMessage;
    private final String serverDownMessage;
    private final Logger log;
    @GuardedBy(value="this")
    private boolean serverUp = true;
    @GuardedBy(value="this")
    private long currentWaitInMillis = -1L;

    public ExponentialBackOff(Duration initialWait, Duration maxWait, String serverUpMessage, String serverDownMessage, Logger log) {
        this.initialWait = ((Duration)Preconditions.checkNotNull((Object)initialWait, (Object)"initialWait is null")).toMillis();
        this.maxWait = ((Duration)Preconditions.checkNotNull((Object)maxWait, (Object)"maxWait is null")).toMillis();
        Preconditions.checkArgument((this.initialWait <= this.maxWait ? 1 : 0) != 0, (String)"initialWait %s is less than maxWait %s", (Object[])new Object[]{initialWait, maxWait});
        this.serverUpMessage = (String)Preconditions.checkNotNull((Object)serverUpMessage, (Object)"serverUpMessage is null");
        this.serverDownMessage = (String)Preconditions.checkNotNull((Object)serverDownMessage, (Object)"serverDownMessage is null");
        this.log = (Logger)Preconditions.checkNotNull((Object)log, (Object)"log is null");
    }

    public synchronized void success() {
        if (!this.serverUp) {
            this.serverUp = true;
            this.log.info(this.serverUpMessage);
        }
        this.currentWaitInMillis = -1L;
    }

    public synchronized Duration failed(Throwable t) {
        if (this.serverUp) {
            this.serverUp = false;
            this.log.error("%s: %s", new Object[]{this.serverDownMessage, t.getMessage()});
        }
        this.log.debug(t, this.serverDownMessage);
        this.currentWaitInMillis = this.currentWaitInMillis <= 0L ? this.initialWait : Math.min(this.currentWaitInMillis * 2L, this.maxWait);
        return new Duration((double)this.currentWaitInMillis, TimeUnit.MILLISECONDS);
    }
}

