/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc;

import com.facebook.hive.orc.OrcProto;

public class StreamName
implements Comparable<StreamName> {
    private final int column;
    private final OrcProto.Stream.Kind kind;

    public StreamName(int column, OrcProto.Stream.Kind kind) {
        this.column = column;
        this.kind = kind;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof StreamName) {
            StreamName other = (StreamName)obj;
            return other.column == this.column && other.kind == this.kind;
        }
        return false;
    }

    @Override
    public int compareTo(StreamName streamName) {
        if (streamName == null) {
            return -1;
        }
        Area area = StreamName.getArea(this.kind);
        Area otherArea = StreamName.getArea(streamName.kind);
        if (area != otherArea) {
            return -area.compareTo(otherArea);
        }
        if (this.column != streamName.column) {
            return this.column < streamName.column ? -1 : 1;
        }
        return this.compareKinds(this.kind, streamName.kind);
    }

    private int compareKinds(OrcProto.Stream.Kind kind1, OrcProto.Stream.Kind kind2) {
        if (kind1 == OrcProto.Stream.Kind.LENGTH && kind2 == OrcProto.Stream.Kind.DATA) {
            return -1;
        }
        if (kind1 == OrcProto.Stream.Kind.DATA && kind2 == OrcProto.Stream.Kind.LENGTH) {
            return 1;
        }
        return kind1.compareTo(kind2);
    }

    public int getColumn() {
        return this.column;
    }

    public OrcProto.Stream.Kind getKind() {
        return this.kind;
    }

    public Area getArea() {
        return StreamName.getArea(this.kind);
    }

    public static Area getArea(OrcProto.Stream.Kind kind) {
        switch (kind) {
            case ROW_INDEX: 
            case DICTIONARY_COUNT: {
                return Area.INDEX;
            }
            case DICTIONARY_DATA: {
                return Area.DICTIONARY;
            }
        }
        return Area.DATA;
    }

    public String toString() {
        return "Stream for column " + this.column + " kind " + (Object)((Object)this.kind);
    }

    public int hashCode() {
        return this.column * 101 + this.kind.getNumber();
    }

    public static enum Area {
        DATA,
        DICTIONARY,
        INDEX;

    }
}

