/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc.lazy;

import com.facebook.hive.orc.lazy.LazyNumericDictionaryTreeReader;
import com.facebook.hive.orc.lazy.OrcLazyObject;
import java.io.IOException;
import org.apache.hadoop.hive.serde2.io.ShortWritable;

class LazyShortDictionaryTreeReader
extends LazyNumericDictionaryTreeReader {
    private short latestValue;

    LazyShortDictionaryTreeReader(int columnId, long rowIndexStride) {
        super(columnId, rowIndexStride);
    }

    @Override
    protected int getNumBytes() {
        return 2;
    }

    private short readShort() throws IOException {
        this.latestValue = (short)this.readPrimitive();
        return this.latestValue;
    }

    private short latestValue() {
        return this.latestValue;
    }

    ShortWritable createWritable(Object previous, short v) throws IOException {
        ShortWritable result = null;
        result = previous == null ? new ShortWritable() : (ShortWritable)previous;
        result.set(v);
        return result;
    }

    @Override
    public Object createWritableFromLatest(Object previous) throws IOException {
        return this.createWritable(previous, this.latestValue());
    }

    @Override
    public short nextShort(boolean readStream) throws IOException {
        if (!readStream) {
            return this.latestValue();
        }
        if (!this.valuePresent) {
            throw new OrcLazyObject.ValueNotPresentException("Cannot materialize short.");
        }
        return this.readShort();
    }

    @Override
    public Object next(Object previous) throws IOException {
        ShortWritable result = null;
        if (this.valuePresent) {
            result = this.createWritable(previous, this.readShort());
        }
        return result;
    }
}

