/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.checkpoint.DoubleStreamCheckpoint;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.orc.stream.OrcStreamUtils;
import com.facebook.presto.orc.stream.ValueStream;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;

public class DoubleStream
implements ValueStream<DoubleStreamCheckpoint> {
    private final OrcInputStream input;
    private final byte[] buffer = new byte[8192];
    private final Slice slice = Slices.wrappedBuffer((byte[])this.buffer);

    public DoubleStream(OrcInputStream input) {
        this.input = input;
    }

    @Override
    public Class<DoubleStreamCheckpoint> getCheckpointType() {
        return DoubleStreamCheckpoint.class;
    }

    @Override
    public void seekToCheckpoint(DoubleStreamCheckpoint checkpoint) throws IOException {
        this.input.seekToCheckpoint(checkpoint.getInputStreamCheckpoint());
    }

    @Override
    public void skip(int items) throws IOException {
        long length = items * 8;
        OrcStreamUtils.skipFully(this.input, length);
    }

    public double next() throws IOException {
        OrcStreamUtils.readFully(this.input, this.buffer, 0, 8);
        return this.slice.getDouble(0);
    }

    public void nextVector(int items, double[] vector) throws IOException {
        Preconditions.checkPositionIndex((int)items, (int)vector.length);
        Preconditions.checkPositionIndex((int)items, (int)1024);
        OrcStreamUtils.readFully(this.input, this.buffer, 0, items * 8);
        Slices.wrappedDoubleArray((double[])vector).setBytes(0, this.slice, 0, items * 8);
    }

    public void nextVector(long items, double[] vector, boolean[] isNull) throws IOException {
        int notNullCount = 0;
        int i = 0;
        while ((long)i < items) {
            if (!isNull[i]) {
                ++notNullCount;
            }
            ++i;
        }
        OrcStreamUtils.readFully(this.input, this.buffer, 0, notNullCount * 8);
        int elementIndex = 0;
        int i2 = 0;
        while ((long)i2 < items) {
            if (!isNull[i2]) {
                vector[i2] = this.slice.getDouble(elementIndex);
                elementIndex += 8;
            }
            ++i2;
        }
    }
}

