/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.ml;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Map;
import java.util.SortedMap;

public class FeatureVector {
    private final SortedMap<Integer, Double> features;

    @VisibleForTesting
    public FeatureVector(int feature, double value) {
        this.features = ImmutableSortedMap.of((Comparable)Integer.valueOf(feature), (Object)value);
    }

    public FeatureVector(Map<Integer, Double> features) {
        this.features = ImmutableSortedMap.copyOf(features);
    }

    public SortedMap<Integer, Double> getFeatures() {
        return this.features;
    }

    public int size() {
        return this.features.size();
    }

    public long getEstimatedSize() {
        return 84L * (long)this.size();
    }
}

