/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.plugin.jdbc.JdbcConnector;
import com.facebook.presto.plugin.jdbc.JdbcModule;
import com.facebook.presto.spi.Connector;
import com.facebook.presto.spi.ConnectorFactory;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import java.util.Map;

public class JdbcConnectorFactory
implements ConnectorFactory {
    private final String name;
    private final Module module;
    private final Map<String, String> optionalConfig;
    private final ClassLoader classLoader;

    public JdbcConnectorFactory(String name, Module module, Map<String, String> optionalConfig, ClassLoader classLoader) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or empty");
        this.name = name;
        this.module = (Module)Preconditions.checkNotNull((Object)module, (Object)"module is null");
        this.optionalConfig = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(optionalConfig, (Object)"optionalConfig is null")));
        this.classLoader = (ClassLoader)Preconditions.checkNotNull((Object)classLoader, (Object)"classLoader is null");
    }

    public String getName() {
        return this.name;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connector create(String connectorId, Map<String, String> requiredConfig) {
        Preconditions.checkNotNull(requiredConfig, (Object)"requiredConfig is null");
        Preconditions.checkNotNull(this.optionalConfig, (Object)"optionalConfig is null");
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Bootstrap app = new Bootstrap(new Module[]{new JdbcModule(connectorId), this.module});
            Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(requiredConfig).setOptionalConfigurationProperties(this.optionalConfig).initialize();
            Connector connector = (Connector)injector.getInstance(JdbcConnector.class);
            return connector;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

