/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.plugin.jdbc.JdbcColumnHandle;
import com.facebook.presto.plugin.jdbc.JdbcConnectorId;
import com.facebook.presto.plugin.jdbc.JdbcOutputTableHandle;
import com.facebook.presto.plugin.jdbc.JdbcSplit;
import com.facebook.presto.plugin.jdbc.JdbcTableHandle;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorIndexHandle;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.google.common.base.Preconditions;
import javax.inject.Inject;

public class JdbcHandleResolver
implements ConnectorHandleResolver {
    private final String connectorId;

    @Inject
    public JdbcHandleResolver(JdbcConnectorId clientId) {
        this.connectorId = ((JdbcConnectorId)Preconditions.checkNotNull((Object)clientId, (Object)"clientId is null")).toString();
    }

    public boolean canHandle(ConnectorTableHandle tableHandle) {
        return tableHandle instanceof JdbcTableHandle && ((JdbcTableHandle)tableHandle).getConnectorId().equals(this.connectorId);
    }

    public boolean canHandle(ConnectorColumnHandle columnHandle) {
        return columnHandle instanceof JdbcColumnHandle && ((JdbcColumnHandle)columnHandle).getConnectorId().equals(this.connectorId);
    }

    public boolean canHandle(ConnectorSplit split) {
        return split instanceof JdbcSplit && ((JdbcSplit)split).getConnectorId().equals(this.connectorId);
    }

    public boolean canHandle(ConnectorIndexHandle indexHandle) {
        return false;
    }

    public boolean canHandle(ConnectorOutputTableHandle tableHandle) {
        return tableHandle instanceof JdbcOutputTableHandle && ((JdbcOutputTableHandle)tableHandle).getConnectorId().equals(this.connectorId);
    }

    public boolean canHandle(ConnectorInsertTableHandle tableHandle) {
        return false;
    }

    public Class<? extends ConnectorTableHandle> getTableHandleClass() {
        return JdbcTableHandle.class;
    }

    public Class<? extends ConnectorColumnHandle> getColumnHandleClass() {
        return JdbcColumnHandle.class;
    }

    public Class<? extends ConnectorSplit> getSplitClass() {
        return JdbcSplit.class;
    }

    public Class<? extends ConnectorIndexHandle> getIndexHandleClass() {
        throw new UnsupportedOperationException();
    }

    public Class<? extends ConnectorOutputTableHandle> getOutputTableHandleClass() {
        return JdbcOutputTableHandle.class;
    }

    public Class<? extends ConnectorInsertTableHandle> getInsertTableHandleClass() {
        throw new UnsupportedOperationException();
    }
}

