/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.type.Type;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class JdbcOutputTableHandle
implements ConnectorOutputTableHandle {
    private final String connectorId;
    private final String catalogName;
    private final String schemaName;
    private final String tableName;
    private final List<String> columnNames;
    private final List<Type> columnTypes;
    private final String tableOwner;
    private final String temporaryTableName;
    private final String connectionUrl;
    private final Map<String, String> connectionProperties;

    @JsonCreator
    public JdbcOutputTableHandle(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="catalogName") @Nullable String catalogName, @JsonProperty(value="schemaName") @Nullable String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="columnNames") List<String> columnNames, @JsonProperty(value="columnTypes") List<Type> columnTypes, @JsonProperty(value="tableOwner") String tableOwner, @JsonProperty(value="temporaryTableName") String temporaryTableName, @JsonProperty(value="connectionUrl") String connectionUrl, @JsonProperty(value="connectionProperties") Map<String, String> connectionProperties) {
        this.connectorId = (String)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null");
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName, (Object)"tableName is null");
        this.tableOwner = (String)Preconditions.checkNotNull((Object)tableOwner, (Object)"tableOwner is null");
        this.temporaryTableName = (String)Preconditions.checkNotNull((Object)temporaryTableName, (Object)"temporaryTableName is null");
        this.connectionUrl = (String)Preconditions.checkNotNull((Object)connectionUrl, (Object)"connectionUrl is null");
        this.connectionProperties = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(connectionProperties, (Object)"connectionProperties is null")));
        Preconditions.checkNotNull(columnNames, (Object)"columnNames is null");
        Preconditions.checkNotNull(columnTypes, (Object)"columnTypes is null");
        Preconditions.checkArgument((columnNames.size() == columnTypes.size() ? 1 : 0) != 0, (Object)"columnNames and columnTypes sizes don't match");
        this.columnNames = ImmutableList.copyOf(columnNames);
        this.columnTypes = ImmutableList.copyOf(columnTypes);
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    @Nullable
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty
    @Nullable
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @JsonProperty
    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    @JsonProperty
    public String getTableOwner() {
        return this.tableOwner;
    }

    @JsonProperty
    public String getTemporaryTableName() {
        return this.temporaryTableName;
    }

    @JsonProperty
    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    @JsonProperty
    public Map<String, String> getConnectionProperties() {
        return this.connectionProperties;
    }

    public String toString() {
        return String.format("jdbc:%s.%s.%s", this.catalogName, this.schemaName, this.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.connectorId, this.catalogName, this.schemaName, this.tableName, this.columnNames, this.columnTypes, this.tableOwner, this.temporaryTableName, this.connectionUrl, this.connectionProperties);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JdbcOutputTableHandle other = (JdbcOutputTableHandle)obj;
        return Objects.equals(this.connectorId, other.connectorId) && Objects.equals(this.catalogName, other.catalogName) && Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.tableName, other.tableName) && Objects.equals(this.columnNames, other.columnNames) && Objects.equals(this.columnTypes, other.columnTypes) && Objects.equals(this.tableOwner, other.tableOwner) && Objects.equals(this.temporaryTableName, other.temporaryTableName) && Objects.equals(this.connectionUrl, other.connectionUrl) && Objects.equals(this.connectionProperties, other.connectionProperties);
    }
}

