/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.FixedWidthBlock;
import com.facebook.presto.spi.block.FixedWidthBlockEncoding;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.FixedWidthType;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Objects;

public abstract class AbstractFixedWidthBlock
implements Block {
    protected final FixedWidthType type;
    protected final int entrySize;

    protected AbstractFixedWidthBlock(FixedWidthType type) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.entrySize = type.getFixedSize();
    }

    protected abstract Slice getRawSlice();

    protected abstract boolean isEntryNull(int var1);

    @Override
    public FixedWidthType getType() {
        return this.type;
    }

    @Override
    public BlockEncoding getEncoding() {
        return new FixedWidthBlockEncoding(this.type);
    }

    @Override
    public boolean getBoolean(int position) {
        this.checkReadablePosition(position);
        return this.type.getBoolean(this.getRawSlice(), this.valueOffset(position));
    }

    @Override
    public long getLong(int position) {
        this.checkReadablePosition(position);
        return this.type.getLong(this.getRawSlice(), this.valueOffset(position));
    }

    @Override
    public double getDouble(int position) {
        this.checkReadablePosition(position);
        return this.type.getDouble(this.getRawSlice(), this.valueOffset(position));
    }

    @Override
    public Object getObjectValue(ConnectorSession session, int position) {
        this.checkReadablePosition(position);
        if (this.isNull(position)) {
            return null;
        }
        return this.type.getObjectValue(session, this.getRawSlice(), this.valueOffset(position));
    }

    @Override
    public Slice getSlice(int position) {
        this.checkReadablePosition(position);
        return this.type.getSlice(this.getRawSlice(), this.valueOffset(position));
    }

    @Override
    public Block getSingleValueBlock(int position) {
        this.checkReadablePosition(position);
        Slice copy = Slices.copyOf((Slice)this.getRawSlice(), (int)this.valueOffset(position), (int)this.entrySize);
        return new FixedWidthBlock(this.type, 1, copy, new boolean[]{this.isNull(position)});
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        return this.isEntryNull(position);
    }

    @Override
    public boolean equalTo(int position, Block otherBlock, int otherPosition) {
        boolean rightIsNull;
        boolean leftIsNull = this.isNull(position);
        if (leftIsNull != (rightIsNull = otherBlock.isNull(otherPosition))) {
            return false;
        }
        if (leftIsNull) {
            return true;
        }
        return otherBlock.equalTo(otherPosition, this.getRawSlice(), this.valueOffset(position), this.entrySize);
    }

    @Override
    public boolean equalTo(int position, Slice otherSlice, int otherOffset, int otherLength) {
        this.checkReadablePosition(position);
        return this.type.equalTo(this.getRawSlice(), this.valueOffset(position), otherSlice, otherOffset);
    }

    @Override
    public int hash(int position) {
        if (this.isNull(position)) {
            return 0;
        }
        return this.type.hash(this.getRawSlice(), this.valueOffset(position));
    }

    @Override
    public int compareTo(SortOrder sortOrder, int position, Block otherBlock, int otherPosition) {
        boolean leftIsNull = this.isNull(position);
        boolean rightIsNull = otherBlock.isNull(otherPosition);
        if (leftIsNull && rightIsNull) {
            return 0;
        }
        if (leftIsNull) {
            return sortOrder.isNullsFirst() ? -1 : 1;
        }
        if (rightIsNull) {
            return sortOrder.isNullsFirst() ? 1 : -1;
        }
        int result = -otherBlock.compareTo(otherPosition, this.getRawSlice(), this.valueOffset(position), this.entrySize);
        return sortOrder.isAscending() ? result : -result;
    }

    @Override
    public int compareTo(int position, Slice otherSlice, int otherOffset, int otherLength) {
        this.checkReadablePosition(position);
        return this.type.compareTo(this.getRawSlice(), this.valueOffset(position), otherSlice, otherOffset);
    }

    @Override
    public void appendTo(int position, BlockBuilder blockBuilder) {
        if (this.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            this.type.appendTo(this.getRawSlice(), this.valueOffset(position), blockBuilder);
        }
    }

    private int valueOffset(int position) {
        return position * this.entrySize;
    }

    protected void checkReadablePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
    }
}

