/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.block.VariableWidthBlock;
import com.facebook.presto.spi.block.VariableWidthBlockEncoding;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VariableWidthType;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

public abstract class AbstractVariableWidthBlock
implements Block {
    protected final VariableWidthType type;

    protected AbstractVariableWidthBlock(VariableWidthType type) {
        this.type = type;
    }

    protected abstract Slice getRawSlice();

    protected abstract int getPositionOffset(int var1);

    protected abstract int getPositionLength(int var1);

    protected abstract boolean isEntryNull(int var1);

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public BlockEncoding getEncoding() {
        return new VariableWidthBlockEncoding(this.type);
    }

    @Override
    public boolean getBoolean(int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong(int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getObjectValue(ConnectorSession session, int position) {
        if (this.isNull(position)) {
            return null;
        }
        return this.type.getObjectValue(session, this.getRawSlice(), this.getPositionOffset(position), this.getPositionLength(position));
    }

    @Override
    public Slice getSlice(int position) {
        if (this.isNull(position)) {
            throw new IllegalStateException("position is null");
        }
        return this.type.getSlice(this.getRawSlice(), this.getPositionOffset(position), this.getPositionLength(position));
    }

    @Override
    public Block getSingleValueBlock(int position) {
        if (this.isNull(position)) {
            return new VariableWidthBlock(this.type, 1, Slices.wrappedBuffer((byte[])new byte[0]), new int[]{0, 0}, new boolean[]{true});
        }
        int offset = this.getPositionOffset(position);
        int entrySize = this.getPositionLength(position);
        Slice copy = Slices.copyOf((Slice)this.getRawSlice(), (int)offset, (int)entrySize);
        return new VariableWidthBlock(this.type, 1, copy, new int[]{0, copy.length()}, new boolean[]{false});
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        return this.isEntryNull(position);
    }

    @Override
    public boolean equalTo(int position, Block otherBlock, int otherPosition) {
        boolean rightIsNull;
        boolean leftIsNull = this.isNull(position);
        if (leftIsNull != (rightIsNull = otherBlock.isNull(otherPosition))) {
            return false;
        }
        if (leftIsNull) {
            return true;
        }
        return otherBlock.equalTo(otherPosition, this.getRawSlice(), this.getPositionOffset(position), this.getPositionLength(position));
    }

    @Override
    public boolean equalTo(int position, Slice otherSlice, int otherOffset, int otherLength) {
        this.checkReadablePosition(position);
        return this.type.equalTo(this.getRawSlice(), this.getPositionOffset(position), this.getPositionLength(position), otherSlice, otherOffset, otherLength);
    }

    @Override
    public int hash(int position) {
        if (this.isNull(position)) {
            return 0;
        }
        return this.type.hash(this.getRawSlice(), this.getPositionOffset(position), this.getPositionLength(position));
    }

    @Override
    public int compareTo(SortOrder sortOrder, int position, Block otherBlock, int otherPosition) {
        boolean leftIsNull = this.isNull(position);
        boolean rightIsNull = otherBlock.isNull(otherPosition);
        if (leftIsNull && rightIsNull) {
            return 0;
        }
        if (leftIsNull) {
            return sortOrder.isNullsFirst() ? -1 : 1;
        }
        if (rightIsNull) {
            return sortOrder.isNullsFirst() ? 1 : -1;
        }
        int result = -otherBlock.compareTo(otherPosition, this.getRawSlice(), this.getPositionOffset(position), this.getPositionLength(position));
        return sortOrder.isAscending() ? result : -result;
    }

    @Override
    public int compareTo(int position, Slice otherSlice, int otherOffset, int otherLength) {
        this.checkReadablePosition(position);
        return this.type.compareTo(this.getRawSlice(), this.getPositionOffset(position), this.getPositionLength(position), otherSlice, otherOffset, otherLength);
    }

    @Override
    public void appendTo(int position, BlockBuilder blockBuilder) {
        if (this.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            this.type.appendTo(this.getRawSlice(), this.getPositionOffset(position), this.getPositionLength(position), blockBuilder);
        }
    }

    private void checkReadablePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
    }
}

