/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.AbstractFixedWidthBlock;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.BlockEncodingFactory;
import com.facebook.presto.spi.block.FixedWidthBlock;
import com.facebook.presto.spi.block.FixedWidthBlockBuilder;
import com.facebook.presto.spi.block.FixedWidthBlockEncoding;
import com.facebook.presto.spi.block.IsolatedFixedWidthBlockBuilderFactory;
import com.facebook.presto.spi.type.FixedWidthType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class FixedWidthBlockUtil {
    private FixedWidthBlockUtil() {
    }

    public static FixedWidthBlockBuilderFactory createIsolatedFixedWidthBlockBuilderFactory(FixedWidthType type) {
        Class<IsolatedFixedWidthBlockBuilderFactory> functionClass = FixedWidthBlockUtil.isolateClass(FixedWidthBlockBuilderFactory.class, IsolatedFixedWidthBlockBuilderFactory.class, AbstractFixedWidthBlock.class, FixedWidthBlock.class, FixedWidthBlockBuilder.class, FixedWidthBlockEncoding.class);
        try {
            return functionClass.getConstructor(FixedWidthType.class).newInstance(type);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> Class<? extends T> isolateClass(Class<T> publicBaseClass, Class<? extends T> implementationClass, Class<?> ... additionalClasses) {
        HashMap<String, byte[]> classByteCode = new HashMap<String, byte[]>();
        classByteCode.put(implementationClass.getName(), FixedWidthBlockUtil.getByteCode(implementationClass));
        for (Class<?> additionalClass : additionalClasses) {
            classByteCode.put(additionalClass.getName(), FixedWidthBlockUtil.getByteCode(additionalClass));
        }
        DynamicClassLoader dynamicClassLoader = new DynamicClassLoader(publicBaseClass.getClassLoader());
        Map<String, Class<?>> isolatedClasses = dynamicClassLoader.defineClasses(classByteCode);
        Class<?> isolatedClass = isolatedClasses.get(implementationClass.getName());
        if (isolatedClass == null) {
            throw new IllegalArgumentException(String.valueOf("Could load class " + implementationClass.getName()));
        }
        if (!publicBaseClass.isAssignableFrom(isolatedClass)) {
            throw new IllegalArgumentException(String.valueOf(String.format("Error isolating class %s, newly loaded class is not a sub type of %s", implementationClass.getName(), publicBaseClass.getName())));
        }
        if (isolatedClass == implementationClass) {
            throw new IllegalStateException(String.valueOf("Isolation failed"));
        }
        return isolatedClass.asSubclass(publicBaseClass);
    }

    private static byte[] getByteCode(Class<?> clazz) {
        InputStream stream = clazz.getClassLoader().getResourceAsStream(clazz.getName().replace('.', '/') + ".class");
        if (stream == null) {
            throw new IllegalArgumentException(String.valueOf("Could not obtain byte code for class " + clazz.getName()));
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int bytes = stream.read(buffer);
            while (bytes > 0) {
                out.write(buffer, 0, bytes);
                bytes = stream.read(buffer);
            }
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class DynamicClassLoader
    extends ClassLoader {
        private final ConcurrentMap<String, byte[]> pendingClasses = new ConcurrentHashMap<String, byte[]>();

        public DynamicClassLoader(ClassLoader parentClassLoader) {
            super(DynamicClassLoader.resolveClassLoader(parentClassLoader));
        }

        public Class<?> defineClass(String className, byte[] byteCode) {
            return this.defineClass(className, byteCode, 0, byteCode.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, Class<?>> defineClasses(Map<String, byte[]> newClasses) {
            TreeSet<String> conflicts = new TreeSet<String>(newClasses.keySet());
            conflicts.retainAll(this.pendingClasses.keySet());
            if (!conflicts.isEmpty()) {
                throw new IllegalArgumentException(String.valueOf("The classes " + conflicts + " have already been defined"));
            }
            this.pendingClasses.putAll(newClasses);
            try {
                HashMap classes = new HashMap();
                for (String className : newClasses.keySet()) {
                    try {
                        Class<?> clazz = this.loadClass(className);
                        classes.put(className, clazz);
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                HashMap hashMap = classes;
                return hashMap;
            }
            finally {
                this.pendingClasses.keySet().removeAll(newClasses.keySet());
            }
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            byte[] byteCode = (byte[])this.pendingClasses.get(name);
            if (byteCode == null) {
                throw new ClassNotFoundException(name);
            }
            return this.defineClass(name, byteCode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                Class<?> cachedClass = this.findLoadedClass(name);
                if (cachedClass != null) {
                    return this.resolveClass(cachedClass, resolve);
                }
                try {
                    Class<?> clazz = this.findClass(name);
                    return this.resolveClass(clazz, resolve);
                }
                catch (ClassNotFoundException ignored) {
                    Class<?> clazz = this.getParent().loadClass(name);
                    return this.resolveClass(clazz, resolve);
                }
            }
        }

        private Class<?> resolveClass(Class<?> clazz, boolean resolve) {
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }

        private static ClassLoader resolveClassLoader(ClassLoader parentClassLoader) {
            if (parentClassLoader == null) {
                parentClassLoader = Thread.currentThread().getContextClassLoader();
            }
            if (parentClassLoader == null) {
                parentClassLoader = DynamicClassLoader.class.getClassLoader();
            }
            if (parentClassLoader == null) {
                parentClassLoader = ClassLoader.getSystemClassLoader();
            }
            return parentClassLoader;
        }
    }

    public static interface FixedWidthBlockBuilderFactory {
        public BlockBuilder createFixedWidthBlockBuilder(BlockBuilderStatus var1);

        public BlockBuilder createFixedWidthBlockBuilder(int var1);

        public BlockEncodingFactory<?> getBlockEncodingFactory();
    }
}

