/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.AbstractVariableWidthBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.VariableWidthType;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import java.util.Arrays;

public class VariableWidthBlock
extends AbstractVariableWidthBlock {
    private final int positionCount;
    private final Slice slice;
    private final int[] offsets;
    private final boolean[] valueIsNull;

    public VariableWidthBlock(VariableWidthType type, int positionCount, Slice slice, int[] offsets, boolean[] valueIsNull) {
        super(type);
        this.positionCount = positionCount;
        this.slice = slice;
        if (offsets.length < positionCount + 1) {
            throw new IllegalArgumentException("offsets length is less than positionCount");
        }
        this.offsets = offsets;
        if (valueIsNull.length < positionCount) {
            throw new IllegalArgumentException("valueIsNull length is less than positionCount");
        }
        this.valueIsNull = valueIsNull;
    }

    @Override
    protected final int getPositionOffset(int position) {
        return this.offsets[position];
    }

    @Override
    protected int getPositionLength(int position) {
        return this.offsets[position + 1] - this.offsets[position];
    }

    @Override
    protected boolean isEntryNull(int position) {
        return this.valueIsNull[position];
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public int getSizeInBytes() {
        long size = (long)this.getRawSlice().length() + SizeOf.sizeOf((int[])this.offsets) + SizeOf.sizeOf((boolean[])this.valueIsNull);
        if (size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)size;
    }

    @Override
    protected Slice getRawSlice() {
        return this.slice;
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        int positionCount = this.getPositionCount();
        if (positionOffset < 0 || length < 0 || positionOffset + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + positionCount + " positions");
        }
        int[] newOffsets = Arrays.copyOfRange(this.offsets, positionOffset, positionOffset + length + 1);
        boolean[] newValueIsNull = Arrays.copyOfRange(this.valueIsNull, positionOffset, positionOffset + length);
        return new VariableWidthBlock(this.type, length, this.slice, newOffsets, newValueIsNull);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VariableWidthBlock{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append(", slice=").append(this.getRawSlice());
        sb.append('}');
        return sb.toString();
    }
}

