/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.type;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.BlockEncodingFactory;
import com.facebook.presto.spi.block.FixedWidthBlockUtil;
import com.facebook.presto.spi.type.FixedWidthType;
import com.facebook.presto.spi.type.SqlTime;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;

public final class TimeType
implements FixedWidthType {
    public static final TimeType TIME = new TimeType();
    private static final FixedWidthBlockUtil.FixedWidthBlockBuilderFactory BLOCK_BUILDER_FACTORY = FixedWidthBlockUtil.createIsolatedFixedWidthBlockBuilderFactory(TIME);
    public static final BlockEncodingFactory<?> BLOCK_ENCODING_FACTORY = BLOCK_BUILDER_FACTORY.getBlockEncodingFactory();

    public static TimeType getInstance() {
        return TIME;
    }

    private TimeType() {
    }

    @Override
    public String getName() {
        return "time";
    }

    @Override
    public Class<?> getJavaType() {
        return Long.TYPE;
    }

    @Override
    public int getFixedSize() {
        return 8;
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Slice slice, int offset) {
        return new SqlTime(slice.getLong(offset), session.getTimeZoneKey());
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus) {
        return BLOCK_BUILDER_FACTORY.createFixedWidthBlockBuilder(blockBuilderStatus);
    }

    @Override
    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return BLOCK_BUILDER_FACTORY.createFixedWidthBlockBuilder(positionCount);
    }

    @Override
    public boolean getBoolean(Slice slice, int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeBoolean(SliceOutput sliceOutput, boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong(Slice slice, int offset) {
        return slice.getLong(offset);
    }

    @Override
    public void writeLong(SliceOutput sliceOutput, long value) {
        sliceOutput.writeLong(value);
    }

    @Override
    public double getDouble(Slice slice, int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeDouble(SliceOutput sliceOutput, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Slice getSlice(Slice slice, int offset) {
        return slice.slice(offset, this.getFixedSize());
    }

    @Override
    public void writeSlice(SliceOutput sliceOutput, Slice value, int offset) {
        sliceOutput.writeBytes(value, offset, 8);
    }

    @Override
    public boolean equalTo(Slice leftSlice, int leftOffset, Slice rightSlice, int rightOffset) {
        long rightValue;
        long leftValue = leftSlice.getLong(leftOffset);
        return leftValue == (rightValue = rightSlice.getLong(rightOffset));
    }

    @Override
    public int hash(Slice slice, int offset) {
        long value = slice.getLong(offset);
        return (int)(value ^ value >>> 32);
    }

    @Override
    public int compareTo(Slice leftSlice, int leftOffset, Slice rightSlice, int rightOffset) {
        long leftValue = leftSlice.getLong(leftOffset);
        long rightValue = rightSlice.getLong(rightOffset);
        return Long.compare(leftValue, rightValue);
    }

    @Override
    public void appendTo(Slice slice, int offset, BlockBuilder blockBuilder) {
        long value = slice.getLong(offset);
        blockBuilder.appendLong(value);
    }

    @Override
    public void appendTo(Slice slice, int offset, SliceOutput sliceOutput) {
        sliceOutput.writeBytes(slice, offset, 8);
    }

    public String toString() {
        return this.getName();
    }
}

